/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.xml;

import java.io.Reader;
import java.io.StringReader;
import net.opengis.gml.GridType;
import net.opengis.wcs10.AxisSubsetType;
import net.opengis.wcs10.GetCoverageType;
import net.opengis.wcs10.IntervalType;
import net.opengis.wcs10.RangeSubsetType;
import org.geoserver.wcs.test.WCSTestSupport;
import org.geoserver.wcs.xml.v1_0_0.WcsXmlReader;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.wcs.WCSConfiguration;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.referencing.IdentifiedObject;
import org.vfny.geoserver.wcs.WcsException;

public class GetCoverageXmlParserTest
extends WCSTestSupport {
    private WCSConfiguration configuration;
    private WcsXmlReader reader;

    protected void oneTimeSetUp() throws Exception {
        super.oneTimeSetUp();
        this.configuration = new WCSConfiguration();
        this.reader = new WcsXmlReader("GetCoverage", "1.0.0", this.configuration);
    }

    public void testInvalid() throws Exception {
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<GetCoverage service=\"WCS\" version=\"1.0.0\"  xmlns=\"http://www.opengis.net/wcs\"   xmlns:nurc=\"http://www.nurc.nato.int\"  xmlns:ogc=\"http://www.opengis.net/ogc\"  xmlns:gml=\"http://www.opengis.net/gml\"   xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"   xsi:schemaLocation=\"http://www.opengis.net/wcs schemas/wcs/1.0.0/getCoverage.xsd\"> <sourceCoverage>nurc:Pk50095</sourceCoverage></GetCoverage>";
        try {
            GetCoverageType cov = (GetCoverageType)this.reader.read(null, (Reader)new StringReader(request), null);
            GetCoverageXmlParserTest.fail((String)"This request is not valid!!!");
        }
        catch (WcsException wcsException) {
            // empty catch block
        }
    }

    public void testBasic() throws Exception {
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<GetCoverage service=\"WCS\" version=\"1.0.0\"  xmlns=\"http://www.opengis.net/wcs\"   xmlns:nurc=\"http://www.nurc.nato.int\"  xmlns:ogc=\"http://www.opengis.net/ogc\"  xmlns:gml=\"http://www.opengis.net/gml\"   xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"   xsi:schemaLocation=\"http://www.opengis.net/wcs schemas/wcs/1.0.0/getCoverage.xsd\">  <sourceCoverage>nurc:Pk50095</sourceCoverage>    <domainSubset>      <spatialSubset>        <gml:Envelope srsName=\"EPSG:32633\">          <gml:pos>347649.93086859107 5176214.082539256</gml:pos>          <gml:pos>370725.976428591 5196961.352859256</gml:pos>        </gml:Envelope>        <gml:Grid dimension=\"2\" srsName=\"EPSG:4326\">          <gml:limits>            <gml:GridEnvelope>              <gml:low>0 0</gml:low>              <gml:high>545 490</gml:high>            </gml:GridEnvelope>          </gml:limits>          <gml:axisName>Lon</gml:axisName>          <gml:axisName>Lat</gml:axisName>        </gml:Grid>      </spatialSubset>    </domainSubset>    <output>      <crs>EPSG:4326</crs>      <format>TIFF</format>    </output></GetCoverage>";
        GetCoverageType gc = (GetCoverageType)this.reader.read(null, (Reader)new StringReader(request), null);
        GetCoverageXmlParserTest.assertEquals((String)"WCS", (String)gc.getService());
        GetCoverageXmlParserTest.assertEquals((String)"1.0.0", (String)gc.getVersion());
        GetCoverageXmlParserTest.assertEquals((String)"nurc:Pk50095", (String)gc.getSourceCoverage());
        GeneralEnvelope envelope = (GeneralEnvelope)gc.getDomainSubset().getSpatialSubset().getEnvelope().get(0);
        GetCoverageXmlParserTest.assertEquals((String)"EPSG:32633", (String)CRS.lookupIdentifier((IdentifiedObject)envelope.getCoordinateReferenceSystem(), (boolean)true));
        GetCoverageXmlParserTest.assertEquals((Object)347649.93086859107, (Object)envelope.getLowerCorner().getOrdinate(0));
        GetCoverageXmlParserTest.assertEquals((Object)5176214.082539256, (Object)envelope.getLowerCorner().getOrdinate(1));
        GetCoverageXmlParserTest.assertEquals((Object)370725.976428591, (Object)envelope.getUpperCorner().getOrdinate(0));
        GetCoverageXmlParserTest.assertEquals((Object)5196961.352859256, (Object)envelope.getUpperCorner().getOrdinate(1));
        GetCoverageXmlParserTest.assertNotNull((Object)gc.getOutput().getCrs());
        GetCoverageXmlParserTest.assertEquals((String)"EPSG:4326", (String)gc.getOutput().getCrs().getValue());
        GetCoverageXmlParserTest.assertNotNull((Object)gc.getOutput().getFormat());
        GetCoverageXmlParserTest.assertEquals((String)"TIFF", (String)gc.getOutput().getFormat().getValue());
    }

    public void testRangeSubsetKeys() throws Exception {
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<GetCoverage service=\"WCS\" version=\"1.0.0\"  xmlns=\"http://www.opengis.net/wcs\"   xmlns:nurc=\"http://www.nurc.nato.int\"  xmlns:ogc=\"http://www.opengis.net/ogc\"  xmlns:gml=\"http://www.opengis.net/gml\"   xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"   xsi:schemaLocation=\"http://www.opengis.net/wcs schemas/wcs/1.0.0/getCoverage.xsd\">  <sourceCoverage>nurc:Pk50095</sourceCoverage>    <domainSubset>      <spatialSubset>        <gml:Envelope srsName=\"EPSG:32633\">          <gml:pos>347649.93086859107 5176214.082539256</gml:pos>          <gml:pos>370725.976428591 5196961.352859256</gml:pos>        </gml:Envelope>        <gml:Grid dimension=\"2\" srsName=\"EPSG:4326\">          <gml:limits>            <gml:GridEnvelope>              <gml:low>0 0</gml:low>              <gml:high>545 490</gml:high>            </gml:GridEnvelope>          </gml:limits>          <gml:axisName>Column</gml:axisName>          <gml:axisName>Row</gml:axisName>        </gml:Grid>      </spatialSubset>    </domainSubset>    <rangeSubset>       <axisSubset name=\"Band\">          <interval atomic=\"false\">               <min>1</min>               <max>3</max>               <res>1</res>          </interval>       </axisSubset>    </rangeSubset>    <output>      <crs>EPSG:4326</crs>      <format>TIFF</format>    </output></GetCoverage>";
        GetCoverageType gc = (GetCoverageType)this.reader.read(null, (Reader)new StringReader(request), null);
        GetCoverageXmlParserTest.assertEquals((int)1, (int)gc.getRangeSubset().getAxisSubset().size());
        GridType grid = (GridType)gc.getDomainSubset().getSpatialSubset().getGrid().get(0);
        GetCoverageXmlParserTest.assertEquals((String)grid.getSrsName(), (String)"EPSG:4326");
        GetCoverageXmlParserTest.assertEquals((Object)grid.getAxisName().get(0), (Object)"Column");
        GetCoverageXmlParserTest.assertEquals((Object)grid.getAxisName().get(1), (Object)"Row");
        GridEnvelope gridLimits = grid.getLimits();
        GetCoverageXmlParserTest.assertEquals((int)0, (int)gridLimits.getLow(0));
        GetCoverageXmlParserTest.assertEquals((int)0, (int)gridLimits.getLow(1));
        GetCoverageXmlParserTest.assertEquals((int)544, (int)gridLimits.getHigh(0));
        GetCoverageXmlParserTest.assertEquals((int)489, (int)gridLimits.getHigh(1));
        RangeSubsetType rangeSet = gc.getRangeSubset();
        AxisSubsetType axisSubset = (AxisSubsetType)rangeSet.getAxisSubset().get(0);
        GetCoverageXmlParserTest.assertEquals((String)"Band", (String)axisSubset.getName());
        GetCoverageXmlParserTest.assertEquals((int)axisSubset.getSingleValue().size(), (int)0);
        GetCoverageXmlParserTest.assertEquals((int)axisSubset.getInterval().size(), (int)1);
        IntervalType interval = (IntervalType)axisSubset.getInterval().get(0);
        GetCoverageXmlParserTest.assertEquals((String)"1", (String)interval.getMin().getValue());
        GetCoverageXmlParserTest.assertEquals((String)"3", (String)interval.getMax().getValue());
        GetCoverageXmlParserTest.assertEquals((String)"1", (String)interval.getRes().getValue());
    }
}

