/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.bio.SocketConnector;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.xml.XmlConfiguration;

public class Start {
    private static final Logger log = Logging.getLogger((String)Start.class.getName());

    public static void main(String[] args) {
        block6: {
            Server jettyServer = null;
            try {
                jettyServer = new Server();
                SocketConnector conn = new SocketConnector();
                String portVariable = System.getProperty("jetty.port");
                int port = Start.parsePort(portVariable);
                if (port <= 0) {
                    port = 8080;
                }
                conn.setPort(port);
                conn.setAcceptQueueSize(100);
                conn.setMaxIdleTime(3600000);
                conn.setSoLingerTime(-1);
                jettyServer.setConnectors(new Connector[]{conn});
                WebAppContext wah = new WebAppContext();
                wah.setParentLoaderPriority(false);
                wah.setContextPath("/geoserver");
                wah.setWar("src/main/webapp");
                jettyServer.setHandler((Handler)wah);
                wah.setTempDirectory(new File("target/work"));
                String jettyConfigFile = System.getProperty("jetty.config.file");
                if (jettyConfigFile != null) {
                    log.info("Loading Jetty config from file: " + jettyConfigFile);
                    new XmlConfiguration((InputStream)new FileInputStream(jettyConfigFile)).configure((Object)jettyServer);
                }
                jettyServer.start();
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Could not start the Jetty server: " + e.getMessage(), e);
                if (jettyServer == null) break block6;
                try {
                    jettyServer.stop();
                }
                catch (Exception e1) {
                    log.log(Level.SEVERE, "Unable to stop the Jetty server:" + e1.getMessage(), e1);
                }
            }
        }
    }

    private static int parsePort(String portVariable) {
        if (portVariable == null) {
            return -1;
        }
        try {
            return Integer.valueOf(portVariable);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }
}

