/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.filters;

import com.mockrunner.mock.web.MockHttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.geoserver.filters.GZIPResponseStream;
import org.geoserver.test.GeoServerTestSupport;

public class GZIPResponseStreamTest
extends GeoServerTestSupport {
    public void testStream() throws Exception {
        ByteStreamCapturingHttpServletResponse response = new ByteStreamCapturingHttpServletResponse((HttpServletResponse)new MockHttpServletResponse());
        GZIPResponseStream stream = new GZIPResponseStream((HttpServletResponse)response);
        stream.write("Hello world!".getBytes());
        stream.flush();
        stream.close();
        GZIPResponseStreamTest.assertEquals((String)"Hello world!", (String)new String(this.unzip(response.toByteArray())));
    }

    private byte[] unzip(byte[] zipped) throws Exception {
        int character;
        GZIPInputStream stream = new GZIPInputStream(new ByteArrayInputStream(zipped));
        ArrayList<Byte> builder = new ArrayList<Byte>();
        while ((character = ((InputStream)stream).read()) != -1) {
            builder.add((byte)character);
        }
        byte[] results = new byte[builder.size()];
        for (int i = 0; i < builder.size(); ++i) {
            results[i] = (Byte)builder.get(i);
        }
        return results;
    }

    private static class ByteStreamCapturingHttpServletResponse
    extends HttpServletResponseWrapper {
        CapturingByteOutputStream myOutputStream;

        public ByteStreamCapturingHttpServletResponse(HttpServletResponse r) {
            super(r);
        }

        public ServletOutputStream getOutputStream() throws IOException {
            if (this.myOutputStream == null) {
                this.myOutputStream = new CapturingByteOutputStream();
            }
            return this.myOutputStream;
        }

        public byte[] toByteArray() {
            return this.myOutputStream.toByteArray();
        }
    }

    private static class CapturingByteOutputStream
    extends ServletOutputStream {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();

        private CapturingByteOutputStream() {
        }

        public void write(int b) {
            this.bos.write(b);
        }

        public byte[] toByteArray() {
            return this.bos.toByteArray();
        }
    }
}

