/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.filters;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Set;
import java.util.logging.Logger;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.geoserver.filters.AlternativesResponseStream;
import org.geotools.util.logging.Logging;

public class GZIPResponseWrapper
extends HttpServletResponseWrapper {
    protected HttpServletResponse origResponse = null;
    protected AlternativesResponseStream stream = null;
    protected PrintWriter writer = null;
    protected Set formatsToCompress;
    protected String requestedURL;
    protected Logger logger = Logging.getLogger((String)"org.geoserver.filters");

    public GZIPResponseWrapper(HttpServletResponse response, Set toCompress, String url) {
        super(response);
        this.requestedURL = url;
        this.origResponse = response;
        this.formatsToCompress = toCompress;
    }

    protected AlternativesResponseStream createOutputStream() throws IOException {
        return new AlternativesResponseStream(this.origResponse, this.formatsToCompress);
    }

    public void setContentType(String type) {
        this.origResponse.setContentType(type);
    }

    public void finishResponse() {
        try {
            if (this.writer != null) {
                this.writer.close();
            } else if (this.stream != null) {
                this.stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void flushBuffer() throws IOException {
        if (this.writer != null) {
            this.writer.flush();
        } else if (this.stream != null) {
            this.stream.flush();
        }
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.writer != null) {
            throw new IllegalStateException("getWriter() has already been called!");
        }
        if (this.stream == null) {
            this.stream = this.createOutputStream();
        }
        return this.stream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer != null) {
            return this.writer;
        }
        if (this.stream != null) {
            throw new IllegalStateException("getOutputStream() has already been called!");
        }
        this.stream = this.createOutputStream();
        this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.stream, "UTF-8"));
        return this.writer;
    }

    public void setContentLength(int length) {
    }
}

