/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.kvp;

import java.util.HashMap;
import java.util.Map;
import net.opengis.wfs.GetFeatureType;
import net.opengis.wfs.WfsFactory;
import org.geoserver.test.ows.KvpRequestReaderTestSupport;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.kvp.GetFeatureKvpRequestReader;
import org.geotools.factory.CommonFactoryFinder;

public class GetFeatureKvpRequestReaderTest
extends KvpRequestReaderTestSupport {
    private GetFeatureKvpRequestReader reader;

    protected void setUpInternal() throws Exception {
        super.setUpInternal();
        this.reader = new GetFeatureKvpRequestReader(GetFeatureType.class, this.getCatalog(), CommonFactoryFinder.getFilterFactory(null));
    }

    public void testInvalidTypeNameBbox() throws Exception {
        HashMap<String, String> raw = new HashMap<String, String>();
        raw.put("service", "WFS");
        raw.put("version", "1.1.0");
        raw.put("method", "GetFeature");
        raw.put("bbox", "-80.4864795578115,25.6176257083275,-80.3401307394915,25.7002737069969");
        raw.put("typeName", "cite:InvalidTypeName");
        Map parsed = this.parseKvp(raw);
        try {
            this.reader.read((Object)WfsFactory.eINSTANCE.createGetFeatureType(), parsed, raw);
        }
        catch (WFSException e) {
            GetFeatureKvpRequestReaderTest.assertEquals((String)"InvalidParameterValue", (String)e.getCode());
            GetFeatureKvpRequestReaderTest.assertEquals((String)"typeName", (String)e.getLocator());
            System.out.println(e.getMessage());
            GetFeatureKvpRequestReaderTest.assertTrue((boolean)e.getMessage().contains("cite:InvalidTypeName"));
        }
    }

    public void testInvalidTypeName() throws Exception {
        HashMap<String, String> raw = new HashMap<String, String>();
        raw.put("service", "WFS");
        raw.put("version", "1.1.0");
        raw.put("method", "GetFeature");
        raw.put("typeName", "InvalidTypeName");
        Map parsed = this.parseKvp(raw);
        try {
            this.reader.read((Object)WfsFactory.eINSTANCE.createGetFeatureType(), parsed, raw);
        }
        catch (WFSException e) {
            GetFeatureKvpRequestReaderTest.assertEquals((String)"InvalidParameterValue", (String)e.getCode());
            GetFeatureKvpRequestReaderTest.assertEquals((String)"typeName", (String)e.getLocator());
            System.out.println(e.getMessage());
            GetFeatureKvpRequestReaderTest.assertTrue((boolean)e.getMessage().contains("InvalidTypeName"));
        }
    }
}

