/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.nio.charset.Charset;
import java.util.ArrayList;
import net.opengis.wfs.GetCapabilitiesType;
import org.eclipse.emf.common.util.EList;
import org.geoserver.catalog.Catalog;
import org.geoserver.ows.util.RequestUtils;
import org.geoserver.wfs.CapabilitiesTransformer;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.WFSInfo;

public class GetCapabilities {
    WFSInfo wfs;
    Catalog catalog;

    public GetCapabilities(WFSInfo wfs, Catalog catalog) {
        this.wfs = wfs;
        this.catalog = catalog;
    }

    public CapabilitiesTransformer run(GetCapabilitiesType request) throws WFSException {
        CapabilitiesTransformer capsTransformer;
        String version;
        if (this.wfs.isCiteCompliant() && request.getUpdateSequence() != null) {
            throw new WFSException("Invalid update sequence", "InvalidUpdateSequence");
        }
        if (this.wfs.isCiteCompliant() && !request.isSetService()) {
            throw new WFSException("Service not set", "MissingParameterValue", "service");
        }
        ArrayList<String> provided = new ArrayList<String>();
        provided.add("1.0.0");
        provided.add("1.1.0");
        EList accepted = null;
        if (request.getAcceptVersions() != null) {
            accepted = request.getAcceptVersions().getVersion();
        }
        if ("1.0.0".equals(version = RequestUtils.getVersionPreOws(provided, accepted))) {
            capsTransformer = new CapabilitiesTransformer.WFS1_0(this.wfs, this.catalog);
        } else if ("1.1.0".equals(version)) {
            capsTransformer = new CapabilitiesTransformer.WFS1_1(this.wfs, this.catalog);
        } else {
            throw new WFSException("Could not understand version:" + version);
        }
        capsTransformer.setEncoding(Charset.forName(this.wfs.getGeoServer().getGlobal().getCharset()));
        return capsTransformer;
    }
}

