/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Set;
import java.util.logging.Logger;
import net.opengis.wfs.FeatureCollectionType;
import net.opengis.wfs.GetFeatureType;
import net.opengis.wfs.ResultTypeType;
import org.geoserver.ows.Response;
import org.geoserver.ows.util.OwsUtils;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geotools.util.logging.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WFSGetFeatureOutputFormat
extends Response {
    protected static Logger LOGGER = Logging.getLogger((String)"org.geoserver.wfs");

    public WFSGetFeatureOutputFormat(String outputFormat) {
        super(FeatureCollectionType.class, outputFormat);
    }

    public WFSGetFeatureOutputFormat(Set<String> outputFormats) {
        super(FeatureCollectionType.class, outputFormats);
    }

    public String getMimeType(Object value, Operation operation) throws ServiceException {
        return "text/xml";
    }

    public boolean canHandle(Operation operation) {
        GetFeatureType request;
        if (("GetFeature".equalsIgnoreCase(operation.getId()) || "GetFeatureWithLock".equalsIgnoreCase(operation.getId())) && (request = (GetFeatureType)OwsUtils.parameter((Object[])operation.getParameters(), GetFeatureType.class)).getResultType() == ResultTypeType.RESULTS_LITERAL) {
            return this.canHandleInternal(operation);
        }
        return false;
    }

    public String getCapabilitiesElementName() {
        LOGGER.severe("ERROR IN " + ((Object)((Object)this)).getClass() + " IMPLEMENTATION.  getCapabilitiesElementName() should return a" + "valid XML element name string for use in the WFS 1.0.0 capabilities document.");
        String of = this.getOutputFormat();
        if (of.matches("(\\w)+")) {
            return this.getOutputFormat();
        }
        String name = ((Object)((Object)this)).getClass().getName();
        if (name.indexOf(46) != -1) {
            name = name.substring(name.lastIndexOf(46) + 1);
        }
        return name;
    }

    protected boolean canHandleInternal(Operation operation) {
        return true;
    }

    public final void write(Object value, OutputStream output, Operation operation) throws IOException, ServiceException {
        this.write((FeatureCollectionType)value, output, operation);
    }

    protected abstract void write(FeatureCollectionType var1, OutputStream var2, Operation var3) throws IOException, ServiceException;
}

