/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.xml;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.geoserver.wfs.xml.GMLSchemaTranslator;
import org.geoserver.wfs.xml.NameSpaceTranslator;
import org.geoserver.wfs.xml.XMLSchemaTranslator;

public class NameSpaceTranslatorFactory {
    private Map namespaceTranslators = new HashMap();
    private Map namespaceTranslatorInstances = new HashMap();
    private static final NameSpaceTranslatorFactory instance = new NameSpaceTranslatorFactory();

    private NameSpaceTranslatorFactory() {
        this.namespaceTranslators.put("http://www.w3.org/2001/XMLSchema", XMLSchemaTranslator.class);
        this.namespaceTranslators.put("http://www.opengis.net/gml", GMLSchemaTranslator.class);
        this.addNameSpaceTranslator("xs", "http://www.w3.org/2001/XMLSchema");
        this.addNameSpaceTranslator("xsd", "http://www.w3.org/2001/XMLSchema");
        this.addNameSpaceTranslator("gml", "http://www.opengis.net/gml");
    }

    public static NameSpaceTranslatorFactory getInstance() {
        return instance;
    }

    public void addNameSpaceTranslator(String prefix, String namespace) {
        if (prefix == null || namespace == null) {
            throw new NullPointerException();
        }
        try {
            Class nstClass = (Class)this.namespaceTranslators.get(namespace);
            if (nstClass == null) {
                return;
            }
            Constructor nstConstructor = nstClass.getConstructor(String.class);
            NameSpaceTranslator nst = (NameSpaceTranslator)nstConstructor.newInstance(prefix);
            this.namespaceTranslatorInstances.put(prefix, nst);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public NameSpaceTranslator getNameSpaceTranslator(String prefix) {
        return (NameSpaceTranslator)this.namespaceTranslatorInstances.get(prefix);
    }

    public void registerNameSpaceTranslator(String namespace, Class nameSpaceTranslator) {
        if (nameSpaceTranslator != null && NameSpaceTranslator.class.isAssignableFrom(nameSpaceTranslator)) {
            this.namespaceTranslators.put(namespace, nameSpaceTranslator);
        }
    }
}

