/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import java.util.List;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.ows.Request;
import org.geoserver.ows.WorkspaceQualifyingCallback;
import org.geoserver.ows.util.KvpUtils;
import org.geoserver.platform.Operation;
import org.geoserver.platform.Service;
import org.geoserver.wms.GetCapabilitiesRequest;
import org.geoserver.wms.WebMapService;

public class WMSWorkspaceQualifier
extends WorkspaceQualifyingCallback {
    public WMSWorkspaceQualifier(Catalog catalog) {
        super(catalog);
    }

    protected void qualifyRequest(WorkspaceInfo ws, LayerInfo l, Service service, Request request) {
        if (WebMapService.class.isInstance(service.getService())) {
            String layer;
            String layers = (String)request.getRawKvp().get("LAYERS");
            if (layers != null) {
                request.getRawKvp().put("LAYERS", this.qualifyLayerNamesKVP(layers, ws));
            }
            if ((layers = (String)request.getRawKvp().get("QUERY_LAYERS")) != null) {
                request.getRawKvp().put("QUERY_LAYERS", this.qualifyLayerNamesKVP(layers, ws));
            }
            if ((layer = (String)request.getRawKvp().get("LAYER")) != null) {
                request.getRawKvp().put("LAYER", this.qualifyName(layer, ws));
            }
        }
    }

    protected void qualifyRequest(WorkspaceInfo ws, LayerInfo l, Operation operation, Request request) {
        GetCapabilitiesRequest gc = (GetCapabilitiesRequest)this.parameter(operation, GetCapabilitiesRequest.class);
        if (gc != null) {
            gc.setNamespace(ws.getName());
            return;
        }
    }

    String qualifyLayerNamesKVP(String layers, WorkspaceInfo ws) {
        List list = KvpUtils.readFlat((String)layers);
        this.qualifyNames(list, ws);
        StringBuffer sb = new StringBuffer();
        for (String s : list) {
            sb.append(s).append(",");
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }
}

