/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.capabilities;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import org.apache.xalan.transformer.TransformerIdentityImpl;
import org.geoserver.catalog.AttributionInfo;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.LegendInfo;
import org.geoserver.catalog.MetadataLinkInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.config.ContactInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.ExtendedCapabilitiesProvider;
import org.geoserver.wms.GetCapabilitiesRequest;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.capabilities.LayerTree;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.factory.GeoTools;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.styling.Style;
import org.geotools.util.logging.Logging;
import org.geotools.xml.transform.TransformerBase;
import org.geotools.xml.transform.Translator;
import org.opengis.feature.type.Name;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;
import org.springframework.util.Assert;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetCapabilitiesTransformer
extends TransformerBase {
    public static final String WMS_CAPS_MIME = "application/vnd.ogc.wms_xml";
    static final String[] EXCEPTION_FORMATS = new String[]{"application/vnd.ogc.se_xml", "application/vnd.ogc.se_inimage"};
    private String baseURL;
    private Set<String> getMapFormats;
    private Set<String> getLegendGraphicFormats;
    private WMS wmsConfig;
    private Collection<ExtendedCapabilitiesProvider> extCapsProviders;

    public GetCapabilitiesTransformer(WMS wms, String baseURL, Set<String> getMapFormats, Set<String> getLegendGraphicFormats, Collection<ExtendedCapabilitiesProvider> extCapsProviders) {
        Assert.notNull((Object)wms);
        Assert.notNull((Object)baseURL, (String)"baseURL");
        Assert.notNull(getMapFormats, (String)"getMapFormats");
        Assert.notNull(getLegendGraphicFormats, (String)"getLegendGraphicFormats");
        this.wmsConfig = wms;
        this.getMapFormats = getMapFormats;
        this.getLegendGraphicFormats = getLegendGraphicFormats;
        this.baseURL = baseURL;
        this.extCapsProviders = extCapsProviders == null ? Collections.EMPTY_LIST : extCapsProviders;
        this.setNamespaceDeclarationEnabled(false);
        this.setIndentation(2);
        Charset encoding = wms.getCharSet();
        this.setEncoding(encoding);
    }

    public Translator createTranslator(ContentHandler handler) {
        return new CapabilitiesTranslator(handler, this.wmsConfig, this.getMapFormats, this.getLegendGraphicFormats, this.extCapsProviders);
    }

    public Transformer createTransformer() throws TransformerException {
        Transformer transformer = super.createTransformer();
        String dtdUrl = ResponseUtils.buildSchemaURL((String)this.baseURL, (String)"wms/1.1.1/WMS_MS_Capabilities.dtd");
        transformer.setOutputProperty("doctype-system", dtdUrl);
        return transformer;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CapabilitiesTranslator
    extends TransformerBase.TranslatorSupport {
        private static final Logger LOGGER = Logging.getLogger((String)CapabilitiesTranslator.class.getPackage().getName());
        private static final String EPSG = "EPSG:";
        private static AttributesImpl wmsVersion = new AttributesImpl();
        private static final String XLINK_NS = "http://www.w3.org/1999/xlink";
        private GetCapabilitiesRequest request;
        private Set<String> getMapFormats;
        private Set<String> getLegendGraphicFormats;
        private WMS wmsConfig;
        private Collection<ExtendedCapabilitiesProvider> extCapsProviders;

        static {
            wmsVersion.addAttribute("", "version", "version", "", "1.1.1");
        }

        public CapabilitiesTranslator(ContentHandler handler, WMS wmsConfig, Set<String> getMapFormats, Set<String> getLegendGraphicFormats, Collection<ExtendedCapabilitiesProvider> extCapsProviders) {
            super(handler, null, null);
            this.wmsConfig = wmsConfig;
            this.getMapFormats = getMapFormats;
            this.getLegendGraphicFormats = getLegendGraphicFormats;
            this.extCapsProviders = extCapsProviders;
        }

        public void encode(Object o) throws IllegalArgumentException {
            if (!(o instanceof GetCapabilitiesRequest)) {
                throw new IllegalArgumentException();
            }
            this.request = (GetCapabilitiesRequest)o;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(new StringBuffer("producing a capabilities document for ").append(this.request).toString());
            }
            AttributesImpl rootAtts = new AttributesImpl(wmsVersion);
            rootAtts.addAttribute("", "updateSequence", "updateSequence", "", String.valueOf(this.wmsConfig.getUpdateSequence()));
            this.start("WMT_MS_Capabilities", rootAtts);
            this.handleService();
            this.handleCapability();
            this.end("WMT_MS_Capabilities");
        }

        private void handleService() {
            this.start("Service");
            WMSInfo serviceInfo = this.wmsConfig.getServiceInfo();
            this.element("Name", "OGC:WMS");
            this.element("Title", serviceInfo.getTitle());
            this.element("Abstract", serviceInfo.getAbstract());
            this.handleKeywordList(serviceInfo.getKeywords());
            AttributesImpl orAtts = new AttributesImpl();
            orAtts.addAttribute("", "xmlns:xlink", "xmlns:xlink", "", XLINK_NS);
            orAtts.addAttribute(XLINK_NS, "xlink:type", "xlink:type", "", "simple");
            String onlineResource = serviceInfo.getOnlineResource();
            if (onlineResource == null || onlineResource.trim().length() == 0) {
                String requestBaseUrl = this.request.getBaseUrl();
                onlineResource = ResponseUtils.buildURL((String)requestBaseUrl, null, null, (URLMangler.URLType)URLMangler.URLType.SERVICE);
            } else {
                try {
                    new URL(onlineResource);
                }
                catch (MalformedURLException e) {
                    LOGGER.log(Level.WARNING, "WMS online resource seems to be an invalid URL: '" + onlineResource + "'");
                }
            }
            orAtts.addAttribute("", "xlink:href", "xlink:href", "", onlineResource);
            this.element("OnlineResource", null, orAtts);
            GeoServer geoServer = this.wmsConfig.getGeoServer();
            ContactInfo contact = geoServer.getGlobal().getContact();
            this.handleContactInfo(contact);
            this.element("Fees", serviceInfo.getFees());
            this.element("AccessConstraints", serviceInfo.getAccessConstraints());
            this.end("Service");
        }

        public void handleContactInfo(ContactInfo contact) {
            this.start("ContactInformation");
            this.start("ContactPersonPrimary");
            this.element("ContactPerson", contact.getContactPerson());
            this.element("ContactOrganization", contact.getContactOrganization());
            this.end("ContactPersonPrimary");
            this.element("ContactPosition", contact.getContactPosition());
            this.start("ContactAddress");
            this.element("AddressType", contact.getAddressType());
            this.element("Address", contact.getAddress());
            this.element("City", contact.getAddressCity());
            this.element("StateOrProvince", contact.getAddressState());
            this.element("PostCode", contact.getAddressPostalCode());
            this.element("Country", contact.getAddressCountry());
            this.end("ContactAddress");
            this.element("ContactVoiceTelephone", contact.getContactVoice());
            this.element("ContactFacsimileTelephone", contact.getContactFacsimile());
            this.element("ContactElectronicMailAddress", contact.getContactEmail());
            this.end("ContactInformation");
        }

        private void handleKeywordList(List<String> keywords) {
            this.start("KeywordList");
            if (keywords != null) {
                Iterator<String> it = keywords.iterator();
                while (it.hasNext()) {
                    this.element("Keyword", it.next());
                }
            }
            this.end("KeywordList");
        }

        private void handleMetadataList(Collection<MetadataLinkInfo> metadataURLs) {
            if (metadataURLs == null) {
                return;
            }
            for (MetadataLinkInfo link : metadataURLs) {
                AttributesImpl lnkAtts = new AttributesImpl();
                lnkAtts.addAttribute("", "type", "type", "", link.getMetadataType());
                this.start("MetadataURL", lnkAtts);
                this.element("Format", link.getType());
                AttributesImpl orAtts = new AttributesImpl();
                orAtts.addAttribute("", "xmlns:xlink", "xmlns:xlink", "", XLINK_NS);
                orAtts.addAttribute(XLINK_NS, "xlink:type", "xlink:type", "", "simple");
                orAtts.addAttribute("", "xlink:href", "xlink:href", "", link.getContent());
                this.element("OnlineResource", null, orAtts);
                this.end("MetadataURL");
            }
        }

        private void handleCapability() {
            this.start("Capability");
            this.handleRequest();
            this.handleException();
            this.handleVendorSpecificCapabilities();
            this.handleSLD();
            this.handleLayers();
            this.end("Capability");
        }

        private void handleRequest() {
            this.start("Request");
            this.start("GetCapabilities");
            this.element("Format", GetCapabilitiesTransformer.WMS_CAPS_MIME);
            String serviceUrl = ResponseUtils.buildURL((String)this.request.getBaseUrl(), (String)"wms", (Map)ResponseUtils.params((String[])new String[]{"SERVICE", "WMS"}), (URLMangler.URLType)URLMangler.URLType.SERVICE);
            serviceUrl = ResponseUtils.appendQueryString((String)serviceUrl, (String)"");
            this.handleDcpType(serviceUrl, serviceUrl);
            this.end("GetCapabilities");
            this.start("GetMap");
            ArrayList<String> sortedFormats = new ArrayList<String>(this.getMapFormats);
            Collections.sort(sortedFormats);
            if (sortedFormats.contains("image/png")) {
                sortedFormats.remove("image/png");
                sortedFormats.add(0, "image/png");
            }
            Iterator it = sortedFormats.iterator();
            while (it.hasNext()) {
                this.element("Format", String.valueOf(it.next()));
            }
            this.handleDcpType(serviceUrl, null);
            this.end("GetMap");
            this.start("GetFeatureInfo");
            for (String format : this.wmsConfig.getAvailableFeatureInfoFormats()) {
                this.element("Format", format);
            }
            this.handleDcpType(serviceUrl, serviceUrl);
            this.end("GetFeatureInfo");
            this.start("DescribeLayer");
            this.element("Format", GetCapabilitiesTransformer.WMS_CAPS_MIME);
            this.handleDcpType(serviceUrl, null);
            this.end("DescribeLayer");
            this.start("GetLegendGraphic");
            for (String format : this.getLegendGraphicFormats) {
                this.element("Format", format);
            }
            this.handleDcpType(serviceUrl, null);
            this.end("GetLegendGraphic");
            this.start("GetStyles");
            this.element("Format", "application/vnd.ogc.sld+xml");
            this.handleDcpType(serviceUrl, null);
            this.end("GetStyles");
            this.end("Request");
        }

        private void handleDcpType(String getUrl, String postUrl) {
            AttributesImpl orAtts = new AttributesImpl();
            orAtts.addAttribute("", "xmlns:xlink", "xmlns:xlink", "", XLINK_NS);
            orAtts.addAttribute("", "xlink:type", "xlink:type", "", "simple");
            orAtts.addAttribute("", "xlink:href", "xlink:href", "", getUrl);
            this.start("DCPType");
            this.start("HTTP");
            if (getUrl != null) {
                this.start("Get");
                this.element("OnlineResource", null, orAtts);
                this.end("Get");
            }
            if (postUrl != null) {
                orAtts.setAttribute(2, "", "xlink:href", "xlink:href", "", postUrl);
                this.start("Post");
                this.element("OnlineResource", null, orAtts);
                this.end("Post");
            }
            this.end("HTTP");
            this.end("DCPType");
        }

        private void handleException() {
            this.start("Exception");
            String[] stringArray = EXCEPTION_FORMATS;
            int n = EXCEPTION_FORMATS.length;
            int n2 = 0;
            while (n2 < n) {
                String exceptionFormat = stringArray[n2];
                this.element("Format", exceptionFormat);
                ++n2;
            }
            this.end("Exception");
        }

        private void handleSLD() {
            AttributesImpl sldAtts = new AttributesImpl();
            String supportsSLD = this.wmsConfig.supportsSLD() ? "1" : "0";
            String supportsUserLayer = this.wmsConfig.supportsUserLayer() ? "1" : "0";
            String supportsUserStyle = this.wmsConfig.supportsUserStyle() ? "1" : "0";
            String supportsRemoteWFS = this.wmsConfig.supportsRemoteWFS() ? "1" : "0";
            sldAtts.addAttribute("", "SupportSLD", "SupportSLD", "", supportsSLD);
            sldAtts.addAttribute("", "UserLayer", "UserLayer", "", supportsUserLayer);
            sldAtts.addAttribute("", "UserStyle", "UserStyle", "", supportsUserStyle);
            sldAtts.addAttribute("", "RemoteWFS", "RemoteWFS", "", supportsRemoteWFS);
            this.start("UserDefinedSymbolization", sldAtts);
            this.end("UserDefinedSymbolization");
        }

        private void handleVendorSpecificCapabilities() {
            for (ExtendedCapabilitiesProvider cp : this.extCapsProviders) {
                List<String> roots = cp.getVendorSpecificCapabilitiesRoots(this.request);
                if (roots != null && roots.size() != 0) continue;
                return;
            }
            this.start("VendorSpecificCapabilities");
            for (ExtendedCapabilitiesProvider cp : this.extCapsProviders) {
                try {
                    cp.encode(new ExtendedCapabilitiesProvider.Translator(){

                        public void start(String element) {
                            CapabilitiesTranslator.this.start(element);
                        }

                        public void start(String element, Attributes attributes) {
                            CapabilitiesTranslator.this.start(element, attributes);
                        }

                        public void chars(String text) {
                            CapabilitiesTranslator.this.chars(text);
                        }

                        public void end(String element) {
                            CapabilitiesTranslator.this.end(element);
                        }
                    }, this.wmsConfig.getServiceInfo(), this.request);
                }
                catch (Exception e) {
                    throw new ServiceException("Extended capabilities provider threw error", (Throwable)e);
                }
            }
            this.end("VendorSpecificCapabilities");
        }

        private void handleLayers() {
            List<LayerInfo> layers;
            this.start("Layer");
            if (this.request.getNamespace() != null) {
                List<LayerInfo> allLayers = this.wmsConfig.getLayers();
                layers = new ArrayList<LayerInfo>();
                String namespace = this.wmsConfig.getNamespaceByPrefix(this.request.getNamespace());
                for (LayerInfo layer : allLayers) {
                    Name name = layer.getResource().getQualifiedName();
                    if (!name.getNamespaceURI().equals(namespace)) continue;
                    layers.add(layer);
                }
            } else {
                layers = this.wmsConfig.getLayers();
            }
            WMSInfo serviceInfo = this.wmsConfig.getServiceInfo();
            this.element("Title", serviceInfo.getTitle());
            this.element("Abstract", serviceInfo.getAbstract());
            List<String> srsList = serviceInfo.getSRS();
            HashSet<String> srs = new HashSet<String>();
            if (srsList != null) {
                srs.addAll(srsList);
            }
            this.handleRootCrsList(srs);
            this.handleRootBbox(layers);
            LayerTree featuresLayerTree = new LayerTree(layers);
            this.handleLayerTree(featuresLayerTree);
            try {
                List<LayerGroupInfo> layerGroups = this.wmsConfig.getLayerGroups();
                this.handleLayerGroups(new ArrayList<LayerGroupInfo>(layerGroups));
            }
            catch (FactoryException e) {
                throw new RuntimeException("Can't obtain Envelope of Layer-Groups: " + e.getMessage(), e);
            }
            catch (TransformException e) {
                throw new RuntimeException("Can't obtain Envelope of Layer-Groups: " + e.getMessage(), e);
            }
            this.end("Layer");
        }

        private void handleRootCrsList(Set<String> epsgCodes) {
            AbstractSet capabilitiesCrsIdentifiers;
            if (epsgCodes.isEmpty()) {
                this.comment("All supported EPSG projections:");
                capabilitiesCrsIdentifiers = new LinkedHashSet();
                for (String code : CRS.getSupportedCodes((String)"AUTO")) {
                    if ("WGS84(DD)".equals(code)) continue;
                    capabilitiesCrsIdentifiers.add("AUTO:" + code);
                }
                capabilitiesCrsIdentifiers.addAll(CRS.getSupportedCodes((String)"EPSG"));
            } else {
                this.comment("Limited list of EPSG projections:");
                capabilitiesCrsIdentifiers = new TreeSet<String>(epsgCodes);
            }
            try {
                for (String currentSRS : capabilitiesCrsIdentifiers) {
                    if (currentSRS.indexOf(58) == -1) {
                        currentSRS = EPSG + currentSRS;
                    }
                    this.element("SRS", currentSRS);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
        }

        private void handleRootBbox(Collection<LayerInfo> layers) {
            Envelope latlonBbox = new Envelope();
            ReferencedEnvelope layerBbox = null;
            LOGGER.finer("Collecting summarized latlonbbox and common SRS...");
            for (LayerInfo layer : layers) {
                ResourceInfo resource = layer.getResource();
                layerBbox = resource.getLatLonBoundingBox();
                latlonBbox.expandToInclude((Envelope)layerBbox);
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Summarized LatLonBBox is " + latlonBbox);
            }
            this.handleLatLonBBox(latlonBbox);
        }

        private void handleLayerTree(LayerTree layerTree) {
            ArrayList<LayerInfo> data = new ArrayList<LayerInfo>(layerTree.getData());
            Collection<LayerTree> children = layerTree.getChildrens();
            Collections.sort(data, new Comparator<LayerInfo>(){

                @Override
                public int compare(LayerInfo o1, LayerInfo o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            for (LayerInfo layer : data) {
                boolean wmsExposable = false;
                if (layer.getType() == LayerInfo.Type.RASTER || layer.getType() == LayerInfo.Type.WMS) {
                    wmsExposable = true;
                } else {
                    try {
                        wmsExposable = layer.getType() == LayerInfo.Type.VECTOR && ((FeatureTypeInfo)layer.getResource()).getFeatureType().getGeometryDescriptor() != null;
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.SEVERE, "An error occurred trying to determine if the layer is geometryless", e);
                    }
                }
                if (!layer.enabled() || !wmsExposable) continue;
                try {
                    this.handleLayer(layer);
                }
                catch (Exception e) {
                    throw new ServiceException("Error occurred trying to write out metadata for layer: " + layer.getName(), (Throwable)e);
                }
            }
            for (LayerTree childLayerTree : children) {
                this.start("Layer");
                this.element("Name", childLayerTree.getName());
                this.element("Title", childLayerTree.getName());
                this.handleLayerTree(childLayerTree);
                this.end("Layer");
            }
        }

        protected void handleLayer(LayerInfo layer) {
            ReferencedEnvelope bbox;
            String srs;
            block24: {
                AttributesImpl qatts = new AttributesImpl();
                boolean queryable = this.wmsConfig.isQueryable(layer);
                qatts.addAttribute("", "queryable", "queryable", "", queryable ? "1" : "0");
                this.start("Layer", qatts);
                this.element("Name", String.valueOf(layer.getResource().getNamespace().getPrefix()) + ":" + layer.getName());
                this.element("Title", layer.getResource().getTitle());
                this.element("Abstract", layer.getResource().getAbstract());
                this.handleKeywordList(layer.getResource().getKeywords());
                srs = layer.getResource().getSRS();
                this.element("SRS", srs);
                try {
                    CoordinateReferenceSystem crs = layer.getResource().getCRS();
                    String desc = "WKT definition of this CRS:\n" + crs;
                    this.comment(desc);
                }
                catch (Exception e) {
                    if (!LOGGER.isLoggable(Level.WARNING)) break block24;
                    LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                }
            }
            try {
                bbox = layer.getResource().boundingBox();
            }
            catch (Exception e) {
                throw new RuntimeException("Unexpected error obtaining bounding box for layer " + layer.getName(), e);
            }
            ReferencedEnvelope llbbox = layer.getResource().getLatLonBoundingBox();
            this.handleLatLonBBox((Envelope)llbbox);
            if (bbox != null) {
                this.handleBBox((Envelope)bbox, srs);
            }
            String timeMetadata = null;
            String elevationMetadata = null;
            if (layer.getType() == LayerInfo.Type.RASTER) {
                CoverageInfo cvinfo = (CoverageInfo)layer.getResource();
                if (cvinfo == null) {
                    throw new RuntimeException("Unable to acquire coverage resource for layer: " + layer.getName());
                }
                Catalog catalog = cvinfo.getCatalog();
                if (catalog == null) {
                    throw new RuntimeException("Unable to acquire catalog resource for layer: " + layer.getName());
                }
                CoverageStoreInfo csinfo = cvinfo.getStore();
                if (csinfo == null) {
                    throw new RuntimeException("Unable to acquire coverage store resource for layer: " + layer.getName());
                }
                AbstractGridCoverage2DReader reader = null;
                try {
                    reader = (AbstractGridCoverage2DReader)catalog.getResourcePool().getGridCoverageReader(csinfo, GeoTools.getDefaultHints());
                }
                catch (Throwable t) {
                    LOGGER.severe("Unable to acquire a reader for this coverage with format: " + csinfo.getFormat().getName());
                }
                if (reader == null) {
                    throw new RuntimeException("Unable to acquire a reader for this coverage with format: " + csinfo.getFormat().getName());
                }
                String[] metadataNames = reader.getMetadataNames();
                if (metadataNames != null && metadataNames.length > 0) {
                    timeMetadata = reader.getMetadataValue("TIME_DOMAIN");
                    if (timeMetadata != null) {
                        AttributesImpl timeDim = new AttributesImpl();
                        timeDim.addAttribute("", "name", "name", "", "time");
                        timeDim.addAttribute("", "units", "units", "", "ISO8601");
                        this.element("Dimension", null, timeDim);
                    }
                    if ((elevationMetadata = reader.getMetadataValue("ELEVATION_DOMAIN")) != null) {
                        AttributesImpl elevDim = new AttributesImpl();
                        elevDim.addAttribute("", "name", "name", "", "elevation");
                        elevDim.addAttribute("", "units", "units", "", "EPSG:5030");
                        this.element("Dimension", null, elevDim);
                    }
                }
            }
            if (timeMetadata != null && timeMetadata.length() > 0) {
                AttributesImpl timeDim = new AttributesImpl();
                timeDim.addAttribute("", "name", "name", "", "time");
                timeDim.addAttribute("", "default", "default", "", "current");
                this.element("Extent", timeMetadata, timeDim);
            }
            if (elevationMetadata != null && elevationMetadata.length() > 0) {
                String[] elevationLevels = elevationMetadata.split(",");
                AttributesImpl elevDim = new AttributesImpl();
                elevDim.addAttribute("", "name", "name", "", "elevation");
                elevDim.addAttribute("", "default", "default", "", elevationLevels[0]);
                this.element("Extent", elevationMetadata, elevDim);
            }
            this.handleAttribution(layer);
            this.handleMetadataList(layer.getResource().getMetadataLinks());
            if (!(layer.getResource() instanceof WMSLayerInfo)) {
                Style ftStyle;
                this.start("Style");
                StyleInfo defaultStyle = layer.getDefaultStyle();
                if (defaultStyle == null) {
                    throw new NullPointerException("Layer " + layer.getName() + " has no default style");
                }
                try {
                    ftStyle = defaultStyle.getStyle();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                this.element("Name", defaultStyle.getName());
                this.element("Title", ftStyle.getTitle());
                this.element("Abstract", ftStyle.getAbstract());
                this.handleLegendURL(layer.getName(), layer.getLegend(), null);
                this.end("Style");
                Set styles = layer.getStyles();
                for (StyleInfo styleInfo : styles) {
                    try {
                        ftStyle = styleInfo.getStyle();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    this.start("Style");
                    this.element("Name", styleInfo.getName());
                    this.element("Title", ftStyle.getTitle());
                    this.element("Abstract", ftStyle.getAbstract());
                    this.handleLegendURL(layer.getName(), null, styleInfo);
                    this.end("Style");
                }
            }
            this.end("Layer");
        }

        protected void handleLayerGroups(List<LayerGroupInfo> layerGroups) throws FactoryException, TransformException {
            if (layerGroups == null || layerGroups.size() == 0) {
                return;
            }
            Collections.sort(layerGroups, new Comparator<LayerGroupInfo>(){

                @Override
                public int compare(LayerGroupInfo o1, LayerGroupInfo o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            for (LayerGroupInfo layerGroup : layerGroups) {
                String layerName = layerGroup.getName();
                AttributesImpl qatts = new AttributesImpl();
                boolean queryable = this.wmsConfig.isQueryable(layerGroup);
                qatts.addAttribute("", "queryable", "queryable", "", queryable ? "1" : "0");
                this.start("Layer", qatts);
                this.element("Name", layerName);
                this.element("Title", layerName);
                this.element("Abstract", "Layer-Group type layer: " + layerName);
                ReferencedEnvelope layerGroupBounds = layerGroup.getBounds();
                ReferencedEnvelope latLonBounds = layerGroupBounds.transform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, true);
                String authority = layerGroupBounds.getCoordinateReferenceSystem().getIdentifiers().toArray()[0].toString();
                this.element("SRS", authority);
                this.handleLatLonBBox((Envelope)latLonBounds);
                this.handleBBox((Envelope)layerGroupBounds, authority);
                List layers = layerGroup.getLayers();
                HashSet<MetadataLinkInfo> aggregatedLinks = new HashSet<MetadataLinkInfo>();
                for (LayerInfo layer : layers) {
                    List metadataLinks = layer.getResource().getMetadataLinks();
                    if (metadataLinks == null) continue;
                    aggregatedLinks.addAll(metadataLinks);
                }
                this.handleMetadataList(aggregatedLinks);
                this.end("Layer");
            }
        }

        protected void handleAttribution(LayerInfo layer) {
            boolean logoGood;
            AttributionInfo attribution = layer.getAttribution();
            String title = attribution.getTitle();
            String url = attribution.getHref();
            String logoURL = attribution.getLogoURL();
            String logoType = attribution.getLogoType();
            int logoWidth = attribution.getLogoWidth();
            int logoHeight = attribution.getLogoHeight();
            boolean titleGood = title != null;
            boolean urlGood = url != null;
            boolean bl = logoGood = logoURL != null && logoType != null && logoWidth > 0 && logoHeight > 0;
            if (titleGood || urlGood || logoGood) {
                this.start("Attribution");
                if (titleGood) {
                    this.element("Title", title);
                }
                if (urlGood) {
                    AttributesImpl urlAttributes = new AttributesImpl();
                    urlAttributes.addAttribute("", "xmlns:xlink", "xmlns:xlink", "", XLINK_NS);
                    urlAttributes.addAttribute(XLINK_NS, "type", "xlink:type", "", "simple");
                    urlAttributes.addAttribute(XLINK_NS, "href", "xlink:href", "", url);
                    this.element("OnlineResource", null, urlAttributes);
                }
                if (logoGood) {
                    AttributesImpl logoAttributes = new AttributesImpl();
                    logoAttributes.addAttribute("", "", "height", "", "" + logoHeight);
                    logoAttributes.addAttribute("", "", "width", "", "" + logoWidth);
                    this.start("LogoURL", logoAttributes);
                    this.element("Format", logoType);
                    AttributesImpl urlAttributes = new AttributesImpl();
                    urlAttributes.addAttribute("", "xmlns:xlink", "xmlns:xlink", "", XLINK_NS);
                    urlAttributes.addAttribute(XLINK_NS, "type", "xlink:type", "", "simple");
                    urlAttributes.addAttribute(XLINK_NS, "href", "xlink:href", "", logoURL);
                    this.element("OnlineResource", null, urlAttributes);
                    this.end("LogoURL");
                }
                this.end("Attribution");
            }
        }

        protected void handleLegendURL(String layerName, LegendInfo legend, StyleInfo style) {
            if (legend != null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("using user supplied legend URL");
                }
                AttributesImpl attrs = new AttributesImpl();
                attrs.addAttribute("", "width", "width", "", String.valueOf(legend.getWidth()));
                attrs.addAttribute("", "height", "height", "", String.valueOf(legend.getHeight()));
                this.start("LegendURL", attrs);
                this.element("Format", legend.getFormat());
                attrs.clear();
                attrs.addAttribute("", "xmlns:xlink", "xmlns:xlink", "", XLINK_NS);
                attrs.addAttribute(XLINK_NS, "type", "xlink:type", "", "simple");
                attrs.addAttribute(XLINK_NS, "href", "xlink:href", "", legend.getOnlineResource());
                this.element("OnlineResource", null, attrs);
                this.end("LegendURL");
            } else {
                String defaultFormat = "image/png";
                if (this.wmsConfig.getLegendGraphicOutputFormat(defaultFormat) == null) {
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.warning(new StringBuffer("Default legend format (").append(defaultFormat).append(")is not supported (jai not available?), can't add LegendURL element").toString());
                    }
                    return;
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Adding GetLegendGraphic call as LegendURL");
                }
                AttributesImpl attrs = new AttributesImpl();
                attrs.addAttribute("", "width", "width", "", String.valueOf(20));
                attrs.addAttribute("", "height", "height", "", String.valueOf(20));
                this.start("LegendURL", attrs);
                this.element("Format", defaultFormat);
                attrs.clear();
                Map params = ResponseUtils.params((String[])new String[]{"request", "GetLegendGraphic", "format", defaultFormat, "width", String.valueOf(20), "height", String.valueOf(20), "layer", layerName});
                if (style != null) {
                    params.put("style", style.getName());
                }
                String legendURL = ResponseUtils.buildURL((String)this.request.getBaseUrl(), (String)"wms", (Map)params, (URLMangler.URLType)URLMangler.URLType.SERVICE);
                attrs.addAttribute("", "xmlns:xlink", "xmlns:xlink", "", XLINK_NS);
                attrs.addAttribute(XLINK_NS, "type", "xlink:type", "", "simple");
                attrs.addAttribute(XLINK_NS, "href", "xlink:href", "", legendURL);
                this.element("OnlineResource", null, attrs);
                this.end("LegendURL");
            }
        }

        private void handleLatLonBBox(Envelope bbox) {
            String minx = String.valueOf(bbox.getMinX());
            String miny = String.valueOf(bbox.getMinY());
            String maxx = String.valueOf(bbox.getMaxX());
            String maxy = String.valueOf(bbox.getMaxY());
            AttributesImpl bboxAtts = new AttributesImpl();
            bboxAtts.addAttribute("", "minx", "minx", "", minx);
            bboxAtts.addAttribute("", "miny", "miny", "", miny);
            bboxAtts.addAttribute("", "maxx", "maxx", "", maxx);
            bboxAtts.addAttribute("", "maxy", "maxy", "", maxy);
            this.element("LatLonBoundingBox", null, bboxAtts);
        }

        public void comment(String comment) {
            if (this.contentHandler instanceof TransformerIdentityImpl) {
                try {
                    TransformerIdentityImpl ch = (TransformerIdentityImpl)this.contentHandler;
                    ch.comment(comment.toCharArray(), 0, comment.length());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        private void handleBBox(Envelope bbox, String SRS) {
            String minx = String.valueOf(bbox.getMinX());
            String miny = String.valueOf(bbox.getMinY());
            String maxx = String.valueOf(bbox.getMaxX());
            String maxy = String.valueOf(bbox.getMaxY());
            AttributesImpl bboxAtts = new AttributesImpl();
            bboxAtts.addAttribute("", "SRS", "SRS", "", SRS);
            bboxAtts.addAttribute("", "minx", "minx", "", minx);
            bboxAtts.addAttribute("", "miny", "miny", "", miny);
            bboxAtts.addAttribute("", "maxx", "maxx", "", maxx);
            bboxAtts.addAttribute("", "maxy", "maxy", "", maxy);
            this.element("BoundingBox", null, bboxAtts);
        }
    }
}

