/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import com.sun.media.imageioimpl.common.PackageUtil;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSMapContext;
import org.geoserver.wms.map.RenderedImageMapResponse;
import org.geotools.image.ImageWorker;
import org.geotools.util.logging.Logging;

public final class JPEGMapResponse
extends RenderedImageMapResponse {
    private static final Logger LOGGER = Logging.getLogger((String)JPEGMapResponse.class.toString());
    private static final boolean CODEC_LIB_AVAILABLE = PackageUtil.isCodecLibAvailable();
    private static final String MIME_TYPE = "image/jpeg";

    public JPEGMapResponse(WMS wms) {
        super(MIME_TYPE, wms);
    }

    public void formatImageOutputStream(RenderedImage image, OutputStream outStream, WMSMapContext mapContext) throws IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("About to write a JPEG image.");
        }
        boolean JPEGNativeAcc = this.wms.getJPEGNativeAcceleration() != false && CODEC_LIB_AVAILABLE;
        float quality = (float)(100 - this.wms.getJpegCompression()) / 100.0f;
        ImageWorker iw = new ImageWorker(image);
        iw.writeJPEG((Object)outStream, "JPEG", quality, JPEGNativeAcc);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Writing a JPEG done!!!");
        }
    }
}

