/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml;

import com.vividsolutions.jts.geom.Envelope;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.kml.KMLTransformerBase;
import org.geoserver.kml.KMLUtils;
import org.geoserver.ows.HttpErrorCodeException;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.CaseInsensitiveMap;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSMapContext;
import org.geoserver.wms.WMSRequests;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.MapLayer;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.resources.coverage.FeatureUtilities;
import org.geotools.util.logging.Logging;
import org.geotools.xml.transform.Translator;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.xml.sax.ContentHandler;

public class KMLSuperOverlayTransformer
extends KMLTransformerBase {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.kml");
    private final WMSMapContext mapContext;
    private final WMS wms;

    public KMLSuperOverlayTransformer(WMS wms, WMSMapContext mapContext) {
        this.wms = wms;
        this.mapContext = mapContext;
        this.setNamespaceDeclarationEnabled(false);
    }

    public Translator createTranslator(ContentHandler handler) {
        return new KMLSuperOverlayerTranslator(handler);
    }

    class KMLSuperOverlayerTranslator
    extends KMLTransformerBase.KMLTranslatorSupport {
        public KMLSuperOverlayerTranslator(ContentHandler contentHandler) {
            super(KMLSuperOverlayTransformer.this, contentHandler);
        }

        public void encode(Object o) throws IllegalArgumentException {
            MapLayer mapLayer = (MapLayer)o;
            ReferencedEnvelope extent = KMLSuperOverlayTransformer.this.mapContext.getAreaOfInterest();
            Envelope top = KMLUtils.expandToTile((Envelope)extent);
            int zoomLevel = KMLUtils.findZoomLevel((Envelope)extent);
            LOGGER.fine("request = " + extent);
            LOGGER.fine("top level = " + top);
            if (KMLSuperOverlayTransformer.this.isStandAlone()) {
                this.start("kml");
            }
            this.start("Document");
            if (KMLSuperOverlayTransformer.this.isStandAlone()) {
                String kmltitle = (String)KMLSuperOverlayTransformer.this.mapContext.getRequest().getFormatOptions().get("kmltitle");
                this.element("name", kmltitle != null && KMLSuperOverlayTransformer.this.mapContext.layers().size() <= 1 ? kmltitle : mapLayer.getTitle());
            }
            if ("cached".equals(KMLUtils.getSuperoverlayMode(KMLSuperOverlayTransformer.this.mapContext.getRequest(), KMLSuperOverlayTransformer.this.wms))) {
                if (KMLUtils.isRequestGWCCompatible(KMLSuperOverlayTransformer.this.mapContext, mapLayer, KMLSuperOverlayTransformer.this.wms)) {
                    this.encodeGWCLink(mapLayer);
                } else {
                    LOGGER.log(Level.INFO, "Could not use cached mode for this request as the KML parameters do not match the server defaults. Falling back to 'auto' mode");
                    KMLSuperOverlayTransformer.this.mapContext.getRequest().getFormatOptions().put("overlayMode", "auto");
                    this.encodeNetworkLinks(mapLayer, top, zoomLevel);
                }
            } else {
                this.encodeNetworkLinks(mapLayer, top, zoomLevel);
            }
            this.end("Document");
            if (KMLSuperOverlayTransformer.this.isStandAlone()) {
                this.end("kml");
            }
        }

        void encodeNetworkLinks(MapLayer mapLayer, Envelope top, int zoomLevel) {
            this.encodeRegion(top, 256, -1);
            if (top != KMLUtils.WORLD_BOUNDS_WGS84) {
                Envelope e00 = new Envelope(top.getMinX(), top.getMinX() + top.getWidth() / 2.0, top.getMaxY() - top.getHeight() / 2.0, top.getMaxY());
                Envelope e01 = new Envelope(e00.getMaxX(), top.getMaxX(), e00.getMinY(), e00.getMaxY());
                Envelope e10 = new Envelope(e00.getMinX(), e00.getMaxX(), top.getMinY(), e00.getMinY());
                Envelope e11 = new Envelope(e01.getMinX(), e01.getMaxX(), e10.getMinY(), e10.getMaxY());
                this.encodeNetworkLink(e00, "00", mapLayer);
                this.encodeNetworkLink(e01, "01", mapLayer);
                this.encodeNetworkLink(e10, "10", mapLayer);
                this.encodeNetworkLink(e11, "11", mapLayer);
            } else {
                Envelope e0 = new Envelope(top.getMinX(), top.getMinX() + top.getWidth() / 2.0, top.getMinY(), top.getMaxY());
                Envelope e1 = new Envelope(e0.getMaxX(), top.getMaxX(), top.getMinY(), top.getMaxY());
                this.encodeNetworkLink(e0, "0", mapLayer);
                this.encodeNetworkLink(e1, "1", mapLayer);
            }
            if (top == KMLUtils.WORLD_BOUNDS_WGS84) {
                this.encodeTileForViewing(mapLayer, zoomLevel, new Envelope(-180.0, 0.0, -90.0, 90.0));
                this.encodeTileForViewing(mapLayer, zoomLevel, new Envelope(0.0, 180.0, -90.0, 90.0));
            } else {
                this.encodeTileForViewing(mapLayer, zoomLevel, top);
            }
        }

        public void encodeGWCLink(MapLayer mapLayer) {
            this.start("NetworkLink");
            this.element("name", "GWC-" + mapLayer.getTitle());
            this.start("Link");
            SimpleFeatureType ft = (SimpleFeatureType)mapLayer.getFeatureSource().getSchema();
            String type = "kml";
            if (FeatureUtilities.isWrappedCoverage((SimpleFeatureType)ft) || FeatureUtilities.isWrappedCoverageReader((SimpleFeatureType)ft)) {
                type = "png";
            }
            String url = ResponseUtils.buildURL((String)KMLSuperOverlayTransformer.this.mapContext.getRequest().getBaseUrl(), (String)("gwc/service/kml/" + mapLayer.getTitle() + "." + type + ".kml"), null, (URLMangler.URLType)URLMangler.URLType.SERVICE);
            this.element("href", url);
            this.element("viewRefreshMode", "never");
            this.end("Link");
            this.end("NetworkLink");
        }

        void encodeTileForViewing(MapLayer mapLayer, int drawOrder, Envelope box) {
            if (this.shouldDrawVectorLayer(mapLayer, box)) {
                this.encodeKMLLink(mapLayer, drawOrder, box);
            }
            if (this.shouldDrawWMSOverlay(mapLayer, box)) {
                this.encodeGroundOverlay(mapLayer, drawOrder, box);
            }
        }

        private boolean shouldDrawVectorLayer(MapLayer layer, Envelope box) {
            if (!this.isVectorLayer(layer)) {
                return false;
            }
            String overlayMode = KMLUtils.getSuperoverlayMode(KMLSuperOverlayTransformer.this.mapContext.getRequest(), KMLSuperOverlayTransformer.this.wms);
            if ("raster".equals(overlayMode)) {
                return false;
            }
            if ("overview".equals(overlayMode)) {
                return this.featuresInTile(layer, box, false) <= this.getRegionateFeatureLimit(this.getFeatureTypeInfo(layer));
            }
            return this.featuresInTile(layer, box, true) > 0;
        }

        private int getRegionateFeatureLimit(FeatureTypeInfo ft) {
            Integer regionateFeatureLimit = (Integer)ft.getMetadata().get("kml.regionateFeatureLimit", Integer.class);
            return regionateFeatureLimit != null ? regionateFeatureLimit : -1;
        }

        private boolean shouldDrawWMSOverlay(MapLayer layer, Envelope box) {
            if (!this.isVectorLayer(layer)) {
                return true;
            }
            String overlayMode = KMLUtils.getSuperoverlayMode(KMLSuperOverlayTransformer.this.mapContext.getRequest(), KMLSuperOverlayTransformer.this.wms);
            if ("hybrid".equals(overlayMode) || "raster".equals(overlayMode)) {
                return true;
            }
            if ("overview".equals(overlayMode)) {
                return this.featuresInTile(layer, box, false) > this.getRegionateFeatureLimit(this.getFeatureTypeInfo(layer));
            }
            return false;
        }

        void encodeKMLLink(MapLayer mapLayer, int drawOrder, Envelope box) {
            CaseInsensitiveMap fo = new CaseInsensitiveMap(new HashMap());
            fo.putAll(KMLSuperOverlayTransformer.this.mapContext.getRequest().getFormatOptions());
            fo.remove((Object)"superoverlay");
            String overlayMode = (String)fo.get((Object)"overlayMode");
            if ("overview".equalsIgnoreCase(overlayMode)) {
                fo.remove((Object)"regionateBy");
            } else if (!fo.containsKey((Object)"regionateBy")) {
                fo.put((Object)"regionateBy", (Object)"auto");
            }
            String foEncoded = WMSRequests.encodeFormatOptions((Map)fo);
            this.start("NetworkLink");
            this.element("visibility", "1");
            this.start("Link");
            this.element("href", KMLUtils.getMapUrl(KMLSuperOverlayTransformer.this.mapContext, mapLayer, 0, box, new String[]{"width", "256", "height", "256", "format_options", foEncoded, "superoverlay", "false"}, true, KMLSuperOverlayTransformer.this.wms.getGeoServer()));
            this.end("Link");
            this.encodeRegion(box, 128, -1);
            this.end("NetworkLink");
        }

        boolean isVectorLayer(MapLayer layer) {
            int index = Arrays.asList(KMLSuperOverlayTransformer.this.mapContext.getLayers()).indexOf(layer);
            MapLayerInfo info = KMLSuperOverlayTransformer.this.mapContext.getRequest().getLayers().get(index);
            return info.getType() == MapLayerInfo.TYPE_VECTOR || info.getType() == MapLayerInfo.TYPE_REMOTE_VECTOR;
        }

        private FeatureTypeInfo getFeatureTypeInfo(MapLayer layer) {
            for (MapLayerInfo info : KMLSuperOverlayTransformer.this.mapContext.getRequest().getLayers()) {
                if (!info.getName().equals(layer.getTitle())) continue;
                return info.getFeature();
            }
            return null;
        }

        private int featuresInTile(MapLayer mapLayer, Envelope bounds, boolean regionate) {
            if (!this.isVectorLayer(mapLayer)) {
                return 1;
            }
            Envelope originalBounds = KMLSuperOverlayTransformer.this.mapContext.getRequest().getBbox();
            KMLSuperOverlayTransformer.this.mapContext.getRequest().setBbox(bounds);
            KMLSuperOverlayTransformer.this.mapContext.setAreaOfInterest(new ReferencedEnvelope(bounds, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
            String originalRegionateBy = null;
            if (regionate && (originalRegionateBy = (String)KMLSuperOverlayTransformer.this.mapContext.getRequest().getFormatOptions().get("regionateby")) == null) {
                KMLSuperOverlayTransformer.this.mapContext.getRequest().getFormatOptions().put("regionateby", "auto");
            }
            int numFeatures = 0;
            try {
                SimpleFeatureCollection fc = KMLUtils.loadFeatureCollection((SimpleFeatureSource)mapLayer.getFeatureSource(), mapLayer, KMLSuperOverlayTransformer.this.mapContext, KMLSuperOverlayTransformer.this.wms, -1.0);
                numFeatures = fc == null ? 0 : fc.size();
            }
            catch (ServiceException e) {
                LOGGER.severe("Caught the WmsException!");
                numFeatures = -1;
            }
            catch (HttpErrorCodeException e) {
                if (e.getErrorCode() == 204) {
                    throw e;
                }
                LOGGER.log(Level.WARNING, "Failure while checking whether a regionated child tile contained features!", e);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failure while checking whether a regionated child tile contained features!", e);
            }
            KMLSuperOverlayTransformer.this.mapContext.getRequest().setBbox(originalBounds);
            KMLSuperOverlayTransformer.this.mapContext.setAreaOfInterest(new ReferencedEnvelope(originalBounds, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
            if (regionate && originalRegionateBy == null) {
                KMLSuperOverlayTransformer.this.mapContext.getRequest().getFormatOptions().remove("regionateby");
            }
            return numFeatures;
        }

        void encodeGroundOverlay(MapLayer mapLayer, int drawOrder, Envelope box) {
            this.start("GroundOverlay");
            this.element("drawOrder", "" + drawOrder);
            this.start("Icon");
            String href = KMLUtils.getMapUrl(KMLSuperOverlayTransformer.this.mapContext, mapLayer, 0, box, new String[]{"width", "256", "height", "256", "format", "image/png", "transparent", "true"}, true, KMLSuperOverlayTransformer.this.wms.getGeoServer());
            this.element("href", href);
            LOGGER.fine(href);
            this.end("Icon");
            SimpleFeatureType layerFeatureType = (SimpleFeatureType)mapLayer.getFeatureSource().getSchema();
            if (FeatureUtilities.isWrappedCoverage((SimpleFeatureType)layerFeatureType) || FeatureUtilities.isWrappedCoverageReader((SimpleFeatureType)layerFeatureType)) {
                this.encodeRegion(box, 128, 2048);
            } else {
                this.encodeRegion(box, 128, 512);
            }
            this.encodeLatLonBox(box);
            this.end("GroundOverlay");
        }

        void encodeRegion(Envelope box, int minLodPixels, int maxLodPixels) {
            this.start("Region");
            this.start("Lod");
            this.element("minLodPixels", "" + minLodPixels);
            this.element("maxLodPixels", "" + maxLodPixels);
            this.end("Lod");
            this.encodeLatLonAltBox(box);
            this.end("Region");
        }

        void encodeNetworkLink(Envelope box, String name, MapLayer mapLayer) {
            this.start("NetworkLink");
            this.element("name", name);
            this.encodeRegion(box, 128, -1);
            this.start("Link");
            String getMap = KMLUtils.getMapUrl(KMLSuperOverlayTransformer.this.mapContext, mapLayer, 0, box, new String[]{"format", "application/vnd.google-earth.kml+xml", "width", "256", "height", "256", "superoverlay", "true"}, false, KMLSuperOverlayTransformer.this.wms.getGeoServer());
            this.element("href", getMap);
            LOGGER.fine("Network link " + name + ":" + getMap);
            this.element("viewRefreshMode", "onRegion");
            this.end("Link");
            this.end("NetworkLink");
        }

        void encodeLatLonAltBox(Envelope box) {
            this.start("LatLonAltBox");
            this.encodeBox(box);
            this.end("LatLonAltBox");
        }

        void encodeLatLonBox(Envelope box) {
            this.start("LatLonBox");
            this.encodeBox(box);
            this.end("LatLonBox");
        }

        void encodeBox(Envelope box) {
            this.element("north", String.valueOf(box.getMaxY()));
            this.element("south", String.valueOf(box.getMinY()));
            this.element("east", String.valueOf(box.getMaxX()));
            this.element("west", String.valueOf(box.getMinX()));
        }
    }
}

