/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

public class MapProducerCapabilities {
    private final boolean tiledRequestsSupported;
    private final boolean multivalueRequestsSupported;
    private final boolean paletteSupported;
    private final boolean transparencySupported;
    private final String framesMimeType;

    public MapProducerCapabilities(boolean tiledRequestsSupported, boolean multivalueRequestsSupported, boolean paletteSupported, boolean transparencySupported, String framesMimeType) {
        this.tiledRequestsSupported = tiledRequestsSupported;
        this.multivalueRequestsSupported = multivalueRequestsSupported;
        this.paletteSupported = paletteSupported;
        this.transparencySupported = transparencySupported;
        this.framesMimeType = framesMimeType;
    }

    public boolean isTiledRequestsSupported() {
        return this.tiledRequestsSupported;
    }

    public boolean isMultivalueRequestsSupported() {
        return this.multivalueRequestsSupported;
    }

    public boolean isPaletteSupported() {
        return this.paletteSupported;
    }

    public boolean isTransparencySupported() {
        return this.transparencySupported;
    }

    public String getFramesMimeType() {
        return this.framesMimeType;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.framesMimeType == null ? 0 : this.framesMimeType.hashCode());
        result = 31 * result + (this.multivalueRequestsSupported ? 1231 : 1237);
        result = 31 * result + (this.paletteSupported ? 1231 : 1237);
        result = 31 * result + (this.tiledRequestsSupported ? 1231 : 1237);
        result = 31 * result + (this.transparencySupported ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MapProducerCapabilities)) {
            return false;
        }
        MapProducerCapabilities other = (MapProducerCapabilities)obj;
        if (this.framesMimeType == null ? other.framesMimeType != null : !this.framesMimeType.equals(other.framesMimeType)) {
            return false;
        }
        if (this.multivalueRequestsSupported != other.multivalueRequestsSupported) {
            return false;
        }
        if (this.paletteSupported != other.paletteSupported) {
            return false;
        }
        if (this.tiledRequestsSupported != other.tiledRequestsSupported) {
            return false;
        }
        return this.transparencySupported == other.transparencySupported;
    }

    public String toString() {
        return "MapProducerCapabilities [framesMimeType=" + this.framesMimeType + ", multivalueRequestsSupported=" + this.multivalueRequestsSupported + ", paletteSupported=" + this.paletteSupported + ", tiledRequestsSupported=" + this.tiledRequestsSupported + ", transparencySupported=" + this.transparencySupported + "]";
    }
}

