/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import com.vividsolutions.jts.geom.Envelope;
import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.geoserver.config.GeoServer;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.KvpUtils;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.WMSMapContext;
import org.geoserver.wms.WMSRequest;
import org.geotools.map.MapLayer;
import org.vfny.geoserver.util.Requests;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WMSRequests {
    @Deprecated
    public static String getBaseUrl(String baseUrl) {
        baseUrl = ResponseUtils.appendPath((String[])new String[]{baseUrl, "wms"});
        return baseUrl;
    }

    @Deprecated
    public static String getBaseUrl(WMSRequest request) {
        return WMSRequests.getBaseUrl(request.getBaseUrl());
    }

    @Deprecated
    public static String getBaseUrl(WMSMapContext map) {
        return WMSRequests.getBaseUrl(map.getRequest());
    }

    public static String getTiledGetMapUrl(GeoServer geoserver, GetMapRequest req, MapLayer layer, int layerIndex, Envelope bbox, String[] kvp) {
        HashMap<String, String> params = WMSRequests.getGetMapParams(req, layer.getTitle(), layerIndex, layer.getStyle().getName(), bbox, kvp);
        String baseUrl = WMSRequests.getTileCacheBaseUrl(req, geoserver);
        if (baseUrl == null) {
            return ResponseUtils.buildURL((String)req.getBaseUrl(), (String)"wms", params, (URLMangler.URLType)URLMangler.URLType.SERVICE);
        }
        return ResponseUtils.buildURL((String)baseUrl, (String)"", params, (URLMangler.URLType)URLMangler.URLType.EXTERNAL);
    }

    private static String getTileCacheBaseUrl(GetMapRequest req, GeoServer geoServer) {
        String tileCacheBaseUrl = (String)((Object)geoServer.getGlobal().getMetadata().get((Object)"tileCache"));
        if (tileCacheBaseUrl != null) {
            try {
                new URL(tileCacheBaseUrl);
                return tileCacheBaseUrl;
            }
            catch (MalformedURLException e1) {
                try {
                    String baseUrl = req.getBaseUrl();
                    URL base = new URL(baseUrl);
                    baseUrl = String.valueOf(base.getProtocol()) + ":" + base.getPort() + "//" + base.getHost();
                    String url = Requests.appendContextPath((String)baseUrl, (String)tileCacheBaseUrl);
                    new URL(url);
                    return url;
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static String getGetMapUrl(GetMapRequest req, MapLayer layer, int layerIndex, Envelope bbox, String[] kvp) {
        String layerName = layer != null ? layer.getTitle() : null;
        String style = layer != null ? layer.getStyle().getName() : null;
        HashMap<String, String> params = WMSRequests.getGetMapParams(req, layerName, layerIndex, style, bbox, kvp);
        return ResponseUtils.buildURL((String)req.getBaseUrl(), (String)"wms", params, (URLMangler.URLType)URLMangler.URLType.SERVICE);
    }

    public static String getGetMapUrl(GetMapRequest req, String layer, int layerIndex, String style, Envelope bbox, String[] kvp) {
        HashMap<String, String> params = WMSRequests.getGetMapParams(req, layer, layerIndex, style, bbox, kvp);
        return ResponseUtils.buildURL((String)req.getBaseUrl(), (String)"wms", params, (URLMangler.URLType)URLMangler.URLType.SERVICE);
    }

    public static String getGetLegendGraphicUrl(WMSRequest req, MapLayer layer, String[] kvp) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("service", "wms");
        params.put("request", "GetLegendGraphic");
        params.put("version", "1.1.1");
        params.put("format", "image/png");
        params.put("layer", layer.getTitle());
        params.put("style", layer.getStyle().getName());
        params.put("height", "20");
        params.put("width", "20");
        int i = 0;
        while (kvp != null && i < kvp.length) {
            params.put(kvp[i], kvp[i + 1]);
            i += 2;
        }
        return ResponseUtils.buildURL((String)req.getBaseUrl(), (String)"wms", params, (URLMangler.URLType)URLMangler.URLType.SERVICE);
    }

    /*
     * Unable to fully structure code
     */
    static HashMap<String, String> getGetMapParams(GetMapRequest req, String layer, int layerIndex, String style, Envelope bbox, String[] kvp) {
        block30: {
            block28: {
                block29: {
                    params = new HashMap<String, String>();
                    params.put("service", "wms");
                    params.put("request", "GetMap");
                    params.put("version", "1.1.1");
                    params.put("format", req.getFormat());
                    layers = new StringBuffer();
                    styles = new StringBuffer();
                    useLayerIndex = true;
                    count = 0;
                    i = 0;
                    while (i < req.getLayers().size()) {
                        if (layer != null && layer.equals(req.getLayers().get(i).getName())) {
                            ++count;
                        }
                        ++i;
                    }
                    if (count == 1) {
                        useLayerIndex = false;
                    }
                    if (layer != null) {
                        layers.append(layer);
                        if (style != null) {
                            styles.append(style);
                        } else if (useLayerIndex) {
                            styles.append(req.getLayers().get(layerIndex).getDefaultStyle().getName());
                        } else {
                            i = 0;
                            while (i < req.getLayers().size()) {
                                if (layer.equals(req.getLayers().get(i).getName())) {
                                    styles.append(req.getLayers().get(i).getDefaultStyle().getName());
                                }
                                ++i;
                            }
                        }
                    } else {
                        i = 0;
                        while (i < req.getLayers().size()) {
                            mapLayer = req.getLayers().get(i);
                            s = req.getStyles().get(0);
                            layers.append(mapLayer.getName()).append(",");
                            styles.append(s.getName()).append(",");
                            ++i;
                        }
                        layers.setLength(layers.length() - 1);
                        styles.setLength(styles.length() - 1);
                    }
                    params.put("layers", layers.toString());
                    params.put("styles", styles.toString());
                    if (layer == null) break block28;
                    index = 0;
                    if (!useLayerIndex) ** GOTO lbl64
                    index = layerIndex;
                    break block29;
                    while (!req.getLayers().get(index).getName().equals(layer)) {
                        ++index;
lbl64:
                        // 2 sources

                        if (index < req.getLayers().size()) continue;
                    }
                }
                if (req.getRawKvp().get("filter") != null) {
                    filters = KvpUtils.readFlat((String)req.getRawKvp().get("filter"), (KvpUtils.Tokenizer)KvpUtils.OUTER_DELIMETER);
                    params.put("filter", (String)filters.get(index));
                } else if (req.getRawKvp().get("cql_filter") != null) {
                    filters = KvpUtils.readFlat((String)req.getRawKvp().get("cql_filter"), (KvpUtils.Tokenizer)KvpUtils.CQL_DELIMITER);
                    params.put("cql_filter", (String)filters.get(index));
                } else if (req.getRawKvp().get("featureid") != null) {
                    params.put("featureid", req.getRawKvp().get("featureid"));
                }
                break block30;
            }
            if (req.getRawKvp().get("filter") != null) {
                params.put("filter", req.getRawKvp().get("filter"));
            } else if (req.getRawKvp().get("cql_filter") != null) {
                params.put("cql_filter", req.getRawKvp().get("cql_filter"));
            } else if (req.getRawKvp().get("featureid") != null) {
                params.put("featureid", req.getRawKvp().get("featureid"));
            }
        }
        params.put("height", String.valueOf(req.getHeight()));
        params.put("width", String.valueOf(req.getWidth()));
        params.put("transparent", "" + req.isTransparent());
        if (bbox == null) {
            bbox = req.getBbox();
        }
        if (bbox != null) {
            params.put("bbox", WMSRequests.encode(bbox));
        }
        params.put("srs", req.getSRS());
        if (req.getFormatOptions() != null && !req.getFormatOptions().isEmpty()) {
            params.put("format_options", WMSRequests.encodeFormatOptions(req.getFormatOptions()));
        }
        if (req.getViewParams() != null && !req.getViewParams().isEmpty()) {
            params.put("viewParams", WMSRequests.encodeFormatOptions(req.getViewParams()));
        }
        i = 0;
        while (kvp != null && i < kvp.length) {
            params.put(kvp[i], kvp[i + 1]);
            i += 2;
        }
        return params;
    }

    public static void encodeFormatOptions(Map formatOptions, StringBuffer sb) {
        if (formatOptions == null || formatOptions.isEmpty()) {
            return;
        }
        for (Map.Entry entry : formatOptions.entrySet()) {
            String key = (String)entry.getKey();
            Object val = entry.getValue();
            sb.append(key).append(":");
            if (val instanceof Collection) {
                Iterator i = ((Collection)val).iterator();
                while (i.hasNext()) {
                    sb.append(i.next()).append(",");
                }
                sb.setLength(sb.length() - 1);
            } else if (val.getClass().isArray()) {
                int len = Array.getLength(val);
                int i = 0;
                while (i < len) {
                    Object o = Array.get(val, i);
                    if (o != null) {
                        sb.append(o).append(",");
                    }
                    ++i;
                }
                sb.setLength(sb.length() - 1);
            } else {
                sb.append(val.toString());
            }
            sb.append(";");
        }
        sb.setLength(sb.length());
    }

    public static String encodeFormatOptions(Map formatOptions) {
        StringBuffer sb = new StringBuffer();
        WMSRequests.encodeFormatOptions(formatOptions, sb);
        return sb.toString();
    }

    public static String encodeFormatOptions(List<Map<String, String>> formatOptions) {
        if (formatOptions == null || formatOptions.isEmpty()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (Map<String, String> map : formatOptions) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            WMSRequests.encodeFormatOptions(map, sb);
        }
        sb.setLength(sb.length());
        return sb.toString();
    }

    static String encode(Envelope box) {
        return new StringBuffer().append(box.getMinX()).append(",").append(box.getMinY()).append(",").append(box.getMaxX()).append(",").append(box.getMaxY()).toString();
    }
}

