/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import java.util.HashMap;
import java.util.Map;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Request;
import org.geoserver.wms.WMSMapContext;
import org.geotools.map.MapLayer;

public abstract class WebMap {
    private String mimeType;
    private Map<String, String> responseHeaders;
    protected final WMSMapContext mapContext;

    public WebMap(WMSMapContext context) {
        this.mapContext = context;
    }

    public final void dispose() {
        if (this.mapContext != null) {
            this.mapContext.dispose();
        }
        this.disposeInternal();
    }

    protected void disposeInternal() {
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public void setResponseHeader(String name, String value) {
        if (this.responseHeaders == null) {
            this.responseHeaders = new HashMap<String, String>();
        }
        this.responseHeaders.put(name, value);
    }

    public String[][] getResponseHeaders() {
        if (this.responseHeaders == null || this.responseHeaders.size() == 0) {
            return null;
        }
        String[][] headers = new String[this.responseHeaders.size()][2];
        int index = 0;
        for (Map.Entry<String, String> entry : this.responseHeaders.entrySet()) {
            headers[index][0] = entry.getKey();
            headers[index][1] = entry.getValue();
            ++index;
        }
        return headers;
    }

    public void setContentDispositionHeader(WMSMapContext mapContext, String extension) {
        this.setContentDispositionHeader(mapContext, extension, true);
    }

    public void setContentDispositionHeader(WMSMapContext mapContext, String extension, boolean attachment) {
        String layers;
        Request request = (Request)Dispatcher.REQUEST.get();
        String filename = null;
        if (request != null && request.getRawKvp() != null && request.getRawKvp().get("LAYERS") != null && (layers = ((String)request.getRawKvp().get("LAYERS")).trim()).length() > 0) {
            filename = layers.replace(",", "_");
        }
        if (filename == null && mapContext != null) {
            StringBuffer sb = new StringBuffer();
            MapLayer[] mapLayerArray = mapContext.getLayers();
            int n = mapLayerArray.length;
            int n2 = 0;
            while (n2 < n) {
                MapLayer layer = mapLayerArray[n2];
                String title = layer.getTitle();
                if (title != null && !title.equals("")) {
                    sb.append(title).append("_");
                }
                ++n2;
            }
            if (sb.length() > 0) {
                sb.setLength(sb.length() - 1);
                filename = sb.toString();
            }
        }
        String type = attachment ? "attachment" : "inline";
        String value = filename != null && filename.length() > 0 ? String.valueOf(type) + "; filename=" + filename.replace(":", "-") + extension : String.valueOf(type) + "; filename=geoserver" + extension;
        this.setResponseHeader("Content-Disposition", value);
    }
}

