/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.animate;

import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import javax.media.jai.RenderedImageList;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WebMapService;
import org.geoserver.wms.animate.FrameLoader;

public class FrameCatalogVisitor {
    int framesNumber;
    List<Future<RenderedImage>> tasks;

    public void visit(GetMapRequest request, WebMapService wms, WMS wmsConfiguration, String aparam, String avalue) {
        if (this.tasks == null) {
            this.tasks = new LinkedList<Future<RenderedImage>>();
        }
        FrameLoader loader = new FrameLoader(request, wms, wmsConfiguration, aparam, avalue);
        FutureTask<RenderedImage> task = new FutureTask<RenderedImage>(loader);
        this.tasks.add(task);
        ++this.framesNumber;
        wmsConfiguration.getAnimatorExecutorService().execute(task);
    }

    public RenderedImageList produce(WMS wmsConfiguration) throws IOException {
        ArrayList<RenderedImage> images = new ArrayList<RenderedImage>();
        long gifAnimatedSize = 0L;
        for (Future<RenderedImage> future : this.tasks) {
            RenderedImage image = null;
            try {
                image = future.get();
            }
            catch (InterruptedException e) {
                this.dispose();
                throw new IOException(e.getMessage());
            }
            catch (ExecutionException e) {
                this.dispose();
                throw new IOException(e.getMessage());
            }
            if (image == null) continue;
            if (wmsConfiguration.getMaxRenderingSize() != null && (gifAnimatedSize += this.getImageSizeInBytes(image)) >= wmsConfiguration.getMaxRenderingSize()) {
                this.dispose();
                throw new IOException("Max rendering size exceed!");
            }
            images.add(image);
        }
        if (images == null || images.size() == 0) {
            this.dispose();
            throw new IOException("Empty list of frames.");
        }
        this.dispose();
        return new RenderedImageList(images);
    }

    private long getImageSizeInBytes(RenderedImage image) {
        int tileWidth = image.getTileWidth();
        int tileLength = image.getNumXTiles();
        int numBands = image.getSampleModel().getNumBands();
        int[] sampleSize = image.getSampleModel().getSampleSize();
        return (long)Math.ceil((double)(2 * tileWidth * tileLength * numBands) * ((double)sampleSize[0] / 8.0));
    }

    private void dispose() {
        this.framesNumber = 0;
        if (this.tasks != null) {
            this.tasks.clear();
        }
        this.tasks = null;
    }
}

