/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.capabilities;

import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.geoserver.ows.XmlRequestReader;
import org.geoserver.ows.xml.v1_0.OWS;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.GetCapabilitiesRequest;
import org.geotools.util.logging.Logging;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.ParserAdapter;
import org.xml.sax.helpers.XMLFilterImpl;

public class CapabilitiesXmlReader
extends XmlRequestReader {
    public CapabilitiesXmlReader() {
        super(OWS.GETCAPABILITIES, null, "WMS");
    }

    public Object read(Object request, Reader reader, Map kvp) throws Exception {
        GetCapabilitiesRequest req = new GetCapabilitiesRequest();
        CapabilitiesHandler currentRequest = new CapabilitiesHandler(req);
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            ParserAdapter adapter = new ParserAdapter(parser.getParser());
            adapter.setContentHandler(currentRequest);
            adapter.parse(new InputSource(reader));
        }
        catch (SAXException e) {
            throw new ServiceException((Throwable)e, "XML capabilities request parsing error", ((Object)((Object)this)).getClass().getName());
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e, "XML capabilities request input error", ((Object)((Object)this)).getClass().getName());
        }
        catch (ParserConfigurationException e) {
            throw new ServiceException((Throwable)e, "Some sort of issue creating parser", ((Object)((Object)this)).getClass().getName());
        }
        return req;
    }

    private static class CapabilitiesHandler
    extends XMLFilterImpl
    implements ContentHandler {
        private static Logger LOGGER = Logging.getLogger((String)"org.geoserver.wms.xml.CapabilitiesHandler");
        private GetCapabilitiesRequest request = null;

        public CapabilitiesHandler(GetCapabilitiesRequest request) {
            this.request = request;
        }

        public void startElement(String namespaceURI, String localName, String rawName, Attributes atts) throws SAXException {
            if (localName.equals("GetCapabilities")) {
                LOGGER.finer("found capabilities start.");
                int i = 0;
                int n = atts.getLength();
                while (i < n) {
                    if (atts.getLocalName(i).equals("version")) {
                        String version = atts.getValue(i);
                        this.request.setVersion(version);
                    } else if (!atts.getLocalName(i).equals("service") && atts.getLocalName(i).equals("updateSequence")) {
                        this.request.setUpdateSequence(atts.getValue(i));
                    }
                    ++i;
                }
            }
        }
    }
}

