/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.capabilities;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.xalan.transformer.TransformerIdentityImpl;
import org.geoserver.catalog.AttributionInfo;
import org.geoserver.catalog.AuthorityURLInfo;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.KeywordInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerIdentifierInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.LegendInfo;
import org.geoserver.catalog.MetadataLinkInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.config.ContactInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ResourceErrorHandling;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.KvpUtils;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.ExtendedCapabilitiesProvider;
import org.geoserver.wms.GetCapabilitiesRequest;
import org.geoserver.wms.GetMapOutputFormat;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.capabilities.LayerTree;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.factory.GeoTools;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.styling.Style;
import org.geotools.util.logging.Logging;
import org.geotools.xml.transform.TransformerBase;
import org.geotools.xml.transform.Translator;
import org.opengis.feature.type.Name;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;
import org.springframework.util.Assert;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Capabilities_1_3_0_Transformer
extends TransformerBase {
    private static final String NAMESPACE = "http://www.opengis.net/wms";
    public static final String WMS_CAPS_MIME = "text/xml";
    static final String[] EXCEPTION_FORMATS = new String[]{"XML", "INIMAGE", "BLANK"};
    private String schemaBaseURL;
    private Collection<GetMapOutputFormat> getMapFormats;
    private Collection<ExtendedCapabilitiesProvider> extCapsProviders;
    private WMS wmsConfig;

    public Capabilities_1_3_0_Transformer(WMS wms, String schemaBaseUrl, Collection<GetMapOutputFormat> getMapFormats, Collection<ExtendedCapabilitiesProvider> extCapsProviders) {
        Assert.notNull((Object)wms);
        Assert.notNull((Object)schemaBaseUrl, (String)"baseURL");
        Assert.notNull(getMapFormats, (String)"getMapFormats");
        this.wmsConfig = wms;
        this.getMapFormats = getMapFormats;
        this.extCapsProviders = extCapsProviders;
        this.schemaBaseURL = schemaBaseUrl;
        this.setNamespaceDeclarationEnabled(true);
        this.setIndentation(2);
        Charset encoding = wms.getCharSet();
        this.setEncoding(encoding);
    }

    public Translator createTranslator(ContentHandler handler) {
        return new Capabilities_1_3_0_Translator(handler, this.wmsConfig, this.getMapFormats, this.extCapsProviders, this.schemaBaseURL);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Capabilities_1_3_0_Translator
    extends TransformerBase.TranslatorSupport {
        private static final String XML_SCHEMA_INSTANCE = "http://www.w3.org/2001/XMLSchema-instance";
        private static final Logger LOGGER = Logging.getLogger(Capabilities_1_3_0_Translator.class);
        private static final String EPSG = "EPSG:";
        private static final String XLINK_NS = "http://www.w3.org/1999/xlink";
        private GetCapabilitiesRequest request;
        private Collection<GetMapOutputFormat> getMapFormats;
        private Collection<ExtendedCapabilitiesProvider> extCapsProviders;
        private WMS wmsConfig;
        private String schemaBaseURL;
        private boolean skipping;

        public Capabilities_1_3_0_Translator(ContentHandler handler, WMS wmsConfig, Collection<GetMapOutputFormat> getMapFormats, Collection<ExtendedCapabilitiesProvider> extCapsProviders, String schemaBaseURL) {
            super(handler, null, null);
            this.wmsConfig = wmsConfig;
            this.getMapFormats = getMapFormats;
            this.extCapsProviders = extCapsProviders;
            this.schemaBaseURL = schemaBaseURL;
            this.skipping = ResourceErrorHandling.SKIP_MISCONFIGURED_LAYERS.equals((Object)wmsConfig.getGeoServer().getGlobal().getResourceErrorHandling());
            for (ExtendedCapabilitiesProvider cp : extCapsProviders) {
                cp.registerNamespaces(this.getNamespaceSupport());
            }
        }

        private AttributesImpl attributes(String ... kvp) {
            String[] atts = kvp;
            AttributesImpl attributes = new AttributesImpl();
            int i = 0;
            while (i < atts.length) {
                String name = atts[i];
                String value = atts[i + 1];
                attributes.addAttribute("", name, name, "", value);
                i += 2;
            }
            return attributes;
        }

        public void encode(Object o) throws IllegalArgumentException {
            if (!(o instanceof GetCapabilitiesRequest)) {
                throw new IllegalArgumentException();
            }
            this.request = (GetCapabilitiesRequest)o;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(new StringBuffer("producing a capabilities document for ").append(this.request).toString());
            }
            String schemaLocation = this.buildSchemaLocation();
            String updateSequence = String.valueOf(this.wmsConfig.getUpdateSequence());
            AttributesImpl rootAtts = this.attributes("version", "1.3.0", "updateSequence", updateSequence, "xmlns", Capabilities_1_3_0_Transformer.NAMESPACE, "xmlns:xlink", XLINK_NS, "xmlns:xsi", XML_SCHEMA_INSTANCE, "xsi:schemaLocation", schemaLocation);
            this.start("WMS_Capabilities", rootAtts);
            this.handleService();
            this.handleCapability();
            this.end("WMS_Capabilities");
        }

        private String buildSchemaLocation() {
            StringBuffer schemaLocation = new StringBuffer();
            schemaLocation.append(this.schemaLocation(Capabilities_1_3_0_Transformer.NAMESPACE, "wms/1.3.0/capabilities_1_3_0.xsd"));
            for (ExtendedCapabilitiesProvider cp : this.extCapsProviders) {
                String[] locations = cp.getSchemaLocations(this.schemaBaseURL);
                try {
                    int i = 0;
                    while (i < locations.length - 1) {
                        schemaLocation.append(" ");
                        schemaLocation.append(this.schemaLocation(locations[i], locations[i + 1]));
                        i += 2;
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new ServiceException("Extended capabilities provider returned improper set of namespace,location pairs from getSchemaLocations()", (Throwable)e);
                }
            }
            return schemaLocation.toString();
        }

        String schemaLocation(String namespace, String uri) {
            String location = null;
            try {
                new URL(uri);
                location = uri;
            }
            catch (MalformedURLException e) {
                location = ResponseUtils.buildSchemaURL((String)this.schemaBaseURL, (String)uri);
            }
            return String.valueOf(namespace) + " " + location;
        }

        private void handleService() {
            this.start("Service");
            WMSInfo serviceInfo = this.wmsConfig.getServiceInfo();
            this.element("Name", "WMS");
            this.element("Title", serviceInfo.getTitle());
            this.element("Abstract", serviceInfo.getAbstract());
            this.handleKeywordList(serviceInfo.getKeywords());
            String onlineResource = serviceInfo.getOnlineResource();
            if (onlineResource == null || onlineResource.trim().length() == 0) {
                String requestBaseUrl = this.request.getBaseUrl();
                onlineResource = ResponseUtils.buildURL((String)requestBaseUrl, null, null, (URLMangler.URLType)URLMangler.URLType.SERVICE);
            } else {
                try {
                    new URL(onlineResource);
                }
                catch (MalformedURLException e) {
                    LOGGER.log(Level.WARNING, "WMS online resource seems to be an invalid URL: '" + onlineResource + "'");
                }
            }
            AttributesImpl attributes = this.attributes("xlink:type", "simple", "xlink:href", onlineResource);
            this.element("OnlineResource", null, attributes);
            GeoServer geoServer = this.wmsConfig.getGeoServer();
            ContactInfo contact = geoServer.getGlobal().getContact();
            this.handleContactInfo(contact);
            this.element("Fees", serviceInfo.getFees());
            this.element("AccessConstraints", serviceInfo.getAccessConstraints());
            this.end("Service");
        }

        public void handleContactInfo(ContactInfo contact) {
            this.start("ContactInformation");
            this.start("ContactPersonPrimary");
            this.element("ContactPerson", contact.getContactPerson());
            this.element("ContactOrganization", contact.getContactOrganization());
            this.end("ContactPersonPrimary");
            this.element("ContactPosition", contact.getContactPosition());
            this.start("ContactAddress");
            this.element("AddressType", contact.getAddressType());
            this.element("Address", contact.getAddress());
            this.element("City", contact.getAddressCity());
            this.element("StateOrProvince", contact.getAddressState());
            this.element("PostCode", contact.getAddressPostalCode());
            this.element("Country", contact.getAddressCountry());
            this.end("ContactAddress");
            this.element("ContactVoiceTelephone", contact.getContactVoice());
            this.element("ContactFacsimileTelephone", contact.getContactFacsimile());
            this.element("ContactElectronicMailAddress", contact.getContactEmail());
            this.end("ContactInformation");
        }

        private void handleKeywordList(List<KeywordInfo> keywords) {
            this.start("KeywordList");
            if (keywords != null) {
                for (KeywordInfo kw : keywords) {
                    AttributesImpl atts = new AttributesImpl();
                    if (kw.getVocabulary() != null) {
                        atts.addAttribute("", "vocabulary", "vocabulary", "", kw.getVocabulary());
                    }
                    this.element("Keyword", kw.getValue(), atts);
                }
            }
            this.end("KeywordList");
        }

        private void handleMetadataList(Collection<MetadataLinkInfo> metadataURLs) {
            if (metadataURLs == null) {
                return;
            }
            for (MetadataLinkInfo link : metadataURLs) {
                AttributesImpl lnkAtts = new AttributesImpl();
                lnkAtts.addAttribute("", "type", "type", "", link.getMetadataType());
                this.start("MetadataURL", lnkAtts);
                this.element("Format", link.getType());
                String content = link.getContent();
                try {
                    URL url = new URL(content);
                    try {
                        if ("localhost".equals(url.getHost())) {
                            Map kvp = null;
                            if (url.getQuery() != null && !"".equals(url.getQuery())) {
                                kvp = KvpUtils.parseQueryString((String)url.getQuery());
                            }
                            content = ResponseUtils.buildURL((String)this.request.getBaseUrl(), (String)url.getPath(), kvp, (URLMangler.URLType)URLMangler.URLType.RESOURCE);
                        }
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.WARNING, "Unable to create proper back referece for metadata url: " + content, e);
                    }
                }
                catch (MalformedURLException url) {
                    // empty catch block
                }
                AttributesImpl orAtts = this.attributes("xlink:type", "simple", "xlink:href", content);
                this.element("OnlineResource", null, orAtts);
                this.end("MetadataURL");
            }
        }

        private void handleCapability() {
            this.start("Capability");
            this.handleRequest();
            this.handleException();
            this.handleExtendedCapabilities();
            this.handleLayers();
            this.end("Capability");
        }

        private void handleRequest() {
            this.start("Request");
            this.start("GetCapabilities");
            this.element("Format", Capabilities_1_3_0_Transformer.WMS_CAPS_MIME);
            String serviceUrl = ResponseUtils.buildURL((String)this.request.getBaseUrl(), (String)"ows", (Map)ResponseUtils.params((String[])new String[]{"SERVICE", "WMS"}), (URLMangler.URLType)URLMangler.URLType.SERVICE);
            serviceUrl = ResponseUtils.appendQueryString((String)serviceUrl, (String)"");
            this.handleDcpType(serviceUrl, serviceUrl);
            this.end("GetCapabilities");
            this.start("GetMap");
            LinkedHashSet<String> formats = new LinkedHashSet<String>();
            for (GetMapOutputFormat format : this.getMapFormats) {
                if (format.getOutputFormatNames().contains(format.getMimeType())) {
                    formats.add(format.getMimeType());
                    continue;
                }
                if (!LOGGER.isLoggable(Level.WARNING)) continue;
                LOGGER.warning("Map output format " + format.getMimeType() + " does " + "not include mime type in output format names. Will be excluded from" + " capabilities document.");
            }
            ArrayList<String> sortedFormats = new ArrayList<String>(formats);
            Collections.sort(sortedFormats);
            if (sortedFormats.contains("image/png")) {
                sortedFormats.remove("image/png");
                sortedFormats.add(0, "image/png");
            }
            for (String format : sortedFormats) {
                this.element("Format", format);
            }
            this.handleDcpType(serviceUrl, null);
            this.end("GetMap");
            this.start("GetFeatureInfo");
            for (String format : this.wmsConfig.getAvailableFeatureInfoFormats()) {
                this.element("Format", format);
            }
            this.handleDcpType(serviceUrl, null);
            this.end("GetFeatureInfo");
            this.end("Request");
        }

        private void handleDcpType(String getUrl, String postUrl) {
            AttributesImpl orAtts = new AttributesImpl();
            orAtts.addAttribute(XLINK_NS, "type", "xlink:type", "", "simple");
            orAtts.addAttribute(XLINK_NS, "href", "xlink:href", "", getUrl);
            this.start("DCPType");
            this.start("HTTP");
            if (getUrl != null) {
                this.start("Get");
                this.element("OnlineResource", null, orAtts);
                this.end("Get");
            }
            if (postUrl != null) {
                orAtts.setAttribute(1, "", "href", "xlink:href", "", postUrl);
                this.start("Post");
                this.element("OnlineResource", null, orAtts);
                this.end("Post");
            }
            this.end("HTTP");
            this.end("DCPType");
        }

        private void handleException() {
            this.start("Exception");
            String[] stringArray = EXCEPTION_FORMATS;
            int n = EXCEPTION_FORMATS.length;
            int n2 = 0;
            while (n2 < n) {
                String exceptionFormat = stringArray[n2];
                this.element("Format", exceptionFormat);
                ++n2;
            }
            this.end("Exception");
        }

        private void handleExtendedCapabilities() {
            for (ExtendedCapabilitiesProvider cp : this.extCapsProviders) {
                try {
                    cp.encode(new ExtendedCapabilitiesProvider.Translator(){

                        public void start(String element) {
                            Capabilities_1_3_0_Translator.this.start(element);
                        }

                        public void start(String element, Attributes attributes) {
                            Capabilities_1_3_0_Translator.this.start(element, attributes);
                        }

                        public void chars(String text) {
                            Capabilities_1_3_0_Translator.this.chars(text);
                        }

                        public void end(String element) {
                            Capabilities_1_3_0_Translator.this.end(element);
                        }
                    }, this.wmsConfig.getServiceInfo(), this.request);
                }
                catch (Exception e) {
                    throw new ServiceException("Extended capabilities provider threw error", (Throwable)e);
                }
            }
        }

        private void handleLayers() {
            List<LayerInfo> layers;
            this.start("Layer");
            if (this.request.getNamespace() != null) {
                List<LayerInfo> allLayers = this.wmsConfig.getLayers();
                layers = new ArrayList<LayerInfo>();
                String namespace = this.wmsConfig.getNamespaceByPrefix(this.request.getNamespace());
                for (LayerInfo layer : allLayers) {
                    Name name = layer.getResource().getQualifiedName();
                    if (!name.getNamespaceURI().equals(namespace)) continue;
                    layers.add(layer);
                }
            } else {
                layers = this.wmsConfig.getLayers();
            }
            WMSInfo serviceInfo = this.wmsConfig.getServiceInfo();
            this.element("Title", serviceInfo.getTitle());
            this.element("Abstract", serviceInfo.getAbstract());
            List<String> srsList = serviceInfo.getSRS();
            HashSet<String> srs = new HashSet<String>();
            if (srsList != null) {
                srs.addAll(srsList);
            }
            this.handleRootCrsList(srs);
            this.handleRootBbox(layers);
            this.handleAuthorityURL(serviceInfo.getAuthorityURLs());
            this.handleLayerIdentifiers(serviceInfo.getIdentifiers());
            LayerTree featuresLayerTree = new LayerTree(layers);
            this.handleLayerTree(featuresLayerTree);
            try {
                List<LayerGroupInfo> layerGroups = this.wmsConfig.getLayerGroups();
                this.handleLayerGroups(new ArrayList<LayerGroupInfo>(layerGroups));
            }
            catch (FactoryException e) {
                throw new RuntimeException("Can't obtain Envelope of Layer-Groups: " + e.getMessage(), e);
            }
            catch (TransformException e) {
                throw new RuntimeException("Can't obtain Envelope of Layer-Groups: " + e.getMessage(), e);
            }
            this.end("Layer");
        }

        private void handleRootCrsList(Set<String> epsgCodes) {
            AbstractSet capabilitiesCrsIdentifiers;
            if (epsgCodes.isEmpty()) {
                this.comment("All supported EPSG projections:");
                capabilitiesCrsIdentifiers = new LinkedHashSet();
                for (String code : CRS.getSupportedCodes((String)"AUTO")) {
                    if ("WGS84(DD)".equals(code)) continue;
                    capabilitiesCrsIdentifiers.add("AUTO:" + code);
                }
                capabilitiesCrsIdentifiers.addAll(CRS.getSupportedCodes((String)"EPSG"));
            } else {
                this.comment("Limited list of EPSG projections:");
                capabilitiesCrsIdentifiers = new TreeSet<String>(epsgCodes);
            }
            try {
                Iterator it = capabilitiesCrsIdentifiers.iterator();
                while (it.hasNext()) {
                    String currentSRS = this.qualifySRS((String)it.next());
                    this.element("CRS", currentSRS);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            this.element("CRS", "CRS:84");
        }

        private String qualifySRS(String srs) {
            if (srs.indexOf(58) == -1) {
                srs = EPSG + srs;
            }
            return srs;
        }

        private void handleRootBbox(Collection<LayerInfo> layers) {
            Envelope latlonBbox = new Envelope();
            ReferencedEnvelope layerBbox = null;
            LOGGER.finer("Collecting summarized latlonbbox and common SRS...");
            for (LayerInfo layer : layers) {
                ResourceInfo resource = layer.getResource();
                layerBbox = resource.getLatLonBoundingBox();
                if (layerBbox == null) continue;
                latlonBbox.expandToInclude((Envelope)layerBbox);
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Summarized LatLonBBox is " + latlonBbox);
            }
            this.handleGeographicBoundingBox(latlonBbox);
            this.handleBBox(latlonBbox, "CRS:84");
            this.handleAdditionalBBox(new ReferencedEnvelope(latlonBbox, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84), null, null);
        }

        private void handleLayerTree(LayerTree layerTree) {
            ArrayList<LayerInfo> data = new ArrayList<LayerInfo>(layerTree.getData());
            Collection<LayerTree> children = layerTree.getChildrens();
            Collections.sort(data, new Comparator<LayerInfo>(){

                @Override
                public int compare(LayerInfo o1, LayerInfo o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            for (LayerInfo layer : data) {
                boolean wmsExposable = false;
                if (layer.getType() == LayerInfo.Type.RASTER || layer.getType() == LayerInfo.Type.WMS) {
                    wmsExposable = true;
                } else {
                    try {
                        wmsExposable = layer.getType() == LayerInfo.Type.VECTOR && ((FeatureTypeInfo)layer.getResource()).getFeatureType().getGeometryDescriptor() != null;
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.SEVERE, "An error occurred trying to determine if the layer is geometryless", e);
                    }
                }
                if (!layer.enabled() || !wmsExposable) continue;
                try {
                    this.mark();
                    this.handleLayer(layer);
                    this.commit();
                }
                catch (Exception e) {
                    if (this.skipping) {
                        this.reset();
                        continue;
                    }
                    throw new ServiceException("Error occurred trying to write out metadata for layer: " + layer.getName(), (Throwable)e);
                }
            }
            for (LayerTree childLayerTree : children) {
                this.start("Layer");
                this.element("Name", childLayerTree.getName());
                this.element("Title", childLayerTree.getName());
                this.handleLayerTree(childLayerTree);
                this.end("Layer");
            }
        }

        protected void handleLayer(LayerInfo layer) {
            ReferencedEnvelope bbox;
            boolean queryable = this.wmsConfig.isQueryable(layer);
            AttributesImpl qatts = this.attributes("queryable", queryable ? "1" : "0");
            Integer cascadedHopCount = this.wmsConfig.getCascadedHopCount(layer);
            if (cascadedHopCount != null) {
                qatts.addAttribute("", "cascaded", "cascaded", "", String.valueOf(cascadedHopCount));
            }
            this.start("Layer", qatts);
            this.element("Name", String.valueOf(layer.getResource().getNamespace().getPrefix()) + ":" + layer.getName());
            this.element("Title", layer.getResource().getTitle());
            this.element("Abstract", layer.getResource().getAbstract());
            this.handleKeywordList(layer.getResource().getKeywords());
            String crs = layer.getResource().getSRS();
            this.element("CRS", crs);
            this.element("CRS", "CRS:84");
            ReferencedEnvelope llbbox = layer.getResource().getLatLonBoundingBox();
            this.handleGeographicBoundingBox((Envelope)llbbox);
            this.handleBBox((Envelope)llbbox, "CRS:84");
            try {
                bbox = layer.getResource().boundingBox();
            }
            catch (Exception e) {
                throw new RuntimeException("Unexpected error obtaining bounding box for layer " + layer.getName(), e);
            }
            if (bbox != null) {
                this.handleBBox((Envelope)bbox, crs);
                this.handleAdditionalBBox(bbox, crs, layer);
            }
            this.handleDimensions(layer);
            this.handleAttribution(layer);
            this.handleAuthorityURL(layer.getAuthorityURLs());
            this.handleLayerIdentifiers(layer.getIdentifiers());
            this.handleMetadataList(layer.getResource().getMetadataLinks());
            this.handleStyles(layer);
            this.end("Layer");
        }

        private void handleStyles(LayerInfo layer) {
            if (!(layer.getResource() instanceof WMSLayerInfo)) {
                Style ftStyle;
                this.start("Style");
                StyleInfo defaultStyle = layer.getDefaultStyle();
                if (defaultStyle == null) {
                    throw new NullPointerException("Layer " + layer.getName() + " has no default style");
                }
                try {
                    ftStyle = defaultStyle.getStyle();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                this.element("Name", defaultStyle.getName());
                this.element("Title", ftStyle.getTitle());
                this.element("Abstract", ftStyle.getAbstract());
                this.handleLegendURL(layer.getName(), layer.getLegend(), null);
                this.end("Style");
                Set styles = layer.getStyles();
                for (StyleInfo styleInfo : styles) {
                    try {
                        ftStyle = styleInfo.getStyle();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    this.start("Style");
                    this.element("Name", styleInfo.getName());
                    this.element("Title", ftStyle.getTitle());
                    this.element("Abstract", ftStyle.getAbstract());
                    this.handleLegendURL(layer.getName(), null, styleInfo);
                    this.end("Style");
                }
            }
        }

        private void handleDimensions(LayerInfo layer) {
            String timeMetadataExtent = null;
            String elevationMetadataExtent = null;
            if (layer.getType() == LayerInfo.Type.RASTER) {
                CoverageInfo cvinfo = (CoverageInfo)layer.getResource();
                if (cvinfo == null) {
                    throw new RuntimeException("Unable to acquire coverage resource for layer: " + layer.getName());
                }
                Catalog catalog = cvinfo.getCatalog();
                if (catalog == null) {
                    throw new RuntimeException("Unable to acquire catalog resource for layer: " + layer.getName());
                }
                CoverageStoreInfo csinfo = cvinfo.getStore();
                if (csinfo == null) {
                    throw new RuntimeException("Unable to acquire coverage store resource for layer: " + layer.getName());
                }
                AbstractGridCoverage2DReader reader = null;
                try {
                    reader = (AbstractGridCoverage2DReader)catalog.getResourcePool().getGridCoverageReader(csinfo, GeoTools.getDefaultHints());
                }
                catch (Throwable t) {
                    LOGGER.severe("Unable to acquire a reader for this coverage with format: " + csinfo.getFormat().getName());
                }
                if (reader == null) {
                    throw new RuntimeException("Unable to acquire a reader for this coverage with format: " + csinfo.getFormat().getName());
                }
                String[] metadataNames = reader.getMetadataNames();
                if (metadataNames != null && metadataNames.length > 0) {
                    timeMetadataExtent = reader.getMetadataValue("TIME_DOMAIN");
                    if (timeMetadataExtent != null) {
                        AttributesImpl timeDim = new AttributesImpl();
                        timeDim.addAttribute("", "name", "name", "", "time");
                        timeDim.addAttribute("", "units", "units", "", "ISO8601");
                        timeDim.addAttribute("", "current", "current", "", "true");
                        timeDim.addAttribute("", "default", "default", "", "current");
                        this.element("Dimension", timeMetadataExtent, timeDim);
                    }
                    if ((elevationMetadataExtent = reader.getMetadataValue("ELEVATION_DOMAIN")) != null) {
                        String[] elevationLevels = elevationMetadataExtent.split(",");
                        AttributesImpl elevDim = new AttributesImpl();
                        elevDim.addAttribute("", "name", "name", "", "elevation");
                        elevDim.addAttribute("", "units", "units", "", "EPSG:5030");
                        elevDim.addAttribute("", "default", "default", "", elevationLevels[0]);
                        this.element("Dimension", elevationMetadataExtent, elevDim);
                    }
                }
            }
        }

        protected void handleLayerGroups(List<LayerGroupInfo> layerGroups) throws FactoryException, TransformException {
            if (layerGroups == null || layerGroups.size() == 0) {
                return;
            }
            Collections.sort(layerGroups, new Comparator<LayerGroupInfo>(){

                @Override
                public int compare(LayerGroupInfo o1, LayerGroupInfo o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            for (LayerGroupInfo layerGroup : layerGroups) {
                String layerName = layerGroup.getName();
                AttributesImpl qatts = new AttributesImpl();
                boolean queryable = this.wmsConfig.isQueryable(layerGroup);
                qatts.addAttribute("", "queryable", "queryable", "", queryable ? "1" : "0");
                this.start("Layer", qatts);
                this.element("Name", layerName);
                this.element("Title", layerName);
                this.element("Abstract", "Layer-Group type layer: " + layerName);
                ReferencedEnvelope layerGroupBounds = layerGroup.getBounds();
                ReferencedEnvelope latLonBounds = layerGroupBounds.transform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, true);
                String authority = layerGroupBounds.getCoordinateReferenceSystem().getIdentifiers().toArray()[0].toString();
                this.element("CRS", authority);
                this.handleGeographicBoundingBox((Envelope)latLonBounds);
                this.handleBBox((Envelope)layerGroupBounds, authority);
                this.handleAuthorityURL(layerGroup.getAuthorityURLs());
                this.handleLayerIdentifiers(layerGroup.getIdentifiers());
                List layers = layerGroup.getLayers();
                HashSet<MetadataLinkInfo> aggregatedLinks = new HashSet<MetadataLinkInfo>();
                for (LayerInfo layer : layers) {
                    List metadataLinks = layer.getResource().getMetadataLinks();
                    if (metadataLinks == null) continue;
                    aggregatedLinks.addAll(metadataLinks);
                }
                this.handleMetadataList(aggregatedLinks);
                this.end("Layer");
            }
        }

        protected void handleAttribution(LayerInfo layer) {
            boolean logoGood;
            AttributionInfo attribution = layer.getAttribution();
            String title = attribution.getTitle();
            String url = attribution.getHref();
            String logoURL = attribution.getLogoURL();
            String logoType = attribution.getLogoType();
            int logoWidth = attribution.getLogoWidth();
            int logoHeight = attribution.getLogoHeight();
            boolean titleGood = title != null;
            boolean urlGood = url != null;
            boolean bl = logoGood = logoURL != null && logoType != null && logoWidth > 0 && logoHeight > 0;
            if (titleGood || urlGood || logoGood) {
                this.start("Attribution");
                if (titleGood) {
                    this.element("Title", title);
                }
                if (urlGood) {
                    AttributesImpl urlAttributes = new AttributesImpl();
                    urlAttributes.addAttribute("", "xmlns:xlink", "xmlns:xlink", "", XLINK_NS);
                    urlAttributes.addAttribute(XLINK_NS, "type", "xlink:type", "", "simple");
                    urlAttributes.addAttribute(XLINK_NS, "href", "xlink:href", "", url);
                    this.element("OnlineResource", null, urlAttributes);
                }
                if (logoGood) {
                    AttributesImpl logoAttributes = new AttributesImpl();
                    logoAttributes.addAttribute("", "", "height", "", "" + logoHeight);
                    logoAttributes.addAttribute("", "", "width", "", "" + logoWidth);
                    this.start("LogoURL", logoAttributes);
                    this.element("Format", logoType);
                    AttributesImpl urlAttributes = new AttributesImpl();
                    urlAttributes.addAttribute("", "xmlns:xlink", "xmlns:xlink", "", XLINK_NS);
                    urlAttributes.addAttribute(XLINK_NS, "type", "xlink:type", "", "simple");
                    urlAttributes.addAttribute(XLINK_NS, "href", "xlink:href", "", logoURL);
                    this.element("OnlineResource", null, urlAttributes);
                    this.end("LogoURL");
                }
                this.end("Attribution");
            }
        }

        protected void handleLegendURL(String layerName, LegendInfo legend, StyleInfo style) {
            if (legend != null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("using user supplied legend URL");
                }
                AttributesImpl attrs = new AttributesImpl();
                attrs.addAttribute("", "width", "width", "", String.valueOf(legend.getWidth()));
                attrs.addAttribute("", "height", "height", "", String.valueOf(legend.getHeight()));
                this.start("LegendURL", attrs);
                this.element("Format", legend.getFormat());
                attrs.clear();
                attrs.addAttribute("", "xmlns:xlink", "xmlns:xlink", "", XLINK_NS);
                attrs.addAttribute(XLINK_NS, "type", "xlink:type", "", "simple");
                attrs.addAttribute(XLINK_NS, "href", "xlink:href", "", legend.getOnlineResource());
                this.element("OnlineResource", null, attrs);
                this.end("LegendURL");
            } else {
                String defaultFormat = "image/png";
                if (this.wmsConfig.getLegendGraphicOutputFormat(defaultFormat) == null) {
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.warning(new StringBuffer("Default legend format (").append(defaultFormat).append(")is not supported (jai not available?), can't add LegendURL element").toString());
                    }
                    return;
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Adding GetLegendGraphic call as LegendURL");
                }
                AttributesImpl attrs = new AttributesImpl();
                attrs.addAttribute("", "width", "width", "", String.valueOf(20));
                attrs.addAttribute("", "height", "height", "", String.valueOf(20));
                this.start("LegendURL", attrs);
                this.element("Format", defaultFormat);
                attrs.clear();
                Map params = ResponseUtils.params((String[])new String[]{"service", "WMS", "request", "GetLegendGraphic", "format", defaultFormat, "width", String.valueOf(20), "height", String.valueOf(20), "layer", layerName});
                if (style != null) {
                    params.put("style", style.getName());
                }
                String legendURL = ResponseUtils.buildURL((String)this.request.getBaseUrl(), (String)"ows", (Map)params, (URLMangler.URLType)URLMangler.URLType.SERVICE);
                attrs.addAttribute("", "xmlns:xlink", "xmlns:xlink", "", XLINK_NS);
                attrs.addAttribute(XLINK_NS, "type", "xlink:type", "", "simple");
                attrs.addAttribute(XLINK_NS, "href", "xlink:href", "", legendURL);
                this.element("OnlineResource", null, attrs);
                this.end("LegendURL");
            }
        }

        private void handleGeographicBoundingBox(Envelope bbox) {
            String minx = String.valueOf(bbox.getMinX());
            String miny = String.valueOf(bbox.getMinY());
            String maxx = String.valueOf(bbox.getMaxX());
            String maxy = String.valueOf(bbox.getMaxY());
            this.start("EX_GeographicBoundingBox");
            this.element("westBoundLongitude", minx);
            this.element("eastBoundLongitude", maxx);
            this.element("southBoundLatitude", miny);
            this.element("northBoundLatitude", maxy);
            this.end("EX_GeographicBoundingBox");
        }

        public void comment(String comment) {
            if (this.contentHandler instanceof TransformerIdentityImpl) {
                try {
                    TransformerIdentityImpl ch = (TransformerIdentityImpl)this.contentHandler;
                    ch.comment(comment.toCharArray(), 0, comment.length());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        private void handleBBox(Envelope bbox, String srs) {
            String minx = String.valueOf(bbox.getMinX());
            String miny = String.valueOf(bbox.getMinY());
            String maxx = String.valueOf(bbox.getMaxX());
            String maxy = String.valueOf(bbox.getMaxY());
            CoordinateReferenceSystem crs = null;
            try {
                crs = CRS.decode((String)WMS.toInternalSRS(srs, WMS.VERSION_1_3_0));
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Unable to decode " + srs, e);
            }
            if (crs != null && CRS.getAxisOrder((CoordinateReferenceSystem)crs) == CRS.AxisOrder.NORTH_EAST) {
                String tmp = minx;
                minx = miny;
                miny = tmp;
                tmp = maxx;
                maxx = maxy;
                maxy = tmp;
            }
            AttributesImpl bboxAtts = this.attributes("CRS", srs, "minx", minx, "miny", miny, "maxx", maxx, "maxy", maxy);
            this.element("BoundingBox", null, bboxAtts);
        }

        private void handleAdditionalBBox(ReferencedEnvelope bbox, String crs, LayerInfo layer) {
            WMSInfo info = this.wmsConfig.getServiceInfo();
            if (info.isBBOXForEachCRS() && !info.getSRS().isEmpty()) {
                for (String srs : info.getSRS()) {
                    srs = this.qualifySRS(srs);
                    if (crs != null && srs.equals(crs)) continue;
                    try {
                        ReferencedEnvelope tbbox = bbox.transform(CRS.decode((String)srs), true);
                        this.handleBBox((Envelope)tbbox, srs);
                    }
                    catch (Exception e) {
                        LOGGER.warning(String.format("Unable to transform bounding box for '%s' layer to %s", layer != null ? layer.getName() : "root", srs));
                        if (!LOGGER.isLoggable(Level.FINE)) continue;
                        LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                    }
                }
            }
        }

        private void handleAuthorityURL(List<AuthorityURLInfo> authorityURLs) {
            if (authorityURLs == null || authorityURLs.isEmpty()) {
                return;
            }
            AttributesImpl atts = new AttributesImpl();
            for (AuthorityURLInfo url : authorityURLs) {
                String name = url.getName();
                String href = url.getHref();
                if (name == null || href == null) {
                    LOGGER.warning("Ignoring AuthorityURL, name: " + name + ", href: " + href);
                    continue;
                }
                atts.clear();
                atts.addAttribute("", "name", "name", "", name);
                this.start("AuthorityURL", atts);
                atts.clear();
                atts.addAttribute("", "xlink:type", "xlink:type", "", "simple");
                atts.addAttribute("", "xlink:href", "xlink:href", "", href);
                this.element("OnlineResource", null, atts);
                this.end("AuthorityURL");
            }
        }

        private void handleLayerIdentifiers(List<LayerIdentifierInfo> identifiers) {
            if (identifiers == null || identifiers.isEmpty()) {
                return;
            }
            AttributesImpl atts = new AttributesImpl();
            for (LayerIdentifierInfo identifier : identifiers) {
                String authority = identifier.getAuthority();
                String id = identifier.getIdentifier();
                if (authority == null || id == null) {
                    LOGGER.warning("Ignoring layer Identifier, authority: " + authority + ", identifier: " + id);
                    continue;
                }
                atts.clear();
                atts.addAttribute("", "authority", "authority", "", authority);
                this.element("Identifier", id, atts);
            }
        }
    }
}

