/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.featureinfo;

import java.io.IOException;
import org.geoserver.wms.featureinfo.FeatureTemplate;
import org.opengis.feature.simple.SimpleFeature;

public class FeatureTimeTemplate {
    FeatureTemplate delegate;

    public FeatureTimeTemplate() {
        this(new FeatureTemplate());
    }

    public FeatureTimeTemplate(FeatureTemplate delegate) {
        this.delegate = delegate;
    }

    public String[] execute(SimpleFeature feature) throws IOException {
        String output = this.delegate.template(feature, "time.ftl", this.getClass());
        if (output != null) {
            output = output.trim();
        }
        if (output == null || "".equals(output)) {
            return new String[0];
        }
        String[] timespan = output.split("\\|\\|");
        if (output.endsWith("||")) {
            String[] stringArray = new String[2];
            stringArray[0] = timespan[0];
            timespan = stringArray;
        }
        if (timespan.length > 2) {
            String msg = "Incorrect time syntax. Should be: <date>||<date>";
            throw new IllegalArgumentException(msg);
        }
        if (timespan.length == 1) {
            return timespan;
        }
        if (timespan[0] == null || "".equals(timespan[0].trim())) {
            timespan[0] = null;
        }
        if (timespan[1] == null || "".equals(timespan[1].trim())) {
            timespan[1] = null;
        }
        return timespan;
    }
}

