/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import com.sun.media.imageioimpl.plugins.gif.GIFImageWriter;
import com.sun.media.imageioimpl.plugins.gif.GIFImageWriterSpi;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedImageList;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.MapProducerCapabilities;
import org.geoserver.wms.RasterCleaner;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSMapContext;
import org.geoserver.wms.map.RenderedImageMapResponse;
import org.geotools.image.ImageWorker;
import org.geotools.resources.image.ImageUtilities;
import org.geotools.util.logging.Logging;

public final class GIFMapResponse
extends RenderedImageMapResponse {
    private static final Logger LOGGER = Logging.getLogger(GIFMapResponse.class);
    private static final String IMAGE_GIF_SUBTYPE_ANIMATED = "image/gif;subtype=animated";
    private static final GIFImageWriterSpi ORIGINATING_PROVIDER = new GIFImageWriterSpi();
    static final String MIME_TYPE = "image/gif";
    static final String[] OUTPUT_FORMATS = new String[]{"image/gif", "image/gif;subtype=animated"};
    private static MapProducerCapabilities CAPABILITIES = new MapProducerCapabilities(true, false, true, true, "image/gif");
    private static MapProducerCapabilities CAPABILITIES_ANIM = new MapProducerCapabilities(true, true, true, true, "image/gif");

    public GIFMapResponse(WMS wms) {
        super(OUTPUT_FORMATS, wms);
    }

    /*
     * Unable to fully structure code
     */
    public void formatImageOutputStream(RenderedImage originalImage, OutputStream outStream, WMSMapContext mapContent) throws ServiceException, IOException {
        if (GIFMapResponse.LOGGER.isLoggable(Level.FINE)) {
            GIFMapResponse.LOGGER.fine("Writing gif image ...");
        }
        format = mapContent.getRequest().getFormat();
        animatedGIF = false;
        if (format.equalsIgnoreCase("image/gif;subtype=animated")) {
            animatedGIF = true;
        }
        numfiles = 1;
        if (originalImage instanceof RenderedImageList) {
            ril = (RenderedImageList)originalImage;
            numfiles = ril.size();
        } else {
            ril = new RenderedImageList(Arrays.asList(new RenderedImage[]{originalImage}));
        }
        if (numfiles == 1 || !animatedGIF) {
            if (GIFMapResponse.LOGGER.isLoggable(Level.FINE)) {
                GIFMapResponse.LOGGER.fine("Preparing to write a gif...");
            }
            try {
                paletteInverter = mapContent.getPaletteInverter();
                iw = new ImageWorker(super.forceIndexed8Bitmask(originalImage, paletteInverter));
                iw.writeGIF((Object)outStream, "LZW", 0.75f);
                RasterCleaner.addImage(iw.getRenderedImage());
            }
            catch (IOException e) {
                throw new ServiceException((Throwable)e);
            }
            return;
        }
        if (numfiles <= 0) {
            throw new ServiceException("The number of frames for this GIF is less than 1");
        }
        gifWriter = new GIFImageWriter(GIFMapResponse.ORIGINATING_PROVIDER);
        param = gifWriter.getDefaultWriteParam();
        param.setCompressionMode(2);
        param.setCompressionType("LZW");
        param.setCompressionQuality(0.75f);
        otStream = null;
        images = new ArrayList<RenderedImage>();
        try {
            try {
                otStream = ImageIO.createImageOutputStream(outStream);
                gifWriter.setOutput((Object)otStream);
                gifWriter.prepareWriteSequence(null);
                request = mapContent.getRequest();
                loopContinuosly = request.getFormatOptions().get("gif_loop_continuosly") != null ? Boolean.valueOf((String)request.getFormatOptions().get("gif_loop_continuosly")) : this.wms.getLoopContinuously();
                v0 = delay = request.getFormatOptions().get("gif_frames_delay") != null ? Integer.valueOf((String)request.getFormatOptions().get("gif_frames_delay")) : this.wms.getFramesDelay();
                if (delay <= 0) {
                    throw new ServiceException("Animate GIF delay invalid: " + delay);
                }
                i = 0;
                while (i < numfiles) {
                    if (GIFMapResponse.LOGGER.isLoggable(Level.FINE)) {
                        GIFMapResponse.LOGGER.fine("Writing image " + i);
                    }
                    ri = (RenderedImage)ril.get(i);
                    paletteInverter = mapContent.getPaletteInverter();
                    if ((ri = super.forceIndexed8Bitmask(ri, paletteInverter)) != null) {
                        imageMetadata = gifWriter.getDefaultImageMetadata(new ImageTypeSpecifier(ri), param);
                        this.prepareMetadata(imageMetadata, loopContinuosly, delay);
                        gifWriter.writeToSequence(new IIOImage(ri, null, imageMetadata), param);
                        images.add(ri);
                    }
                    ++i;
                }
                gifWriter.endWriteSequence();
            }
            catch (IOException e) {
                throw new ServiceException((Throwable)e);
            }
        }
        finally {
            try {
                otStream.flush();
            }
            catch (Exception image) {}
            try {
                otStream.close();
            }
            catch (Exception image) {}
            try {
                gifWriter.dispose();
            }
            catch (Exception image) {}
            ** for (image : images)
        }
lbl-1000:
        // 1 sources

        {
            if (image instanceof PlanarImage) {
                ImageUtilities.disposePlanarImageChain((PlanarImage)((PlanarImage)image));
                continue;
            }
            if (!(image instanceof BufferedImage)) continue;
            ((BufferedImage)image).flush();
            continue;
        }
lbl83:
        // 1 sources

        if (GIFMapResponse.LOGGER.isLoggable(Level.FINE)) {
            GIFMapResponse.LOGGER.fine("Done writing animated gif");
        }
    }

    public String getContentDisposition() {
        return null;
    }

    private void prepareMetadata(IIOMetadata imageMetadata, boolean loopContinuously, int timeBetweenFramesMS) throws IOException {
        String metaFormatName = imageMetadata.getNativeMetadataFormatName();
        IIOMetadataNode root = (IIOMetadataNode)imageMetadata.getAsTree(metaFormatName);
        IIOMetadataNode graphicsControlExtensionNode = GIFMapResponse.getNode(root, "GraphicControlExtension");
        graphicsControlExtensionNode.setAttribute("disposalMethod", "none");
        graphicsControlExtensionNode.setAttribute("userInputFlag", "FALSE");
        graphicsControlExtensionNode.setAttribute("transparentColorFlag", "FALSE");
        graphicsControlExtensionNode.setAttribute("delayTime", Integer.toString(timeBetweenFramesMS / 10));
        graphicsControlExtensionNode.setAttribute("transparentColorIndex", "0");
        IIOMetadataNode commentsNode = GIFMapResponse.getNode(root, "CommentExtensions");
        commentsNode.setAttribute("CommentExtension", "Created by MAH");
        IIOMetadataNode appEntensionsNode = GIFMapResponse.getNode(root, "ApplicationExtensions");
        IIOMetadataNode child = new IIOMetadataNode("ApplicationExtension");
        child.setAttribute("applicationID", "NETSCAPE");
        child.setAttribute("authenticationCode", "2.0");
        int loop = loopContinuously ? 0 : 1;
        child.setUserObject(new byte[]{1, (byte)(loop & 0xFF), (byte)(loop >> 8 & 0xFF)});
        appEntensionsNode.appendChild(child);
        imageMetadata.setFromTree(metaFormatName, root);
    }

    private static IIOMetadataNode getNode(IIOMetadataNode rootNode, String nodeName) {
        int nNodes = rootNode.getLength();
        int i = 0;
        while (i < nNodes) {
            if (rootNode.item(i).getNodeName().compareToIgnoreCase(nodeName) == 0) {
                return (IIOMetadataNode)rootNode.item(i);
            }
            ++i;
        }
        IIOMetadataNode node = new IIOMetadataNode(nodeName);
        rootNode.appendChild(node);
        return node;
    }

    public MapProducerCapabilities getCapabilities(String outputFormat) {
        return CAPABILITIES_ANIM;
    }
}

