/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapProducerCapabilities;
import org.geoserver.wms.RasterCleaner;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSMapContext;
import org.geoserver.wms.map.RenderedImageMapResponse;
import org.geotools.image.ImageWorker;
import org.geotools.image.palette.InverseColorMapOp;
import org.geotools.util.logging.Logging;

public class PNGMapResponse
extends RenderedImageMapResponse {
    private static final Logger LOGGER = Logging.getLogger(PNGMapResponse.class);
    private static final String MIME_TYPE = "image/png";
    private static final String MIME_TYPE_8BIT = "image/png; mode=8bit";
    private static final String[] OUTPUT_FORMATS = new String[]{"image/png", "image/png; mode=8bit", "image/png8"};
    private static MapProducerCapabilities CAPABILITIES = new MapProducerCapabilities(true, false, true, true, null);

    public PNGMapResponse(WMS wms) {
        super(OUTPUT_FORMATS, wms);
    }

    public String getMimeType(Object value, Operation operation) throws ServiceException {
        GetMapRequest request = (GetMapRequest)operation.getParameters()[0];
        if (request.getFormat().contains("8")) {
            return MIME_TYPE_8BIT;
        }
        return MIME_TYPE;
    }

    public void formatImageOutputStream(RenderedImage image, OutputStream outStream, WMSMapContext mapContext) throws ServiceException, IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Writing png image ...");
        }
        String format = mapContext.getRequest().getFormat();
        if (mapContext.getPaletteInverter() != null) {
            InverseColorMapOp paletteInverter = mapContext.getPaletteInverter();
            image = this.forceIndexed8Bitmask(image, paletteInverter);
        }
        Boolean PNGNativeAcc = this.wms.getPNGNativeAcceleration();
        float quality = (float)(100 - this.wms.getPngCompression()) / 100.0f;
        SampleModel sm = image.getSampleModel();
        int numBits = sm.getSampleSize(0);
        boolean nativeAcceleration = PNGNativeAcc != false && (numBits <= 1 || numBits >= 8);
        boolean png8 = "image/png8".equalsIgnoreCase(format);
        if (png8 && !(image.getColorModel() instanceof IndexColorModel)) {
            image = this.forceIndexed8Bitmask(image, null);
        }
        ImageWorker iw = new ImageWorker(image);
        iw.writePNG((Object)outStream, "FILTERED", quality, nativeAcceleration, png8);
        RasterCleaner.addImage(iw.getRenderedImage());
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Writing png image ... done!");
        }
    }

    public MapProducerCapabilities getCapabilities(String outputFormat) {
        return CAPABILITIES;
    }
}

