/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.GetMapOutputFormat;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSMapContext;
import org.geoserver.wms.WebMap;
import org.geoserver.wms.map.MetatileMapOutputFormat;
import org.geoserver.wms.map.RenderedImageMapOutputFormat;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.QueryCapabilities;
import org.geotools.data.ows.Layer;
import org.geotools.data.wms.WebMapServer;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollection;
import org.geotools.map.DefaultMapLayer;
import org.geotools.map.FeatureSourceMapLayer;
import org.geotools.map.MapLayer;
import org.geotools.map.WMSMapLayer;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.lite.MetaBufferEstimator;
import org.geotools.renderer.lite.RendererUtilities;
import org.geotools.resources.coverage.FeatureUtilities;
import org.geotools.styling.FeatureTypeConstraint;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Rule;
import org.geotools.styling.Style;
import org.geotools.util.logging.Logging;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetMap {
    private static final Logger LOGGER = Logging.getLogger(GetMap.class);
    private FilterFactory filterFac;
    private final WMS wms;

    public GetMap(WMS wms) {
        this.wms = wms;
        this.filterFac = CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints());
    }

    public void setFilterFactory(FilterFactory filterFactory) {
        this.filterFac = filterFactory;
    }

    public WebMap run(GetMapRequest request) throws ServiceException {
        WMSMapContext mapContext = new WMSMapContext(request);
        try {
            return this.run(request, mapContext);
        }
        catch (ServiceException e) {
            mapContext.dispose();
            throw e;
        }
        catch (RuntimeException e) {
            mapContext.dispose();
            throw e;
        }
        catch (Exception e) {
            mapContext.dispose();
            throw new ServiceException("Internal error ", (Throwable)e);
        }
    }

    public WebMap run(GetMapRequest request, WMSMapContext mapContext) throws ServiceException, IOException {
        this.assertMandatory(request);
        String outputFormat = request.getFormat();
        GetMapOutputFormat delegate = this.getDelegate(outputFormat);
        Envelope env = request.getBbox();
        if (MetatileMapOutputFormat.isRequestTiled(request, delegate)) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("Tiled request detected, activating on the fly meta tiler");
            }
            delegate = new MetatileMapOutputFormat(request, (RenderedImageMapOutputFormat)delegate);
        }
        List<MapLayerInfo> layers = request.getLayers();
        List<Map<String, String>> viewParams = request.getViewParams();
        Style[] styles = request.getStyles().toArray(new Style[0]);
        Filter[] filters = this.buildLayersFilters(request.getFilter(), layers);
        CoordinateReferenceSystem mapcrs = request.getCrs();
        if (mapcrs != null) {
            mapContext.setAreaOfInterest(env, mapcrs);
        } else {
            mapContext.setAreaOfInterest(env, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        }
        mapContext.setMapWidth(request.getWidth());
        mapContext.setMapHeight(request.getHeight());
        mapContext.setAngle(request.getAngle());
        mapContext.setBgColor(request.getBgColor());
        mapContext.setTransparent(request.isTransparent());
        mapContext.setBuffer(request.getBuffer());
        mapContext.setPaletteInverter(request.getPalette());
        if (request.getWidth() <= 0 || request.getHeight() <= 0 || mapContext.getAreaOfInterest().getLength(0) <= 0.0 || mapContext.getAreaOfInterest().getLength(1) <= 0.0) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("We are not going to render anything because either the area is null or the dimensions are not positive.");
            }
            return null;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("setting up map");
        }
        boolean cachingPossible = request.isGet();
        String featureVersion = request.getFeatureVersion();
        int maxAge = Integer.MAX_VALUE;
        int i = 0;
        while (i < layers.size()) {
            Query definitionQuery;
            DefaultMapLayer layer;
            FeatureSource<? extends FeatureType, ? extends Feature> source;
            MapLayerInfo mapLayerInfo = layers.get(i);
            if (cachingPossible &= mapLayerInfo.isCachingEnabled()) {
                maxAge = Math.min(maxAge, mapLayerInfo.getCacheMaxAge());
            } else {
                cachingPossible = false;
            }
            Style layerStyle = styles[i];
            Filter layerFilter = filters[i];
            int layerType = mapLayerInfo.getType();
            if (layerType == MapLayerInfo.TYPE_REMOTE_VECTOR) {
                source = mapLayerInfo.getRemoteFeatureSource();
                layer = new DefaultMapLayer((FeatureSource)source, layerStyle);
                layer.setTitle(((SimpleFeatureType)mapLayerInfo.getRemoteFeatureSource().getSchema()).getTypeName());
                definitionQuery = new Query(((SimpleFeatureType)source.getSchema()).getTypeName());
                definitionQuery.setFilter(layerFilter);
                definitionQuery.setVersion(featureVersion);
                int maxFeatures = request.getMaxFeatures() != null ? request.getMaxFeatures() : Integer.MAX_VALUE;
                definitionQuery.setMaxFeatures(maxFeatures);
                layer.setQuery(definitionQuery);
                mapContext.addLayer((MapLayer)layer);
            } else if (layerType == MapLayerInfo.TYPE_VECTOR) {
                Integer startIndex;
                try {
                    source = mapLayerInfo.getFeatureSource(true);
                }
                catch (IOException exp) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, new StringBuffer("Getting feature source: ").append(exp.getMessage()).toString(), exp);
                    }
                    throw new ServiceException("Internal error", (Throwable)exp);
                }
                layer = new FeatureSourceMapLayer(source, layerStyle);
                layer.setTitle(mapLayerInfo.getFeature().getPrefixedName());
                definitionQuery = new Query(source.getSchema().getName().getLocalPart());
                definitionQuery.setVersion(featureVersion);
                definitionQuery.setFilter(layerFilter);
                if (viewParams != null) {
                    definitionQuery.setHints(new Hints((RenderingHints.Key)Hints.VIRTUAL_TABLE_PARAMETERS, viewParams.get(i)));
                }
                if ((startIndex = request.getStartIndex()) != null) {
                    QueryCapabilities queryCapabilities = source.getQueryCapabilities();
                    if (queryCapabilities.isOffsetSupported()) {
                        definitionQuery.setStartIndex(startIndex);
                    } else {
                        throw new ServiceException("startIndex is not supported for the " + mapLayerInfo.getName() + " layer");
                    }
                }
                int maxFeatures = request.getMaxFeatures() != null ? request.getMaxFeatures() : Integer.MAX_VALUE;
                definitionQuery.setMaxFeatures(maxFeatures);
                layer.setQuery(definitionQuery);
                mapContext.addLayer((MapLayer)layer);
            } else {
                if (layerType == MapLayerInfo.TYPE_RASTER) {
                    AbstractGridCoverage2DReader reader = (AbstractGridCoverage2DReader)mapLayerInfo.getCoverageReader();
                    if (reader != null) {
                        GeneralParameterValue[] readParameters = this.wms.getWMSReadParameters(request, mapLayerInfo, layerFilter, reader, false);
                        try {
                            try {
                                layer = new DefaultMapLayer((FeatureCollection)FeatureUtilities.wrapGridCoverageReader((AbstractGridCoverage2DReader)reader, (GeneralParameterValue[])readParameters), layerStyle);
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                            layer.setTitle(mapLayerInfo.getCoverage().getPrefixedName());
                            layer.setQuery(Query.ALL);
                            mapContext.addLayer((MapLayer)layer);
                        }
                        catch (IllegalArgumentException e) {
                            if (LOGGER.isLoggable(Level.SEVERE)) {
                                LOGGER.log(Level.SEVERE, "Wrapping GC in feature source: " + e.getLocalizedMessage(), e);
                            }
                            throw new ServiceException("Internal error : unable to get reader for this coverage layer " + mapLayerInfo);
                        }
                    }
                    throw new ServiceException(new StringBuffer("Internal error : unable to get reader for this coverage layer ").append(mapLayerInfo.toString()).toString());
                }
                if (layerType == MapLayerInfo.TYPE_WMS) {
                    WMSMapLayer lastWMS;
                    WebMapServer otherWMS;
                    MapLayer lastLayer;
                    WMSLayerInfo wmsLayer = (WMSLayerInfo)mapLayerInfo.getResource();
                    WebMapServer wms = wmsLayer.getStore().getWebMapServer(null);
                    Layer gt2Layer = wmsLayer.getWMSLayer(null);
                    boolean merged = false;
                    if (mapContext.getLayerCount() > 0 && (lastLayer = mapContext.getLayer(mapContext.getLayerCount() - 1)) instanceof WMSMapLayer && (otherWMS = (lastWMS = (WMSMapLayer)lastLayer).getWebMapServer()).equals(wms)) {
                        lastWMS.addLayer(gt2Layer);
                        merged = true;
                    }
                    if (!merged) {
                        WMSMapLayer mapLayer = new WMSMapLayer(wms, gt2Layer);
                        mapLayer.setTitle(wmsLayer.getPrefixedName());
                        mapContext.addLayer((MapLayer)mapLayer);
                    }
                } else {
                    throw new IllegalArgumentException("Unkown layer type " + layerType);
                }
            }
            ++i;
        }
        GetMap.setupRenderingBuffer(mapContext, layers);
        WebMap map = delegate.produceMap(mapContext);
        if (cachingPossible) {
            map.setResponseHeader("Cache-Control", "max-age=" + maxAge + ", must-revalidate");
            GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
            calendar.add(13, maxAge);
            SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
            format.setTimeZone(TimeZone.getTimeZone("GMT"));
            map.setResponseHeader("Expires", format.format(calendar.getTime()));
        }
        return map;
    }

    public static void setupRenderingBuffer(WMSMapContext map, List<MapLayerInfo> layers) {
        if (map.getBuffer() > 0) {
            return;
        }
        int[] layerBuffers = new int[layers.size()];
        boolean computeBuffer = false;
        int i = 0;
        while (i < layers.size()) {
            Integer layerBuffer;
            LayerInfo layerInfo = layers.get(i).getLayerInfo();
            if (layerInfo != null && (layerBuffer = (Integer)layerInfo.getMetadata().get("buffer", Integer.class)) != null && layerBuffer > 0) {
                computeBuffer = true;
                layerBuffers[i] = layerBuffer;
            }
            ++i;
        }
        if (computeBuffer) {
            double scaleDenominator = GetMap.getRequestScale(map);
            int buffer = 0;
            int i2 = 0;
            while (i2 < layers.size()) {
                int layerBuffer = layerBuffers[i2];
                if (layerBuffer == 0) {
                    layerBuffer = GetMap.computeLayerBuffer(map.getLayer(i2).getStyle(), scaleDenominator);
                }
                if (layerBuffer > buffer) {
                    buffer = layerBuffer;
                }
                ++i2;
            }
            map.setBuffer(buffer);
        }
    }

    static int computeLayerBuffer(Style style, double scaleDenominator) {
        double TOLERANCE = 1.0E-6;
        MetaBufferEstimator estimator = new MetaBufferEstimator();
        for (FeatureTypeStyle fts : style.featureTypeStyles()) {
            for (Rule rule : fts.rules()) {
                if (!(rule.getMinScaleDenominator() - 1.0E-6 <= scaleDenominator) || !(rule.getMaxScaleDenominator() + 1.0E-6 > scaleDenominator)) continue;
                estimator.visit(rule);
            }
        }
        return estimator.getBuffer();
    }

    static double getRequestScale(WMSMapContext map) {
        HashMap<String, Integer> hints = new HashMap<String, Integer>();
        if (map.getRequest().getFormatOptions().get("dpi") != null) {
            hints.put("dpi", (Integer)map.getRequest().getFormatOptions().get("dpi"));
        }
        return RendererUtilities.calculateOGCScaleAffine((CoordinateReferenceSystem)map.getCoordinateReferenceSystem(), (AffineTransform)map.getRenderingTransform(), hints);
    }

    private void assertMandatory(GetMapRequest request) throws ServiceException {
        if (request.getWidth() <= 0 || request.getHeight() <= 0) {
            throw new ServiceException("Missing or invalid requested map size. Parameters WIDTH and HEIGHT shall be present and be integers > 0. Got WIDTH=" + request.getWidth() + ", HEIGHT=" + request.getHeight(), "MissingOrInvalidParameter");
        }
        if (request.getLayers().size() == 0) {
            throw new ServiceException("No layers have been requested", "LayerNotDefined");
        }
        if (request.getStyles().size() == 0) {
            throw new ServiceException("No styles have been requested", "StyleNotDefined");
        }
        if (request.getFormat() == null) {
            throw new ServiceException("No output map format requested", "InvalidFormat");
        }
        Envelope env = request.getBbox();
        if (env == null) {
            throw new ServiceException("GetMap requests must include a BBOX parameter.", "MissingBBox");
        }
        if (env.isNull() || env.getWidth() <= 0.0 || env.getHeight() <= 0.0) {
            throw new ServiceException(new StringBuffer("The request bounding box has zero area: ").append(env).toString(), "InvalidBBox");
        }
    }

    private Filter[] buildLayersFilters(List<Filter> requestFilters, List<MapLayerInfo> layers) {
        int nLayers = layers.size();
        if (requestFilters == null || requestFilters.size() == 0) {
            requestFilters = Collections.nCopies(layers.size(), Filter.INCLUDE);
        } else if (requestFilters.size() != nLayers) {
            throw new IllegalArgumentException("requested filters and number of layers do not match");
        }
        Filter[] combinedList = new Filter[nLayers];
        int i = 0;
        while (i < nLayers) {
            MapLayerInfo layer = layers.get(i);
            Filter userRequestedFilter = requestFilters.get(i);
            if (layer.getType() == MapLayerInfo.TYPE_REMOTE_VECTOR || layer.getType() == MapLayerInfo.TYPE_RASTER) {
                combinedList[i] = userRequestedFilter;
            } else if (layer.getType() == MapLayerInfo.TYPE_VECTOR) {
                Filter layerDefinitionFilter = layer.getFeature().getFilter();
                if (layerDefinitionFilter == null) {
                    layerDefinitionFilter = Filter.INCLUDE;
                }
                And combined = this.filterFac.and(layerDefinitionFilter, userRequestedFilter);
                FeatureTypeConstraint[] featureTypeConstraints = layer.getLayerFeatureConstraints();
                if (featureTypeConstraints != null) {
                    ArrayList<Filter> filters = new ArrayList<Filter>();
                    int j = 0;
                    while (j < featureTypeConstraints.length) {
                        FeatureTypeConstraint featureTypeConstraint = featureTypeConstraints[j];
                        filters.add(featureTypeConstraint.getFilter());
                        ++j;
                    }
                    combined = this.filterFac.and((Filter)combined, (Filter)this.filterFac.and(filters));
                }
                combinedList[i] = combined;
            }
            ++i;
        }
        return combinedList;
    }

    private GetMapOutputFormat getDelegate(String outputFormat) throws ServiceException {
        GetMapOutputFormat producer = this.wms.getMapOutputFormat(outputFormat);
        if (producer == null) {
            ServiceException e = new ServiceException("There is no support for creating maps in " + outputFormat + " format", "InvalidFormat");
            e.setCode("InvalidFormat");
            throw e;
        }
        return producer;
    }
}

