/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import com.vividsolutions.jts.geom.Geometry;
import org.geoserver.catalog.AttributeTypeInfo;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.impl.AbstractCatalogValidator;
import org.geotools.factory.GeoTools;

public class WMSValidator
extends AbstractCatalogValidator {
    public void validate(LayerInfo lyr, boolean isNew) {
        if (!lyr.isEnabled()) {
            return;
        }
        if (lyr.getResource() == null || WMSValidator.hasGeometry(lyr) && (lyr.getResource().getSRS() == null || lyr.getResource().getLatLonBoundingBox() == null)) {
            throw new RuntimeException("Layer's resource is not fully configured");
        }
        if (lyr.getType() == LayerInfo.Type.RASTER) {
            if (!(lyr.getResource() instanceof CoverageInfo)) {
                throw new RuntimeException("Layer with type RASTER doesn't have a coverage associated");
            }
            CoverageInfo cvinfo = (CoverageInfo)lyr.getResource();
            try {
                cvinfo.getCatalog().getResourcePool().getGridCoverageReader(cvinfo.getStore(), GeoTools.getDefaultHints());
            }
            catch (Throwable t) {
                throw new RuntimeException("Couldn't connect to raster layer's resource");
            }
        } else if (lyr.getType() == LayerInfo.Type.VECTOR) {
            if (!(lyr.getResource() instanceof FeatureTypeInfo)) {
                throw new RuntimeException("Layer with type VECTOR doesn't have a featuretype associated");
            }
            FeatureTypeInfo featureTypeInfo = (FeatureTypeInfo)lyr.getResource();
        } else {
            throw new RuntimeException("Layer is neither RASTER nor VECTOR type");
        }
        if (WMSValidator.hasGeometry(lyr) && (lyr.getDefaultStyle() == null || lyr.getStyles().contains(null))) {
            throw new RuntimeException("Layer has null styles!");
        }
    }

    private static boolean hasGeometry(LayerInfo lyr) {
        if (lyr.getResource() instanceof CoverageInfo) {
            return true;
        }
        if (lyr.getResource() instanceof FeatureTypeInfo) {
            for (AttributeTypeInfo att : ((FeatureTypeInfo)lyr.getResource()).getAttributes()) {
                if (!Geometry.class.isAssignableFrom(att.getBinding())) continue;
                return true;
            }
        }
        return false;
    }
}

