/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import com.vividsolutions.jts.geom.Envelope;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSExtensions;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WebMapService;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.projection.ProjectionException;
import org.geotools.styling.Style;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.requests.DescribeLayerRequest;
import org.vfny.geoserver.wms.requests.GetFeatureInfoRequest;
import org.vfny.geoserver.wms.requests.GetLegendGraphicRequest;
import org.vfny.geoserver.wms.requests.GetMapRequest;
import org.vfny.geoserver.wms.requests.WMSCapabilitiesRequest;
import org.vfny.geoserver.wms.responses.DescribeLayerResponse;
import org.vfny.geoserver.wms.responses.GetFeatureInfoResponse;
import org.vfny.geoserver.wms.responses.GetLegendGraphicResponse;
import org.vfny.geoserver.wms.responses.GetMapResponse;
import org.vfny.geoserver.wms.responses.WMSCapabilitiesResponse;
import org.vfny.geoserver.wms.responses.map.kml.KMLReflector;
import org.vfny.geoserver.wms.servlets.Capabilities;
import org.vfny.geoserver.wms.servlets.DescribeLayer;
import org.vfny.geoserver.wms.servlets.GetFeatureInfo;
import org.vfny.geoserver.wms.servlets.GetLegendGraphic;

public class DefaultWebMapService
implements WebMapService,
ApplicationContextAware {
    public static String FORMAT = "image/png";
    public static List STYLES = Collections.EMPTY_LIST;
    public static int MAX_SIDE = 512;
    public static int MIN_OL_HEIGHT = 330;
    public static String SRS = "EPSG:4326";
    public static Boolean TRANSPARENT = Boolean.TRUE;
    public static ReferencedEnvelope BBOX = new ReferencedEnvelope(new Envelope(-180.0, 180.0, -90.0, 90.0), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
    WMS wms;
    ApplicationContext context;
    private static Boolean OPTIMIZE_LINE_WIDTH = null;
    private static Boolean USE_STREAMING_RENDERER = null;
    public static Integer MAX_FILTER_RULES = null;

    public DefaultWebMapService(WMS wms) {
        this.wms = wms;
    }

    @Override
    public WMSInfo getServiceInfo() {
        return this.wms.getServiceInfo();
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        String enabled;
        this.context = context;
        if (OPTIMIZE_LINE_WIDTH == null) {
            enabled = GeoServerExtensions.getProperty((String)"OPTIMIZE_LINE_WIDTH", (ApplicationContext)context);
            OPTIMIZE_LINE_WIDTH = enabled == null ? Boolean.valueOf(true) : Boolean.valueOf(enabled);
        }
        if (USE_STREAMING_RENDERER == null) {
            enabled = GeoServerExtensions.getProperty((String)"USE_STREAMING_RENDERER", (ApplicationContext)context);
            USE_STREAMING_RENDERER = enabled == null ? Boolean.valueOf(false) : Boolean.valueOf(enabled);
        }
        if (MAX_FILTER_RULES == null) {
            String rules = GeoServerExtensions.getProperty((String)"MAX_FILTER_RULES", (ApplicationContext)context);
            MAX_FILTER_RULES = rules == null ? Integer.valueOf(20) : Integer.valueOf(rules);
        }
    }

    public static boolean isLineWidthOptimizationEnabled() {
        return OPTIMIZE_LINE_WIDTH;
    }

    public static boolean useStreamingRenderer() {
        return USE_STREAMING_RENDERER;
    }

    public static int getMaxFilterRules() {
        return MAX_FILTER_RULES;
    }

    @Override
    public WMSCapabilitiesResponse getCapabilities(WMSCapabilitiesRequest request) {
        Capabilities capabilities = (Capabilities)((Object)this.context.getBean("wmsGetCapabilities"));
        return (WMSCapabilitiesResponse)capabilities.getResponse();
    }

    @Override
    public WMSCapabilitiesResponse capabilities(WMSCapabilitiesRequest request) {
        return this.getCapabilities(request);
    }

    @Override
    public DescribeLayerResponse describeLayer(DescribeLayerRequest request) {
        DescribeLayer describeLayer = (DescribeLayer)((Object)this.context.getBean("wmsDescribeLayer"));
        return (DescribeLayerResponse)describeLayer.getResponse();
    }

    @Override
    public GetMapResponse getMap(GetMapRequest request) {
        return new GetMapResponse(WMSExtensions.findMapProducers(this.context));
    }

    @Override
    public GetMapResponse map(GetMapRequest request) {
        return this.getMap(request);
    }

    @Override
    public GetFeatureInfoResponse getFeatureInfo(GetFeatureInfoRequest request) {
        GetFeatureInfo getFeatureInfo = (GetFeatureInfo)((Object)this.context.getBean("wmsGetFeatureInfo"));
        return (GetFeatureInfoResponse)getFeatureInfo.getResponse();
    }

    @Override
    public GetLegendGraphicResponse getLegendGraphic(GetLegendGraphicRequest request) {
        GetLegendGraphic getLegendGraphic = (GetLegendGraphic)((Object)this.context.getBean("wmsGetLegendGraphic"));
        return (GetLegendGraphicResponse)getLegendGraphic.getResponse();
    }

    public void kml(GetMapRequest getMap, HttpServletResponse response) {
        try {
            KMLReflector.doWms(getMap, response, this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public GetMapResponse reflect(GetMapRequest request) {
        return this.getMapReflect(request);
    }

    @Override
    public GetMapResponse getMapReflect(GetMapRequest request) {
        GetMapRequest getMap = request;
        if (getMap.getFormat() == null) {
            getMap.setFormat(FORMAT);
        }
        if (getMap.getStyles() == null || getMap.getStyles().isEmpty()) {
            if (getMap.getLayers() != null && getMap.getLayers().length > 0) {
                ArrayList<Style> styles = new ArrayList<Style>(getMap.getLayers().length);
                for (int i = 0; i < getMap.getLayers().length; ++i) {
                    styles.add(getMap.getLayers()[i].getDefaultStyle());
                }
                getMap.setStyles(styles);
            } else {
                getMap.setStyles(STYLES);
            }
        }
        DefaultWebMapService.autoSetBoundsAndSize(getMap);
        return this.getMap(getMap);
    }

    public static void autoSetBoundsAndSize(GetMapRequest getMap) {
        CoordinateReferenceSystem reqCRS;
        MapLayerInfo[] layers = getMap.getLayers();
        String reqSRS = getMap.getSRS();
        boolean useNativeBounds = true;
        if (reqSRS == null) {
            reqSRS = DefaultWebMapService.guessCommonSRS(layers);
            DefaultWebMapService.forceSRS(getMap, reqSRS);
        }
        for (int i = 0; useNativeBounds && i < layers.length; ++i) {
            if (layers[i] != null) {
                String layerSRS = layers[i].getSRS();
                useNativeBounds = reqSRS.equalsIgnoreCase(layerSRS);
                continue;
            }
            useNativeBounds = false;
        }
        try {
            reqCRS = CRS.decode((String)reqSRS);
        }
        catch (Exception e) {
            throw new WmsException(e);
        }
        Envelope aggregateBbox = getMap.getBbox();
        boolean specifiedBbox = true;
        if (aggregateBbox == null) {
            specifiedBbox = false;
            for (int i = 0; i < layers.length; ++i) {
                ReferencedEnvelope curbbox;
                block35: {
                    MapLayerInfo layerInfo = layers[i];
                    try {
                        curbbox = layerInfo.getLatLongBoundingBox();
                        if (!useNativeBounds) break block35;
                        ReferencedEnvelope nativeBbox = layerInfo.getBoundingBox();
                        if (nativeBbox == null) {
                            try {
                                CoordinateReferenceSystem nativeCrs = layerInfo.getCoordinateReferenceSystem();
                                nativeBbox = curbbox.transform(nativeCrs, true);
                            }
                            catch (Exception e) {
                                throw new WmsException("Best effort native bbox computation failed", "", e);
                            }
                        }
                        curbbox = nativeBbox;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                if (aggregateBbox != null) {
                    aggregateBbox.expandToInclude((Envelope)curbbox);
                    continue;
                }
                aggregateBbox = curbbox;
            }
            ReferencedEnvelope ref = null;
            if (!useNativeBounds && !reqSRS.equalsIgnoreCase(SRS)) {
                try {
                    ref = new ReferencedEnvelope(aggregateBbox, CRS.decode((String)"EPSG:4326"));
                    aggregateBbox = ref.transform(reqCRS, true);
                }
                catch (ProjectionException pe) {
                    ref.expandBy(-1.0 * ref.getWidth() / 50.0, -1.0 * ref.getHeight() / 50.0);
                    try {
                        aggregateBbox = ref.transform(reqCRS, true);
                    }
                    catch (FactoryException e) {
                        e.printStackTrace();
                    }
                    catch (TransformException e) {
                        e.printStackTrace();
                    }
                }
                catch (NoSuchAuthorityCodeException e) {
                    e.printStackTrace();
                }
                catch (TransformException e) {
                    e.printStackTrace();
                }
                catch (FactoryException e) {
                    e.printStackTrace();
                }
            }
        }
        if (aggregateBbox == null) {
            DefaultWebMapService.forceSRS(getMap, SRS);
            aggregateBbox = BBOX;
        }
        double bbheight = aggregateBbox.getHeight();
        double bbwidth = aggregateBbox.getWidth();
        double bbratio = bbwidth / bbheight;
        double mheight = getMap.getHeight();
        double mwidth = getMap.getWidth();
        if (!(mheight > 0.5 && mwidth > 0.5 && specifiedBbox)) {
            if (mheight > 0.5 && mwidth > 0.5) {
                double mratio = mwidth / mheight;
                if (bbratio > mratio) {
                    double diff = (bbwidth / mratio - bbheight) / 2.0;
                    aggregateBbox.expandBy(0.0, diff);
                } else {
                    double diff = (bbheight * mratio - bbwidth) / 2.0;
                    aggregateBbox.expandBy(diff, 0.0);
                }
                DefaultWebMapService.adjustBounds(reqSRS, aggregateBbox);
            } else if (mheight > 0.5) {
                mwidth = bbratio * mheight;
            } else if (mwidth > 0.5) {
                mheight = mwidth / bbratio >= 1.0 ? mwidth / bbratio : 1.0;
            } else {
                if (bbratio > 1.0) {
                    mwidth = MAX_SIDE;
                    mheight = mwidth / bbratio >= 1.0 ? mwidth / bbratio : 1.0;
                } else {
                    mheight = MAX_SIDE;
                    double d = mwidth = mheight * bbratio >= 1.0 ? mheight * bbratio : 1.0;
                }
                if (mheight < (double)MIN_OL_HEIGHT && ("application/openlayers".equalsIgnoreCase(getMap.getFormat()) || "openlayers".equalsIgnoreCase(getMap.getFormat()))) {
                    mheight = MIN_OL_HEIGHT;
                    mwidth = mheight * bbratio >= 1.0 ? mheight * bbratio : 1.0;
                }
            }
            getMap.setBbox(aggregateBbox);
            getMap.setWidth((int)mwidth);
            getMap.setHeight((int)mheight);
        }
    }

    private static String guessCommonSRS(MapLayerInfo[] layers) {
        String SRS = null;
        for (MapLayerInfo layer : layers) {
            String layerSRS = layer.getSRS();
            if (SRS == null) {
                SRS = layerSRS.toUpperCase();
                continue;
            }
            if (SRS.equals(layerSRS)) continue;
            return DefaultWebMapService.SRS;
        }
        if (SRS == null) {
            return DefaultWebMapService.SRS;
        }
        return SRS;
    }

    private static void forceSRS(GetMapRequest getMap, String srs) {
        getMap.setSRS(srs);
        try {
            getMap.setCrs(CRS.decode((String)srs));
        }
        catch (NoSuchAuthorityCodeException e) {
            e.printStackTrace();
        }
        catch (FactoryException e) {
            e.printStackTrace();
        }
    }

    private static Envelope adjustBounds(String reqSRS, Envelope bbox) {
        if (reqSRS.equalsIgnoreCase("EPSG:4326")) {
            bbox.expandBy(bbox.getWidth() / 100.0, bbox.getHeight() / 100.0);
            Envelope maxEnv = new Envelope(-180.0, -90.0, 180.0, 90.0);
            return bbox.intersection(maxEnv);
        }
        if (reqSRS.equalsIgnoreCase("EPSG:900913")) {
            bbox.expandBy(bbox.getWidth() / 100.0, bbox.getHeight() / 100.0);
            Envelope maxEnv = new Envelope(-2.003750833E7, -2.003750833E7, 2.003750833E7, 2.003750833E7);
            return bbox.intersection(maxEnv);
        }
        return bbox;
    }
}

