/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.featureInfo;

import java.io.IOException;
import org.opengis.feature.simple.SimpleFeature;
import org.vfny.geoserver.wms.responses.featureInfo.FeatureTemplate;

public class FeatureTimeTemplate {
    FeatureTemplate delegate;

    public FeatureTimeTemplate() {
        this(new FeatureTemplate());
    }

    public FeatureTimeTemplate(FeatureTemplate delegate) {
        this.delegate = delegate;
    }

    public String[] execute(SimpleFeature feature) throws IOException {
        String output = this.delegate.template(feature, "time.ftl", this.getClass());
        if (output != null) {
            output = output.trim();
        }
        if (output == null || "".equals(output)) {
            return new String[0];
        }
        String[] timespan = output.split("\\|\\|");
        if (output.endsWith("||")) {
            timespan = new String[]{timespan[0], null};
        }
        if (timespan.length > 2) {
            String msg = "Incorrect time syntax. Should be: <date>||<date>";
            throw new IllegalArgumentException(msg);
        }
        if (timespan.length == 1) {
            return timespan;
        }
        if (timespan[0] == null || "".equals(timespan[0].trim())) {
            timespan[0] = null;
        }
        if (timespan[1] == null || "".equals(timespan[1].trim())) {
            timespan[1] = null;
        }
        return timespan;
    }
}

