/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.demo;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Serializable;
import java.util.HashMap;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureStore;
import org.geotools.data.Transaction;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureCollections;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.swing.data.JFileDataStoreChooser;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class Csv2Shape {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        File file = JFileDataStoreChooser.showOpenFile((String)"csv", null);
        if (file == null) {
            return;
        }
        SimpleFeatureType TYPE = DataUtilities.createType((String)"Location", (String)"location:Point:srid=4326,name:String");
        FeatureCollection collection = FeatureCollections.newCollection();
        GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory(null);
        SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(TYPE);
        BufferedReader reader = new BufferedReader(new FileReader(file));
        try {
            String line = reader.readLine();
            System.out.println("Header: " + line);
            line = reader.readLine();
            while (line != null) {
                String[] tokens = line.split("\\,");
                double longitude = Double.parseDouble(tokens[0]);
                double latitude = Double.parseDouble(tokens[1]);
                String name = tokens[2].trim();
                Point point = geometryFactory.createPoint(new Coordinate(longitude, latitude));
                featureBuilder.add((Object)point);
                featureBuilder.add((Object)name);
                SimpleFeature feature = featureBuilder.buildFeature(null);
                collection.add((Feature)feature);
                line = reader.readLine();
            }
        }
        finally {
            reader.close();
        }
        File newFile = Csv2Shape.getNewShapeFile(file);
        ShapefileDataStoreFactory dataStoreFactory = new ShapefileDataStoreFactory();
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        params.put("url", newFile.toURI().toURL());
        params.put("create spatial index", Boolean.TRUE);
        ShapefileDataStore newDataStore = (ShapefileDataStore)dataStoreFactory.createNewDataStore(params);
        newDataStore.createSchema(TYPE);
        newDataStore.forceSchemaCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        DefaultTransaction transaction = new DefaultTransaction("create");
        String typeName = newDataStore.getTypeNames()[0];
        FeatureStore featureStore = (FeatureStore)newDataStore.getFeatureSource(typeName);
        featureStore.setTransaction((Transaction)transaction);
        try {
            featureStore.addFeatures(collection);
            transaction.commit();
        }
        catch (Exception problem) {
            problem.printStackTrace();
            transaction.rollback();
        }
        finally {
            transaction.close();
        }
        System.exit(0);
    }

    private static File getNewShapeFile(File csvFile) {
        File newFile;
        String path = csvFile.getAbsolutePath();
        String newPath = path.substring(0, path.length() - 4) + ".shp";
        JFileDataStoreChooser chooser = new JFileDataStoreChooser("shp");
        chooser.setDialogTitle("Save shapefile");
        chooser.setSelectedFile(new File(newPath));
        int returnVal = chooser.showSaveDialog(null);
        if (returnVal != 0) {
            System.exit(0);
        }
        if ((newFile = chooser.getSelectedFile()).equals(csvFile)) {
            System.out.println("Error: cannot replace " + csvFile);
            System.exit(0);
        }
        return newFile;
    }

    private static SimpleFeatureType createFeatureType() {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("Location");
        builder.setCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        builder.add("Location", Point.class);
        builder.length(15).add("Name", String.class);
        SimpleFeatureType LOCATION = builder.buildFeatureType();
        return LOCATION;
    }
}

