/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.demo;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import javax.measure.unit.Unit;
import javax.swing.JButton;
import javax.swing.JToolBar;
import org.geotools.data.FeatureSource;
import org.geotools.data.FileDataStore;
import org.geotools.data.FileDataStoreFinder;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.map.DefaultMapContext;
import org.geotools.map.MapContext;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Graphic;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Mark;
import org.geotools.styling.Rule;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.swing.JMapFrame;
import org.geotools.swing.data.JFileDataStoreChooser;
import org.geotools.swing.event.MapMouseEvent;
import org.geotools.swing.tool.CursorTool;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.identity.FeatureId;
import org.opengis.filter.spatial.Contains;
import org.opengis.style.Fill;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapDisplayLab {
    private StyleFactory sf = CommonFactoryFinder.getStyleFactory(null);
    private FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
    private GeometryFactory geomFactory = JTSFactoryFinder.getGeometryFactory(null);
    private static final Color LINE_COLOUR = Color.BLUE;
    private static final Color FILL_COLOUR = Color.CYAN;
    private static final Color SELECTED_COLOUR = Color.YELLOW;
    private static final float OPACITY = 1.0f;
    private static final float LINE_WIDTH = 1.0f;
    private static final float POINT_SIZE = 10.0f;
    private JMapFrame mapFrame;
    private FeatureSource<SimpleFeatureType, SimpleFeature> featureSource;
    private String geometryAttributeName;
    private GeomType geometryType;
    private String distanceUnitName;

    public static void main(String[] args) throws Exception {
        MapDisplayLab me = new MapDisplayLab();
        File file = JFileDataStoreChooser.showOpenFile((String)"shp", null);
        if (file == null) {
            return;
        }
        me.displayShapefile(file);
    }

    public void displayShapefile(File file) throws Exception {
        FileDataStore store = FileDataStoreFinder.getDataStore((File)file);
        this.featureSource = store.getFeatureSource();
        this.setGeometry();
        DefaultMapContext map = new DefaultMapContext();
        map.setTitle("Feature selection tool example");
        Style style = this.createDefaultStyle();
        map.addLayer(this.featureSource, style);
        this.mapFrame = new JMapFrame((MapContext)map);
        this.mapFrame.enableToolBar(true);
        JToolBar toolBar = this.mapFrame.getToolBar();
        JButton btn = new JButton("Select");
        toolBar.addSeparator();
        toolBar.add(btn);
        btn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MapDisplayLab.this.mapFrame.getMapPane().setCursorTool(new CursorTool(){

                    public void onMouseClicked(MapMouseEvent ev) {
                        MapDisplayLab.this.selectFeatures(ev.getMapPosition());
                    }
                });
            }
        });
        this.mapFrame.setSize(600, 600);
        this.mapFrame.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void selectFeatures(DirectPosition2D pos) {
        Contains filter = null;
        Object filterString = null;
        Point point = this.geomFactory.createPoint(new Coordinate(pos.x, pos.y));
        if (this.geometryType == GeomType.POLYGON) {
            filter = this.ff.contains((Expression)this.ff.property(this.geometryAttributeName), (Expression)this.ff.literal((Object)point));
        } else {
            double distance = this.mapFrame.getMapPane().getDisplayArea().getWidth() / 100.0;
            filter = this.ff.dwithin((Expression)this.ff.property(this.geometryAttributeName), (Expression)this.ff.literal((Object)point), distance, this.distanceUnitName);
        }
        try {
            FeatureCollection selectedFeatures = this.featureSource.getFeatures((Filter)filter);
            FeatureIterator iter = selectedFeatures.features();
            HashSet<FeatureId> IDs = new HashSet<FeatureId>();
            try {
                while (iter.hasNext()) {
                    SimpleFeature feature = (SimpleFeature)iter.next();
                    IDs.add(feature.getIdentifier());
                    System.out.println("   " + feature.getIdentifier());
                }
            }
            finally {
                iter.close();
            }
            if (IDs.isEmpty()) {
                System.out.println("   no feature selected");
            }
            this.displaySelectedFeatures(IDs);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
    }

    public void displaySelectedFeatures(Set<FeatureId> IDs) {
        Style style = IDs.isEmpty() ? this.createDefaultStyle() : this.createSelectedStyle(IDs);
        this.mapFrame.getMapContext().getLayer(0).setStyle(style);
        this.mapFrame.getMapPane().repaint();
    }

    private Style createDefaultStyle() {
        Rule rule = this.createRule(LINE_COLOUR, FILL_COLOUR);
        FeatureTypeStyle fts = this.sf.createFeatureTypeStyle();
        fts.rules().add(rule);
        Style style = this.sf.createStyle();
        style.featureTypeStyles().add(fts);
        return style;
    }

    private Style createSelectedStyle(Set<FeatureId> IDs) {
        Rule selectedRule = this.createRule(SELECTED_COLOUR, SELECTED_COLOUR);
        selectedRule.setFilter((Filter)this.ff.id(IDs));
        Rule otherRule = this.createRule(LINE_COLOUR, FILL_COLOUR);
        otherRule.setElseFilter(true);
        FeatureTypeStyle fts = this.sf.createFeatureTypeStyle();
        fts.rules().add(selectedRule);
        fts.rules().add(otherRule);
        Style style = this.sf.createStyle();
        style.featureTypeStyles().add(fts);
        return style;
    }

    private Rule createRule(Color outlineColor, Color fillColor) {
        LineSymbolizer symbolizer = null;
        org.geotools.styling.Fill fill = null;
        Stroke stroke = this.sf.createStroke((Expression)this.ff.literal((Object)outlineColor), (Expression)this.ff.literal(1.0f));
        switch (this.geometryType) {
            case POLYGON: {
                fill = this.sf.createFill((Expression)this.ff.literal((Object)fillColor), (Expression)this.ff.literal(1.0f));
                symbolizer = this.sf.createPolygonSymbolizer(stroke, fill, this.geometryAttributeName);
                break;
            }
            case LINE: {
                symbolizer = this.sf.createLineSymbolizer(stroke, this.geometryAttributeName);
                break;
            }
            case POINT: {
                fill = this.sf.createFill((Expression)this.ff.literal((Object)fillColor), (Expression)this.ff.literal(1.0f));
                Mark mark = this.sf.getCircleMark();
                mark.setFill((Fill)fill);
                mark.setStroke((org.opengis.style.Stroke)stroke);
                Graphic graphic = this.sf.createDefaultGraphic();
                graphic.graphicalSymbols().clear();
                graphic.graphicalSymbols().add(mark);
                graphic.setSize((Expression)this.ff.literal(10.0f));
                symbolizer = this.sf.createPointSymbolizer(graphic, this.geometryAttributeName);
            }
        }
        Rule rule = this.sf.createRule();
        rule.symbolizers().add(symbolizer);
        return rule;
    }

    private void setGeometry() {
        GeometryDescriptor geomDesc = ((SimpleFeatureType)this.featureSource.getSchema()).getGeometryDescriptor();
        this.geometryAttributeName = geomDesc.getLocalName();
        Class clazz = geomDesc.getType().getBinding();
        this.geometryType = Polygon.class.isAssignableFrom(clazz) || MultiPolygon.class.isAssignableFrom(clazz) ? GeomType.POLYGON : (LineString.class.isAssignableFrom(clazz) || MultiLineString.class.isAssignableFrom(clazz) ? GeomType.LINE : GeomType.POINT);
        Unit unit = geomDesc.getCoordinateReferenceSystem().getCoordinateSystem().getAxis(0).getUnit();
        this.distanceUnitName = unit.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum GeomType {
        POINT,
        LINE,
        POLYGON;

    }
}

