/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.demo;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Map;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.postgis.PostgisDataStoreFactory;
import org.geotools.feature.FeatureCollection;
import org.geotools.filter.FilterTransformer;
import org.geotools.filter.text.cql2.CQL;
import org.geotools.swing.data.JDataStoreWizard;
import org.geotools.swing.data.TypeNameChooser;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;

public class PostGISLab {
    public static void main(String[] args) throws Exception {
        Map connectionParameters;
        DataStore dataStore;
        JDataStoreWizard wizard = new JDataStoreWizard((DataStoreFactorySpi)new PostgisDataStoreFactory());
        int result = wizard.showModalDialog();
        if (result != 0) {
            System.exit(0);
        }
        if ((dataStore = DataStoreFinder.getDataStore((Map)(connectionParameters = wizard.getConnectionParameters()))) == null) {
            JOptionPane.showMessageDialog(null, "Could not conntect");
            System.exit(0);
        }
        String typeName = TypeNameChooser.showTypeNameChooser((DataStore)dataStore);
        JQuery dialog = new JQuery(dataStore);
        dialog.setVisible(true);
        dialog.dispose();
        System.exit(0);
    }

    static class JQuery
    extends JDialog {
        final DataStore dataStore;
        JTextArea query;
        JTextArea show;
        JButton selectButton;
        JButton closeButton;
        JComboBox typeNameSelect;
        JButton schemaButton;
        private JButton filterButton;

        JQuery(DataStore database) throws IOException {
            this.dataStore = database;
            this.setTitle("Query");
            this.setModal(true);
            this.setDefaultCloseOperation(1);
            JPanel panel = new JPanel();
            panel.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 0;
            c.anchor = 17;
            c.insets = new Insets(2, 2, 2, 2);
            c.weightx = 1.0;
            Vector<String> options = new Vector<String>();
            String[] typeNames = this.dataStore.getTypeNames();
            for (int i = 0; i < typeNames.length; ++i) {
                String typeName = typeNames[i];
                options.add(typeName);
            }
            this.typeNameSelect = new JComboBox(options);
            panel.add((Component)this.typeNameSelect, c);
            this.schemaButton = new JButton("Describe Schema");
            this.schemaButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JQuery.this.displaySchema();
                }
            });
            c.gridwidth = 0;
            panel.add((Component)this.schemaButton, c);
            c.weightx = 0.0;
            c.weighty = 0.0;
            this.query = new JTextArea(4, 80);
            c.fill = 1;
            JScrollPane scrollPane1 = new JScrollPane(this.query);
            scrollPane1.setPreferredSize(this.query.getPreferredScrollableViewportSize());
            scrollPane1.setMinimumSize(this.query.getPreferredScrollableViewportSize());
            panel.add((Component)scrollPane1, c);
            c.fill = 0;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.gridwidth = -1;
            this.selectButton = new JButton("Select Features");
            this.selectButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JQuery.this.selectFeatures();
                }
            });
            panel.add((Component)this.selectButton, c);
            c.gridwidth = 0;
            this.filterButton = new JButton("CQL to Filter 1.0");
            this.filterButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JQuery.this.cqlToFilter();
                }
            });
            panel.add((Component)this.filterButton, c);
            c.fill = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            this.show = new JTextArea(24, 80);
            this.show.setTabSize(2);
            JScrollPane scrollPane2 = new JScrollPane(this.show);
            scrollPane2.setVerticalScrollBarPolicy(22);
            scrollPane2.setPreferredSize(this.show.getPreferredScrollableViewportSize());
            panel.add((Component)scrollPane2, c);
            this.add(panel);
            c.weighty = 0.0;
            c.weightx = 0.0;
            c.fill = 0;
            c.anchor = 10;
            c.gridheight = 0;
            c.gridwidth = 0;
            this.closeButton = new JButton("Close");
            this.closeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JQuery.this.setVisible(false);
                }
            });
            panel.add((Component)this.closeButton, c);
            this.setSize(panel.getSize());
            this.pack();
        }

        private void displaySchema() {
            try {
                String typeName = (String)this.typeNameSelect.getSelectedItem();
                SimpleFeatureType schema = this.dataStore.getSchema(typeName);
                this.display(schema);
            }
            catch (Throwable t) {
                this.display(t);
            }
        }

        protected void display(Filter filter) throws Exception {
            FilterTransformer transform = new FilterTransformer();
            transform.setIndentation(2);
            String xml = transform.transform(filter);
            this.show.setText(xml);
        }

        public void display(SimpleFeatureType schema) {
            if (schema == null) {
                this.show.setText("null");
                return;
            }
            this.show.setText(schema.toString());
        }

        public FeatureCollection filter(String text) throws Exception {
            Filter filter = CQL.toFilter((String)text);
            String typeName = (String)this.typeNameSelect.getSelectedItem();
            DefaultQuery query = new DefaultQuery();
            query.setTypeName(typeName);
            query.setFilter(filter);
            query.setMaxFeatures(1000);
            FeatureSource table = this.dataStore.getFeatureSource(typeName);
            return table.getFeatures((Query)query);
        }

        protected void display(FeatureCollection features) throws Exception {
            if (features == null) {
                this.show.setText("empty");
                return;
            }
            FeatureType schema = features.getSchema();
            final StringBuffer buf = new StringBuffer();
            buf.append(DataUtilities.spec((FeatureType)schema));
            buf.append("\n");
            features.accepts(new FeatureVisitor(){

                public void visit(Feature feature) {
                    buf.append(feature.getIdentifier());
                    buf.append("=");
                    for (Property property : feature.getProperties()) {
                        buf.append("\t");
                        buf.append(property.getName());
                        buf.append("=");
                        buf.append(property.getValue());
                    }
                    buf.append("]");
                }
            }, null);
            this.show.setText(buf.toString());
        }

        public void display(Throwable t) {
            this.show.setText(t.getLocalizedMessage());
            this.show.setForeground(Color.RED);
        }

        private void selectFeatures() {
            try {
                String text = this.query.getText();
                FeatureCollection features = this.filter(text);
                this.display(features);
            }
            catch (Throwable t) {
                this.display(t);
            }
        }

        private void cqlToFilter() {
            try {
                String text = this.query.getText();
                Filter filter = CQL.toFilter((String)text);
                this.display(filter);
            }
            catch (Throwable t) {
                this.display(t);
            }
        }
    }
}

