/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.demo;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.postgis.PostgisDataStoreFactory;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.filter.text.cql2.CQL;
import org.geotools.swing.action.SafeAction;
import org.geotools.swing.data.JDataStoreWizard;
import org.geotools.swing.table.FeatureCollectionTableModel;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;

public class QueryLab
extends JFrame {
    DataStore datastore;
    JComboBox types;
    JTable table;
    JTextField text;

    public QueryLab(DataStore data) {
        this.datastore = data;
        this.setDefaultCloseOperation(3);
        this.getContentPane().setLayout(new BorderLayout());
        try {
            this.types = new JComboBox<String>(this.datastore.getTypeNames());
        }
        catch (IOException e1) {
            JOptionPane.showMessageDialog(null, "Unable to find any published content");
            System.exit(0);
        }
        this.text = new JTextField(80);
        this.text.setText("include");
        this.getContentPane().add((Component)this.text, "North");
        this.table = new JTable();
        this.table.setAutoResizeMode(0);
        this.table.setModel(new DefaultTableModel(5, 5));
        this.table.setPreferredScrollableViewportSize(new Dimension(500, 200));
        JScrollPane scrollPane = new JScrollPane(this.table);
        this.getContentPane().add((Component)scrollPane, "Center");
        JMenuBar menubar = new JMenuBar();
        this.setJMenuBar(menubar);
        menubar.add(this.types);
        JMenu menu = new JMenu("Data");
        menubar.add(menu);
        this.pack();
        menu.add((Action)new SafeAction("Get features"){

            public void action(ActionEvent e) throws Throwable {
                QueryLab.this.filterFeatures();
            }
        });
        menu.add((Action)new SafeAction("Count"){

            public void action(ActionEvent e) throws Throwable {
                QueryLab.this.countFeatures();
            }
        });
        menu.add((Action)new SafeAction("Center"){

            public void action(ActionEvent e) throws Throwable {
                QueryLab.this.centerFeatures();
            }
        });
        menu.add((Action)new SafeAction("Geometry"){

            public void action(ActionEvent e) throws Throwable {
                QueryLab.this.queryFeatures();
            }
        });
    }

    public static void main(String[] args) throws Exception {
        Map connectionParameters;
        DataStore dataStore;
        JDataStoreWizard wizard = new JDataStoreWizard((DataStoreFactorySpi)new PostgisDataStoreFactory());
        int result = wizard.showModalDialog();
        if (result != 0) {
            System.exit(0);
        }
        if ((dataStore = DataStoreFinder.getDataStore((Map)(connectionParameters = wizard.getConnectionParameters()))) == null) {
            JOptionPane.showMessageDialog(null, "Could not connect - check parameters");
            System.exit(0);
        }
        QueryLab frame = new QueryLab(dataStore);
        frame.setVisible(true);
    }

    public void filterFeatures() throws Exception {
        String typeName = (String)this.types.getSelectedItem();
        FeatureSource source = this.datastore.getFeatureSource(typeName);
        Filter filter = CQL.toFilter((String)this.text.getText());
        FeatureCollection features = source.getFeatures(filter);
        FeatureCollectionTableModel model = new FeatureCollectionTableModel(features);
        this.table.setModel((TableModel)model);
    }

    public void countFeatures() throws Exception {
        String typeName = (String)this.types.getSelectedItem();
        FeatureSource source = this.datastore.getFeatureSource(typeName);
        Filter filter = CQL.toFilter((String)this.text.getText());
        FeatureCollection features = source.getFeatures(filter);
        int count = features.size();
        JOptionPane.showMessageDialog(this.text, "Number of selected features:" + count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void centerFeatures() throws Exception {
        String typeName = (String)this.types.getSelectedItem();
        FeatureSource source = this.datastore.getFeatureSource(typeName);
        Filter filter = CQL.toFilter((String)this.text.getText());
        FeatureCollection features = source.getFeatures(filter);
        double totalX = 0.0;
        double totalY = 0.0;
        long count = 0L;
        FeatureIterator iterator = features.features();
        try {
            while (iterator.hasNext()) {
                SimpleFeature feature = (SimpleFeature)iterator.next();
                Geometry geom = (Geometry)feature.getDefaultGeometry();
                Point centroid = geom.getCentroid();
                totalX += centroid.getX();
                totalY += centroid.getY();
                ++count;
            }
        }
        finally {
            iterator.close();
        }
        double averageX = totalX / (double)count;
        double averageY = totalY / (double)count;
        Coordinate center = new Coordinate(averageX, averageY);
        JOptionPane.showMessageDialog(this.text, "Center of selected features:" + center);
    }

    public void queryFeatures() throws Exception {
        String typeName = (String)this.types.getSelectedItem();
        FeatureSource source = this.datastore.getFeatureSource(typeName);
        FeatureType schema = source.getSchema();
        String name = schema.getGeometryDescriptor().getLocalName();
        Filter filter = CQL.toFilter((String)this.text.getText());
        DefaultQuery query = new DefaultQuery(schema.getName().getLocalPart(), filter, new String[]{name});
        FeatureCollection features = source.getFeatures((Query)query);
        FeatureCollectionTableModel model = new FeatureCollectionTableModel(features);
        this.table.setModel((TableModel)model);
    }
}

