/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.demo;

import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Color;
import java.io.File;
import org.geotools.data.FeatureSource;
import org.geotools.data.FileDataStore;
import org.geotools.data.FileDataStoreFinder;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.map.DefaultMapContext;
import org.geotools.map.MapContext;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Graphic;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Mark;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.SLDParser;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.swing.ExceptionMonitor;
import org.geotools.swing.JMapFrame;
import org.geotools.swing.data.JFileDataStoreChooser;
import org.geotools.swing.styling.JSimpleStyleDialog;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.style.Fill;

public class StyleLab {
    static StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory(null);
    static FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory(null);

    public static void main(String[] args) throws Exception {
        StyleLab me = new StyleLab();
        me.displayShapefile();
    }

    private void displayShapefile() throws Exception {
        File file = JFileDataStoreChooser.showOpenFile((String)"shp", null);
        if (file == null) {
            return;
        }
        FileDataStore store = FileDataStoreFinder.getDataStore((File)file);
        FeatureSource featureSource = store.getFeatureSource();
        DefaultMapContext map = new DefaultMapContext();
        map.setTitle("StyleLab");
        Style style = this.createStyle(file, featureSource);
        map.addLayer(featureSource, style);
        JMapFrame.showMap((MapContext)map);
    }

    private Style createStyle(File file, FeatureSource featureSource) {
        File sld = this.toSLDFile(file);
        if (sld.exists()) {
            return this.createFromSLD(sld);
        }
        SimpleFeatureType schema = (SimpleFeatureType)featureSource.getSchema();
        return JSimpleStyleDialog.showDialog(null, (SimpleFeatureType)schema);
    }

    public File toSLDFile(File file) {
        String filename = file.getAbsolutePath();
        if (filename.endsWith(".shp") || filename.endsWith(".dbf") || filename.endsWith(".shx")) {
            filename = filename.substring(0, filename.length() - 4);
            filename = filename + ".sld";
        } else if (filename.endsWith(".SLD") || filename.endsWith(".SLD") || filename.endsWith(".SLD")) {
            filename = filename.substring(0, filename.length() - 4);
            filename = filename + ".SLD";
        }
        return new File(filename);
    }

    private Style createFromSLD(File sld) {
        try {
            SLDParser stylereader = new SLDParser(styleFactory, sld.toURI().toURL());
            Style[] style = stylereader.readXML();
            return style[0];
        }
        catch (Exception e) {
            ExceptionMonitor.show(null, (Throwable)e, (String)"Problem creating style");
            return null;
        }
    }

    private Style createStyle2(FeatureSource featureSource) {
        SimpleFeatureType schema = (SimpleFeatureType)featureSource.getSchema();
        Class geomType = schema.getGeometryDescriptor().getType().getBinding();
        if (Polygon.class.isAssignableFrom(geomType) || MultiPolygon.class.isAssignableFrom(geomType)) {
            return this.createPolygonStyle();
        }
        if (LineString.class.isAssignableFrom(geomType) || MultiLineString.class.isAssignableFrom(geomType)) {
            return this.createLineStyle();
        }
        return this.createPointStyle();
    }

    private Style createPolygonStyle() {
        Stroke stroke = styleFactory.createStroke((Expression)filterFactory.literal((Object)Color.BLUE), (Expression)filterFactory.literal(1), (Expression)filterFactory.literal(0.5));
        org.geotools.styling.Fill fill = styleFactory.createFill((Expression)filterFactory.literal((Object)Color.CYAN), (Expression)filterFactory.literal(0.5));
        PolygonSymbolizer sym = styleFactory.createPolygonSymbolizer(stroke, fill, null);
        Rule rule = styleFactory.createRule();
        rule.symbolizers().add(sym);
        FeatureTypeStyle fts = styleFactory.createFeatureTypeStyle(new Rule[]{rule});
        Style style = styleFactory.createStyle();
        style.featureTypeStyles().add(fts);
        return style;
    }

    private Style createLineStyle() {
        Stroke stroke = styleFactory.createStroke((Expression)filterFactory.literal((Object)Color.BLUE), (Expression)filterFactory.literal(1));
        LineSymbolizer sym = styleFactory.createLineSymbolizer(stroke, null);
        Rule rule = styleFactory.createRule();
        rule.symbolizers().add(sym);
        FeatureTypeStyle fts = styleFactory.createFeatureTypeStyle(new Rule[]{rule});
        Style style = styleFactory.createStyle();
        style.featureTypeStyles().add(fts);
        return style;
    }

    private Style createPointStyle() {
        Graphic gr = styleFactory.createDefaultGraphic();
        Mark mark = styleFactory.getCircleMark();
        mark.setStroke((org.opengis.style.Stroke)styleFactory.createStroke((Expression)filterFactory.literal((Object)Color.BLUE), (Expression)filterFactory.literal(1)));
        mark.setFill((Fill)styleFactory.createFill((Expression)filterFactory.literal((Object)Color.CYAN)));
        mark.setSize((Expression)filterFactory.literal(3));
        gr.graphicalSymbols().clear();
        gr.graphicalSymbols().add(mark);
        PointSymbolizer sym = styleFactory.createPointSymbolizer(gr, null);
        Rule rule = styleFactory.createRule();
        rule.symbolizers().add(sym);
        FeatureTypeStyle fts = styleFactory.createFeatureTypeStyle(new Rule[]{rule});
        Style style = styleFactory.createStyle();
        style.featureTypeStyles().add(fts);
        return style;
    }
}

