/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.demo.main;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import junit.framework.TestCase;
import org.geotools.data.DataUtilities;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureCollections;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.visitor.BoundsVisitor;
import org.geotools.filter.function.Classifier;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.NullProgressListener;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.ProgressListener;

public class FeatureCollectionExampleTest
extends TestCase {
    private FeatureCollection<SimpleFeatureType, SimpleFeature> features;
    private SimpleFeature feature1;

    protected void setUp() throws Exception {
        super.setUp();
        GeometryFactory geomFactory = new GeometryFactory();
        SimpleFeatureType type = DataUtilities.createType((String)"location", (String)"the_geom:Point:srid=4326,name:String,age:Integer");
        ArrayList<SimpleFeature> list = new ArrayList<SimpleFeature>();
        Point point1 = geomFactory.createPoint(new Coordinate(40.0, 50.0));
        this.feature1 = SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{point1, "name1", 17}, null);
        list.add(this.feature1);
        Point point2 = geomFactory.createPoint(new Coordinate(30.0, 45.0));
        list.add(SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{point2, "name2", 24}, null));
        Point point3 = geomFactory.createPoint(new Coordinate(35.0, 46.0));
        list.add(SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{point3, "name3", 24}, null));
        this.features = DataUtilities.collection(list);
    }

    public void testNewDefaultFeatureCollection() {
        DefaultFeatureCollection collection = new DefaultFeatureCollection("internal", null);
    }

    public void testFeatureCollectionsNewCollection() {
        FeatureCollection collection = FeatureCollections.newCollection((String)"internal");
    }

    public void testAddingContentToYourFeatureCollection() throws Exception {
        GeometryFactory geomFactory = new GeometryFactory();
        Point point1 = geomFactory.createPoint(new Coordinate(40.0, 50.0));
        Point point2 = geomFactory.createPoint(new Coordinate(30.0, 45.0));
        FeatureCollection collection = FeatureCollections.newCollection((String)"internal");
        SimpleFeatureType type = DataUtilities.createType((String)"location", (String)"geom:Point,name:String");
        SimpleFeature feature1 = SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{point1, "name1"}, null);
        SimpleFeature feature2 = SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{point2, "name2"}, null);
        collection.add((Feature)feature1);
        collection.add((Feature)feature2);
    }

    public void testSum() {
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
        Function sum = ff.function("Collection_Sum", new Expression[]{ff.property("age")});
        Object value = sum.evaluate(this.features);
        FeatureCollectionExampleTest.assertEquals((Object)65, (Object)value);
    }

    public void testClassifier() {
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
        Function classify = ff.function("Quantile", new Expression[]{ff.property("name"), ff.literal(2)});
        Classifier groups = (Classifier)classify.evaluate(this.features);
        groups.setTitle(0, "Group A");
        groups.setTitle(1, "Group B");
        FeatureCollectionExampleTest.assertNotNull((Object)groups.toString());
        Function sort = ff.function("classify", new Expression[]{ff.property("name"), ff.literal((Object)groups)});
        int slot = (Integer)sort.evaluate((Object)this.feature1);
        FeatureCollectionExampleTest.assertEquals((int)0, (int)slot);
        FeatureCollectionExampleTest.assertEquals((String)"Group A", (String)groups.getTitle(slot));
    }

    public void testFeatureVisitor() {
        SimpleFeatureType schema = (SimpleFeatureType)this.features.getSchema();
        CoordinateReferenceSystem crs = schema.getCoordinateReferenceSystem();
        BoundsVisitor visitor = new BoundsVisitor();
        FeatureCollectionExampleTest.assertNull((Object)visitor.getBounds().getCoordinateReferenceSystem());
        try {
            this.features.accepts((FeatureVisitor)visitor, (ProgressListener)new NullProgressListener());
        }
        catch (IOException e) {
            FeatureCollectionExampleTest.fail((String)e.getLocalizedMessage());
        }
        FeatureCollectionExampleTest.assertFalse((boolean)visitor.getBounds().isEmpty());
        FeatureCollectionExampleTest.assertEquals((Object)crs, (Object)visitor.getBounds().getCoordinateReferenceSystem());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIterator() {
        CoordinateReferenceSystem crs = ((SimpleFeatureType)this.features.getSchema()).getCoordinateReferenceSystem();
        ReferencedEnvelope bounds = new ReferencedEnvelope(crs);
        Iterator iterator = this.features.iterator();
        try {
            while (iterator.hasNext()) {
                SimpleFeature feature = (SimpleFeature)iterator.next();
                bounds.include(feature.getBounds());
            }
        }
        finally {
            this.features.close(iterator);
        }
        FeatureCollectionExampleTest.assertFalse((boolean)bounds.isEmpty());
    }

    /*
     * Exception decompiling
     */
    public void testIteratorSafe() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFeatureIterator() {
        FeatureCollection<SimpleFeatureType, SimpleFeature> collection = this.features;
        Envelope bounds = new Envelope();
        FeatureIterator features = collection.features();
        try {
            while (features.hasNext()) {
                SimpleFeature feature = (SimpleFeature)features.next();
                bounds.expandToInclude((Envelope)new ReferencedEnvelope(feature.getBounds()));
            }
        }
        finally {
            features.close();
        }
        FeatureCollectionExampleTest.assertFalse((boolean)bounds.isNull());
    }
}

