/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.demo.referencing;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.Map;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.cs.DefaultCartesianCS;
import org.geotools.referencing.cs.DefaultCoordinateSystemAxis;
import org.geotools.referencing.datum.DefaultGeodeticDatum;
import org.geotools.referencing.operation.DefiningConversion;
import org.opengis.geometry.DirectPosition;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.TransformException;

public class TransformationConsole {
    public static void main(String[] args) throws IOException, FactoryException, TransformException {
        String line;
        String classification;
        switch (args.length) {
            case 0: {
                classification = "Mercator_1SP";
                break;
            }
            case 1: {
                classification = args[0];
                break;
            }
            default: {
                System.err.println("Expected 0 or 1 argument");
                return;
            }
        }
        CRSFactory crsFactory = ReferencingFactoryFinder.getCRSFactory(null);
        CSFactory csFactory = ReferencingFactoryFinder.getCSFactory(null);
        MathTransformFactory mtFactory = ReferencingFactoryFinder.getMathTransformFactory(null);
        DefaultCoordinateSystemAxis longAxis = DefaultCoordinateSystemAxis.GEODETIC_LONGITUDE;
        DefaultCoordinateSystemAxis latAxis = DefaultCoordinateSystemAxis.GEODETIC_LATITUDE;
        EllipsoidalCS ellipseCS = csFactory.createEllipsoidalCS(Collections.singletonMap("name", "Lat/Long"), (CoordinateSystemAxis)latAxis, (CoordinateSystemAxis)longAxis);
        DefaultGeodeticDatum datum = DefaultGeodeticDatum.WGS84;
        GeographicCRS sourceCRS = crsFactory.createGeographicCRS(Collections.singletonMap("name", "WGS 84"), (GeodeticDatum)datum, ellipseCS);
        ParameterValueGroup parameters = mtFactory.getDefaultParameters(classification);
        DefaultCartesianCS cartCS = DefaultCartesianCS.GENERIC_2D;
        Map<String, String> properties = Collections.singletonMap("name", classification);
        DefiningConversion conversion = new DefiningConversion("Mercator", parameters);
        ProjectedCRS targetCRS = crsFactory.createProjectedCRS(properties, sourceCRS, (Conversion)conversion, (CartesianCS)cartCS);
        CoordinateOperationFactory coFactory = ReferencingFactoryFinder.getCoordinateOperationFactory(null);
        CoordinateOperation co = coFactory.createOperation((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS);
        MathTransform transform = co.getMathTransform();
        System.out.print("Projection classification is ");
        System.out.println(classification);
        System.out.println("Source CRS is:");
        System.out.println("    " + sourceCRS.toWKT());
        System.out.println("Target CRS is:");
        System.out.println("    " + targetCRS.toWKT());
        System.out.println("Enter (latitude longitude) coordinates separated by a space.");
        System.out.println("Enter \"exit\" to finish.");
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        while ((line = in.readLine()) != null && !(line = line.trim()).equalsIgnoreCase("exit")) {
            int split = line.indexOf(32);
            if (split < 0) continue;
            double latitude = Double.parseDouble(line.substring(0, split));
            double longitude = Double.parseDouble(line.substring(split));
            GeneralDirectPosition point = new GeneralDirectPosition(latitude, longitude);
            point = transform.transform((DirectPosition)point, (DirectPosition)point);
            System.out.println(point);
        }
    }
}

