/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.demo.swing;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import javax.swing.JFrame;
import javax.swing.Timer;
import org.geotools.data.FeatureSource;
import org.geotools.data.FileDataStore;
import org.geotools.data.FileDataStoreFinder;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.DefaultMapContext;
import org.geotools.map.MapContext;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.swing.JMapPane;
import org.geotools.swing.data.JFileDataStoreChooser;
import org.geotools.swing.event.MapMouseAdapter;
import org.geotools.swing.event.MapMouseEvent;
import org.geotools.swing.event.MapMouseListener;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnimatedMapPane
extends JMapPane {
    private Timer timer = new Timer(this.millisDelay, null);
    private int millisDelay = 100;
    private List<DirectPosition2D> route;
    private Color lineColor;
    private Stroke lineStroke;
    private boolean drawRoute;
    private RoutePainter routePainter;

    public AnimatedMapPane(GTRenderer renderer, MapContext context) {
        super(renderer, context);
        this.timer.setInitialDelay(0);
        this.timer.setRepeats(true);
        this.routePainter = new RoutePainter();
        this.timer.addActionListener(this.routePainter);
        this.drawRoute = false;
    }

    public void setRoute(List<DirectPosition2D> route) {
        this.route = new ArrayList<DirectPosition2D>();
        this.route.addAll(route);
    }

    public void setRouteStyle(Color color, float lineWidth) {
        this.lineColor = color;
        this.lineStroke = new BasicStroke(lineWidth);
    }

    public void enableRouteDrawing(boolean b) {
        this.drawRoute = b;
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.drawRoute && this.route != null) {
            this.routePainter.setRoute(this.route);
            this.timer.start();
        }
    }

    public static void main(String[] args) throws IOException {
        File file = JFileDataStoreChooser.showOpenFile((String)"shp", null);
        if (file == null) {
            return;
        }
        FileDataStore dataStore = FileDataStoreFinder.getDataStore((File)file);
        FeatureSource featureSource = dataStore.getFeatureSource();
        DefaultMapContext map = new DefaultMapContext();
        map.addLayer(featureSource, null);
        ReferencedEnvelope bounds = featureSource.getBounds();
        final AnimatedMapPane pane = new AnimatedMapPane((GTRenderer)new StreamingRenderer(), (MapContext)map);
        pane.setRouteStyle(Color.RED, 2.0f);
        pane.enableRouteDrawing(true);
        pane.addMouseListener((MapMouseListener)new MapMouseAdapter(){

            public void onMouseClicked(MapMouseEvent ev) {
                pane.setRoute(AnimatedMapPane.randomWalk(ev.getMapPosition(), pane.getDisplayArea(), 50));
                pane.repaint();
            }
        });
        JFrame frame = new JFrame("Click to start a randome walk");
        frame.setDefaultCloseOperation(3);
        frame.add((Component)((Object)pane));
        frame.setSize(800, 600);
        frame.setVisible(true);
    }

    private static List<DirectPosition2D> randomWalk(DirectPosition2D start, ReferencedEnvelope bounds, int N) {
        double stepLength = bounds.getWidth() / 100.0;
        double maxTurn = 0.7853981633974483;
        CoordinateReferenceSystem crs = bounds.getCoordinateReferenceSystem();
        Random rand = new Random();
        ArrayList<DirectPosition2D> walk = new ArrayList<DirectPosition2D>();
        DirectPosition2D pos = new DirectPosition2D(crs, start.x, start.y);
        walk.add(pos);
        double lastx = pos.x;
        double lasty = pos.y;
        double angle = Math.PI * 2 * rand.nextDouble();
        for (int i = 1; i < N; ++i) {
            double x = stepLength * Math.sin(angle += 0.7853981633974483 * (1.0 - 2.0 * rand.nextDouble()));
            double y = stepLength * Math.cos(angle);
            walk.add(new DirectPosition2D(crs, lastx + x, lasty + y));
            lastx += x;
            lasty += y;
        }
        return walk;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class RoutePainter
    implements ActionListener {
        private Graphics2D g2 = null;
        private AffineTransform tr;
        private ListIterator<DirectPosition2D> iter;
        private Point previous;
        private Point current;
        private boolean firstPoint = true;

        RoutePainter() {
        }

        public void setRoute(List<DirectPosition2D> route) {
            this.tr = AnimatedMapPane.this.getWorldToScreenTransform();
            this.g2 = (Graphics2D)AnimatedMapPane.this.getGraphics();
            this.g2.setColor(AnimatedMapPane.this.lineColor);
            this.g2.setStroke(AnimatedMapPane.this.lineStroke);
            this.iter = route.listIterator();
            this.previous = new Point();
            this.current = new Point();
            if (this.iter.hasNext()) {
                this.tr.transform((Point2D)this.iter.next(), this.previous);
            } else {
                this.finish();
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.iter.hasNext()) {
                this.tr.transform((Point2D)this.iter.next(), this.current);
                this.g2.drawLine(this.previous.x, this.previous.y, this.current.x, this.current.y);
                this.previous.setLocation(this.current);
            } else {
                this.finish();
            }
        }

        private void finish() {
            AnimatedMapPane.this.timer.stop();
            this.g2.dispose();
        }
    }
}

