/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.demo.xml;

import java.io.IOException;
import java.io.StringReader;
import org.geotools.filter.FilterFilter;
import org.geotools.filter.FilterHandler;
import org.geotools.gml.GMLFilterDocument;
import org.geotools.gml.GMLFilterGeometry;
import org.geotools.gml.GMLHandlerGeometry;
import org.geotools.gml.GMLHandlerJTS;
import org.opengis.filter.Filter;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class SAXExample {
    static String xml = "<Filter xmlns:gml=\"http://www.opengis.net/gml\">  <Overlaps>    <PropertyName>testGeometry</PropertyName><gml:Polygon srsName=\"http://www.opengis.net/gml/srs/EPSG#4326\"><gml:outerBoundaryIs><gml:LinearRing><gml:coordinates>0,0 0,10 10,10 10,0 0,0</gml:coordinates></gml:LinearRing></gml:outerBoundaryIs></gml:Polygon>  </Overlaps></Filter>";

    public static void main(String[] args) throws Exception {
        StringReader reader = new StringReader(xml);
        InputSource input = new InputSource(reader);
        Filter filter = SAXExample.parse(input);
        System.out.println("got:" + filter);
    }

    public static Filter parse(InputSource input) throws IOException, SAXException {
        SimpleFilterHandler simpleFilterHandler = new SimpleFilterHandler();
        FilterFilter filterFilter = new FilterFilter((FilterHandler)simpleFilterHandler, null);
        GMLFilterGeometry filterGeometry = new GMLFilterGeometry((GMLHandlerJTS)filterFilter);
        GMLFilterDocument filterDocument = new GMLFilterDocument((GMLHandlerGeometry)filterGeometry);
        XMLReader reader = XMLReaderFactory.createXMLReader();
        reader.setContentHandler((ContentHandler)filterDocument);
        reader.parse(input);
        return simpleFilterHandler.getFilter();
    }

    static class SimpleFilterHandler
    extends DefaultHandler
    implements FilterHandler {
        private Filter filter;

        SimpleFilterHandler() {
        }

        public void filter(Filter filter) {
            this.filter = filter;
        }

        public Filter getFilter() {
            return this.filter;
        }
    }
}

