/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.geotools.data.complex.AttributeCreateOrderList;
import org.geotools.data.complex.TreeAttributeMapping;

public class AttributeCreateOrderListTest
extends TestCase {
    private static final String ROOT_LABEL = "root";
    private AttributeCreateOrderList at;
    private List<TreeAttributeMapping> unProcessedList;

    public void testEmptyTree() throws IOException {
        this.at = new AttributeCreateOrderList(ROOT_LABEL);
        this.unProcessedList = new ArrayList<TreeAttributeMapping>();
        this.processTestData();
    }

    public void testSimpleTree() throws IOException {
        this.at = new AttributeCreateOrderList(ROOT_LABEL);
        this.unProcessedList = new ArrayList<TreeAttributeMapping>();
        this.createAttribute(ROOT_LABEL, "child1");
        this.createAttribute(ROOT_LABEL, "child2");
        this.createAttribute("child1", "grandChild1");
        this.createAttribute("child1", "grandChild2");
        this.createAttribute("child2", "grandChild3");
        this.processTestData();
    }

    public void testComplexTree() throws IOException {
        this.at = new AttributeCreateOrderList(ROOT_LABEL);
        this.unProcessedList = new ArrayList<TreeAttributeMapping>();
        this.createAttribute(ROOT_LABEL, "child1");
        this.createAttribute(ROOT_LABEL, "child2");
        this.createAttribute(ROOT_LABEL, "child3");
        this.createAttribute("child1", "grandChild1");
        this.createAttribute("child1", "grandChild2");
        this.createAttribute("child2", "grandChild3");
        this.createAttribute("child2", "grandChild4");
        this.createAttribute("child2", "grandChild5");
        this.createAttribute("grandChild5", "greatGrandChild6");
        this.createAttribute("grandChild5", "greatGrandChild7");
        this.createAttribute("greatGrandChild7", "greatGreatGrandChild8");
        this.processTestData();
    }

    public void testInvalidTree() throws IOException {
        this.at = new AttributeCreateOrderList(ROOT_LABEL);
        this.unProcessedList = new ArrayList<TreeAttributeMapping>();
        this.createAttribute(ROOT_LABEL, "child1");
        this.createAttribute(ROOT_LABEL, "child2");
        this.createAttribute("child1", "grandChild1");
        this.createAttribute("child1", "grandChild2");
        this.createAttribute("xxxx", "grandChild3");
        try {
            this.processTestData();
            AttributeCreateOrderListTest.assertTrue((boolean)false);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testInvalidRootInTree() throws IOException {
        this.at = new AttributeCreateOrderList(ROOT_LABEL);
        this.unProcessedList = new ArrayList<TreeAttributeMapping>();
        try {
            this.createAttribute("child1", "child1");
            AttributeCreateOrderListTest.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void processTestData() {
        int size = this.unProcessedList.size();
        Iterator it = this.at.iterator();
        HashSet<String> retrievedElements = new HashSet<String>();
        retrievedElements.add(ROOT_LABEL);
        int count = 0;
        while (it.hasNext()) {
            ++count;
            TreeAttributeMapping tam = (TreeAttributeMapping)it.next();
            retrievedElements.add(tam.getLabel());
            if (tam.getLabel().equals(ROOT_LABEL)) continue;
            AttributeCreateOrderListTest.assertTrue((boolean)retrievedElements.contains(tam.getParentLabel()));
            this.unProcessedList.remove(tam);
        }
        AttributeCreateOrderListTest.assertEquals((int)count, (int)size);
        AttributeCreateOrderListTest.assertTrue((boolean)this.unProcessedList.isEmpty());
    }

    private void createAttribute(String parentlabel, String childLabel) {
        TreeAttributeMapping tam = new TreeAttributeMapping(null, null, null, null, false, null, childLabel, parentlabel, null, null);
        this.at.put(tam);
        this.unProcessedList.add(tam);
    }
}

