/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import com.vividsolutions.jts.geom.Point;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import junit.framework.TestCase;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.complex.AppSchemaDataAccess;
import org.geotools.data.complex.DataAccessRegistry;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.TestData;
import org.geotools.data.complex.config.AppSchemaDataAccessConfigurator;
import org.geotools.data.complex.config.AppSchemaDataAccessDTO;
import org.geotools.data.complex.config.XMLConfigDigester;
import org.geotools.data.memory.MemoryDataStore;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.NameImpl;
import org.geotools.feature.Types;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.feature.type.UniqueNameFeatureTypeFactoryImpl;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.logging.Logging;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.ComplexType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.xml.sax.helpers.NamespaceSupport;

public class AppSchemaDataAccessTest
extends TestCase {
    private static final Logger LOGGER = Logging.getLogger((String)AppSchemaDataAccessTest.class.getPackage().getName());
    Name targetName;
    FeatureType targetType;
    private AppSchemaDataAccess dataStore;
    FeatureTypeMapping mapping;

    protected void setUp() throws Exception {
        super.setUp();
        MemoryDataStore ds = AppSchemaDataAccessTest.createWaterSampleTestFeatures();
        this.targetType = TestData.createComplexWaterSampleType();
        UniqueNameFeatureTypeFactoryImpl tf = new UniqueNameFeatureTypeFactoryImpl();
        AttributeDescriptor targetFeature = tf.createAttributeDescriptor((AttributeType)this.targetType, this.targetType.getName(), 0, Integer.MAX_VALUE, true, null);
        this.targetName = targetFeature.getName();
        List mappings = TestData.createMappingsColumnsAndValues(targetFeature);
        Name sourceName = TestData.WATERSAMPLE_TYPENAME;
        SimpleFeatureSource source = ds.getFeatureSource(sourceName);
        NamespaceSupport namespaces = new NamespaceSupport();
        this.mapping = new FeatureTypeMapping((FeatureSource)source, targetFeature, mappings, namespaces);
        this.dataStore = new AppSchemaDataAccess(Collections.singleton(this.mapping));
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        DataAccessRegistry.unregisterAll();
    }

    public void testGetTypeNames() throws IOException {
        Name[] typeNames = this.dataStore.getTypeNames();
        AppSchemaDataAccessTest.assertNotNull((Object)typeNames);
        AppSchemaDataAccessTest.assertEquals((int)1, (int)typeNames.length);
        AppSchemaDataAccessTest.assertEquals((Object)this.targetName, (Object)typeNames[0]);
        List names = this.dataStore.getNames();
        AppSchemaDataAccessTest.assertNotNull((Object)names);
        AppSchemaDataAccessTest.assertEquals((int)1, (int)names.size());
        AppSchemaDataAccessTest.assertEquals((Object)this.targetName, names.get(0));
    }

    public void testTargetType() throws IOException {
        AppSchemaDataAccessTest.assertEquals((Object)this.targetType, (Object)this.dataStore.getSchema(this.targetName));
    }

    public void testGetBounds() throws IOException {
        String namespaceUri = "http://online.socialchange.net.au";
        String localName = "RoadSegment";
        Name typeName = Types.typeName((String)"http://online.socialchange.net.au", (String)"RoadSegment");
        URL configUrl = ((Object)((Object)this)).getClass().getResource("/test-data/roadsegments.xml");
        AppSchemaDataAccessDTO config = new XMLConfigDigester().parse(configUrl);
        Set mappings = AppSchemaDataAccessConfigurator.buildMappings((AppSchemaDataAccessDTO)config);
        this.dataStore = new AppSchemaDataAccess(mappings);
        FeatureSource source = this.dataStore.getFeatureSource(typeName);
        FeatureTypeMapping mapping = (FeatureTypeMapping)mappings.iterator().next();
        FeatureSource mappedSource = mapping.getSource();
        ReferencedEnvelope expected = this.getBounds(mappedSource);
        ReferencedEnvelope actual = this.getBounds(source);
        AppSchemaDataAccessTest.assertEquals((Object)expected, (Object)actual);
    }

    private ReferencedEnvelope getBounds(FeatureSource source) {
        try {
            ReferencedEnvelope boundingBox = new ReferencedEnvelope((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            FeatureCollection features = source.getFeatures();
            FeatureIterator iterator = features.features();
            try {
                while (iterator.hasNext()) {
                    Feature f = iterator.next();
                    boundingBox.include(f.getBounds());
                }
            }
            finally {
                iterator.close();
            }
            return boundingBox;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void testGetFeatureReader() throws IOException {
        FeatureSource access = this.dataStore.getFeatureSource(this.targetName);
        FeatureType type = access.getSchema();
        AppSchemaDataAccessTest.assertEquals((Object)this.targetType, (Object)type);
        FeatureCollection reader = access.getFeatures();
        AppSchemaDataAccessTest.assertNotNull((Object)reader);
        FeatureIterator features = reader.features();
        AppSchemaDataAccessTest.assertTrue((boolean)features.hasNext());
        Feature complexFeature = features.next();
        AppSchemaDataAccessTest.assertNotNull((Object)complexFeature);
        AppSchemaDataAccessTest.assertEquals((Object)this.targetType, (Object)complexFeature.getType());
        features.close();
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        PropertyName expr = ff.property("measurement[1]");
        Object value = expr.evaluate((Object)complexFeature);
        AppSchemaDataAccessTest.assertNotNull((Object)value);
        expr = ff.property("measurement[1]/parameter");
        value = expr.evaluate((Object)complexFeature);
        AppSchemaDataAccessTest.assertNotNull((Object)value);
        expr = ff.property("measurement[1]/value");
        value = expr.evaluate((Object)complexFeature);
        AppSchemaDataAccessTest.assertNotNull((Object)value);
        expr = ff.property("measurement[2]/parameter");
        value = expr.evaluate((Object)complexFeature);
        AppSchemaDataAccessTest.assertNotNull((Object)value);
        expr = ff.property("measurement[2]/value");
        value = expr.evaluate((Object)complexFeature);
        AppSchemaDataAccessTest.assertNotNull((Object)value);
        expr = ff.property("measurement[3]/parameter");
        value = expr.evaluate((Object)complexFeature);
        AppSchemaDataAccessTest.assertNotNull((Object)value);
        expr = ff.property("measurement[3]/value");
        value = expr.evaluate((Object)complexFeature);
        AppSchemaDataAccessTest.assertNotNull((Object)value);
    }

    public void testGetFeatureSource() throws IOException {
        FeatureSource complexSource = this.dataStore.getFeatureSource(this.targetName);
        AppSchemaDataAccessTest.assertNotNull((Object)complexSource);
        AppSchemaDataAccessTest.assertEquals((Object)this.targetType, (Object)complexSource.getSchema());
    }

    public void testGetFeatureReaderQuery() throws Exception {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        PropertyName property = ff.property("sample/measurement[1]/parameter");
        Literal literal = ff.literal((Object)"ph");
        PropertyIsEqualTo filterParameter = ff.equals((Expression)property, (Expression)literal);
        property = ff.property("sample/measurement[1]/value");
        literal = ff.literal((Object)new Integer(3));
        PropertyIsEqualTo filterValue = ff.equals((Expression)property, (Expression)literal);
        And filter = ff.and((Filter)filterParameter, (Filter)filterValue);
        FeatureSource complexSource = this.dataStore.getFeatureSource(this.targetName);
        FeatureCollection features = complexSource.getFeatures((Filter)filter);
        FeatureIterator reader = features.features();
        PropertyIsEqualTo equivalentSourceFilter = ff.equals((Expression)ff.property("ph"), (Expression)ff.literal((Object)new Integer(3)));
        FeatureCollection collection = this.mapping.getSource().getFeatures((Filter)equivalentSourceFilter);
        int count = 0;
        int expectedCount = collection.size();
        PropertyIsGreaterThan badFilter = ff.greater((Expression)ff.property("sample/measurement[1]/value"), (Expression)ff.literal((Object)new Integer(3)));
        while (reader.hasNext()) {
            Feature f = reader.next();
            AppSchemaDataAccessTest.assertNotNull((Object)f);
            AppSchemaDataAccessTest.assertTrue((boolean)filter.evaluate((Object)f));
            AppSchemaDataAccessTest.assertFalse((boolean)badFilter.evaluate((Object)f));
            ++count;
        }
        reader.close();
        AppSchemaDataAccessTest.assertEquals((int)expectedCount, (int)count);
    }

    public void testWithConfig() throws Exception {
        String nsUri = "http://online.socialchange.net.au";
        String localName = "RoadSegment";
        NameImpl typeName = new NameImpl("http://online.socialchange.net.au", "RoadSegment");
        URL configUrl = ((Object)((Object)this)).getClass().getResource("/test-data/roadsegments.xml");
        AppSchemaDataAccessDTO config = new XMLConfigDigester().parse(configUrl);
        Set mappings = AppSchemaDataAccessConfigurator.buildMappings((AppSchemaDataAccessDTO)config);
        this.dataStore = new AppSchemaDataAccess(mappings);
        FeatureSource source = this.dataStore.getFeatureSource((Name)typeName);
        FeatureType type = source.getSchema();
        AttributeDescriptor node = (AttributeDescriptor)Types.descriptor((ComplexType)type, (Name)Types.typeName((String)"http://online.socialchange.net.au", (String)"the_geom"));
        AppSchemaDataAccessTest.assertNotNull((Object)node);
        AppSchemaDataAccessTest.assertEquals((String)"LineStringPropertyType", (String)node.getType().getName().getLocalPart());
        AppSchemaDataAccessTest.assertNotNull((Object)Types.descriptor((ComplexType)type, (Name)Types.typeName((String)"http://online.socialchange.net.au", (String)"name")));
        Name ftNodeName = Types.typeName((String)"http://online.socialchange.net.au", (String)"fromToNodes");
        AppSchemaDataAccessTest.assertNotNull((Object)Types.descriptor((ComplexType)type, (Name)ftNodeName));
        AttributeDescriptor descriptor = (AttributeDescriptor)Types.descriptor((ComplexType)type, (Name)ftNodeName);
        ComplexType fromToNodes = (ComplexType)descriptor.getType();
        AppSchemaDataAccessTest.assertFalse((boolean)descriptor.isNillable());
        AppSchemaDataAccessTest.assertTrue((boolean)fromToNodes.isIdentified());
        Name fromNodeName = Types.typeName((String)"http://online.socialchange.net.au", (String)"fromNode");
        AttributeDescriptor fromNode = (AttributeDescriptor)Types.descriptor((ComplexType)fromToNodes, (Name)fromNodeName);
        AppSchemaDataAccessTest.assertNotNull((Object)fromNode);
        Name toNodeName = Types.typeName((String)"http://online.socialchange.net.au", (String)"toNode");
        AttributeDescriptor toNode = (AttributeDescriptor)Types.descriptor((ComplexType)fromToNodes, (Name)toNodeName);
        AppSchemaDataAccessTest.assertNotNull((Object)fromNode);
        AppSchemaDataAccessTest.assertEquals(Point.class, (Object)fromNode.getType().getBinding());
        AppSchemaDataAccessTest.assertEquals(Point.class, (Object)toNode.getType().getBinding());
        Name subName = Types.typeName((String)"http://online.socialchange.net.au", (String)"broadTypeEl");
        descriptor = (AttributeDescriptor)Types.descriptor((ComplexType)type, (Name)subName);
        ComplexType subbedType = (ComplexType)descriptor.getType();
        AttributeDescriptor sub = (AttributeDescriptor)Types.descriptor((ComplexType)subbedType, (Name)subName);
        FeatureCollection content = source.getFeatures();
        FeatureIterator features = content.features();
        int count = 0;
        int expectedCount = 5;
        try {
            try {
                while (features.hasNext()) {
                    Feature f = features.next();
                    LOGGER.finest(String.valueOf(f));
                    ++count;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            features.close();
        }
        AppSchemaDataAccessTest.assertEquals((String)"feature count", (int)5, (int)count);
        int expectedCount2 = 3;
        DefaultQuery query = new DefaultQuery();
        query.setMaxFeatures(3);
        FeatureCollection content2 = source.getFeatures((Query)query);
        FeatureIterator features2 = content2.features();
        int count2 = 0;
        try {
            try {
                while (features2.hasNext()) {
                    Feature f = features2.next();
                    LOGGER.finest(String.valueOf(f));
                    ++count2;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            features2.close();
        }
        AppSchemaDataAccessTest.assertEquals((String)"feature count", (int)3, (int)count2);
    }

    public static MemoryDataStore createWaterSampleTestFeatures() throws Exception {
        MemoryDataStore dataStore = new MemoryDataStore();
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName(TestData.WATERSAMPLE_TYPENAME.getLocalPart());
        tb.add("watersampleid", String.class);
        tb.add("ph", Integer.class);
        tb.add("temp", Integer.class);
        tb.add("turbidity", Float.class);
        SimpleFeatureType type = tb.buildFeatureType();
        dataStore.createSchema(type);
        int NUM_FEATURES = 10;
        SimpleFeatureBuilder fbuilder = new SimpleFeatureBuilder(type);
        int i = 0;
        while (i < 10) {
            String fid = String.valueOf(type.getName().getLocalPart()) + "." + i;
            fbuilder.add((Object)("watersample." + i));
            fbuilder.add((Object)new Integer(i));
            fbuilder.add((Object)new Integer(10 + i));
            fbuilder.add((Object)new Float(i));
            SimpleFeature f = fbuilder.buildFeature(fid);
            dataStore.addFeature(f);
            ++i;
        }
        return dataStore;
    }
}

