/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex.filter;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Polygon;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.geotools.data.DataAccess;
import org.geotools.data.DataAccessFinder;
import org.geotools.data.FeatureSource;
import org.geotools.data.complex.AppSchemaDataAccess;
import org.geotools.data.complex.AttributeMapping;
import org.geotools.data.complex.DataAccessRegistry;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.TestData;
import org.geotools.data.complex.filter.UnmappingFilterVisitor;
import org.geotools.data.complex.filter.XPath;
import org.geotools.data.memory.MemoryDataStore;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.NameImpl;
import org.geotools.feature.TypeBuilder;
import org.geotools.feature.Types;
import org.geotools.feature.type.UniqueNameFeatureTypeFactoryImpl;
import org.geotools.filter.FilterFactoryImplNamespaceAware;
import org.geotools.filter.IsEqualsToImpl;
import org.geotools.filter.OrImpl;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.FeatureTypeFactory;
import org.opengis.feature.type.Name;
import org.opengis.filter.And;
import org.opengis.filter.BinaryLogicOperator;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Id;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.Multiply;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.identity.FeatureId;
import org.opengis.filter.spatial.Intersects;
import org.xml.sax.helpers.NamespaceSupport;

public class UnmappingFilterVisitorTest {
    private static FilterFactory2 ff = (FilterFactory2)CommonFactoryFinder.getFilterFactory(null);
    private UnmappingFilterVisitor visitor;
    MemoryDataStore dataStore;
    FeatureTypeMapping mapping;
    AttributeDescriptor targetDescriptor;
    FeatureType targetType;
    private static DataAccess<FeatureType, Feature> mappingDataStore;

    @Before
    public void setUp() throws Exception {
        this.dataStore = TestData.createDenormalizedWaterQualityResults();
        this.mapping = TestData.createMappingsGroupByStation(this.dataStore);
        this.visitor = new UnmappingFilterVisitor(this.mapping);
        this.targetDescriptor = this.mapping.getTargetFeature();
    }

    @BeforeClass
    public static void oneTimeSetUp() throws IOException {
        String schemaBase = "/test-data/";
        HashMap<String, String> dsParams = new HashMap<String, String>();
        URL url = UnmappingFilterVisitorTest.class.getResource("/test-data/BoreholeTest_properties.xml");
        dsParams.put("dbtype", "app-schema");
        dsParams.put("url", url.toExternalForm());
        mappingDataStore = DataAccessFinder.getDataStore(dsParams);
    }

    @AfterClass
    public static void oneTimeTearDown() {
        DataAccessRegistry.unregisterAll();
    }

    private FeatureTypeMapping createSampleDerivedAttributeMappings() throws Exception {
        UniqueNameFeatureTypeFactoryImpl tf = new UniqueNameFeatureTypeFactoryImpl();
        TypeBuilder builder = new TypeBuilder((FeatureTypeFactory)tf);
        AttributeType areaOfInfluence = builder.name("areaOfInfluence").bind(Polygon.class).attribute();
        AttributeType concatType = builder.name("concatenated").bind(String.class).attribute();
        builder.setName("target");
        builder.addAttribute("areaOfInfluence", areaOfInfluence);
        builder.addAttribute("concatenated", concatType);
        FeatureType targetType = builder.feature();
        AttributeDescriptor targetFeature = tf.createAttributeDescriptor((AttributeType)targetType, targetType.getName(), 0, Integer.MAX_VALUE, true, null);
        LinkedList<AttributeMapping> attMappings = new LinkedList<AttributeMapping>();
        NamespaceSupport namespaces = new NamespaceSupport();
        Function aoiExpr = ff.function("buffer", new Expression[]{ff.property("location"), ff.literal(10)});
        attMappings.add(new AttributeMapping(null, (Expression)aoiExpr, XPath.steps((AttributeDescriptor)targetFeature, (String)"areaOfInfluence", (NamespaceSupport)namespaces)));
        Function strConcat = ff.function("strConcat", new Expression[]{ff.property("anzlic_no"), ff.property("project_no")});
        attMappings.add(new AttributeMapping(null, (Expression)strConcat, XPath.steps((AttributeDescriptor)targetFeature, (String)"concatenated", (NamespaceSupport)namespaces)));
        FeatureSource simpleSource = this.mapping.getSource();
        FeatureTypeMapping mapping = new FeatureTypeMapping(simpleSource, targetFeature, attMappings, namespaces);
        return mapping;
    }

    @Test
    public void testUnrollFidMappedToAttribute() throws Exception {
        String fid = "station_no.1";
        Id fidFilter = ff.id(Collections.singleton(ff.featureId(fid)));
        Filter unrolled = (Filter)fidFilter.accept((FilterVisitor)this.visitor, null);
        Assert.assertNotNull((Object)unrolled);
        FeatureCollection results = this.mapping.getSource().getFeatures(unrolled);
        Assert.assertEquals((long)1L, (long)this.getCount(results));
        Iterator features = results.iterator();
        SimpleFeature unmappedFeature = (SimpleFeature)features.next();
        results.close(features);
        Assert.assertNotNull((Object)unmappedFeature);
        Object object = unmappedFeature.getProperty("station_no").getValue();
        Assert.assertEquals((Object)fid, (Object)object);
    }

    @Test
    public void testUnrollFid() throws Exception {
        HashSet<FeatureId> fids = new HashSet<FeatureId>();
        String fid1 = "station_no.1";
        String fid2 = "station_no.500";
        fids.add(ff.featureId(fid1));
        fids.add(ff.featureId(fid2));
        Id fidFilter = ff.id(fids);
        Filter unrolled = (Filter)fidFilter.accept((FilterVisitor)this.visitor, null);
        Assert.assertNotNull((Object)unrolled);
        Assert.assertTrue((boolean)(unrolled instanceof OrImpl));
        List filters = ((OrImpl)unrolled).getChildren();
        Assert.assertEquals((long)2L, (long)filters.size());
        for (Filter f : filters) {
            Assert.assertTrue((boolean)(f instanceof IsEqualsToImpl));
        }
        FeatureCollection results = this.mapping.getSource().getFeatures(unrolled);
        Assert.assertEquals((long)1L, (long)this.getCount(results));
        Iterator features = results.iterator();
        SimpleFeature unmappedFeature = (SimpleFeature)features.next();
        results.close(features);
        Assert.assertNotNull((Object)unmappedFeature);
        Object object = unmappedFeature.getProperty("station_no").getValue();
        Assert.assertEquals((Object)fid1, (Object)object);
    }

    private int getCount(FeatureCollection features) {
        Iterator iterator = features.iterator();
        int count = 0;
        try {
            while (iterator.hasNext()) {
                iterator.next();
                ++count;
            }
        }
        finally {
            features.close(iterator);
        }
        return count;
    }

    @Test
    public void testUnrollFidToFid() throws Exception {
        this.checkUnrollIdExpression(Expression.NIL);
    }

    @Test
    public void testUnrollGetidToGetid() throws Exception {
        this.checkUnrollIdExpression((Expression)CommonFactoryFinder.getFilterFactory(null).function("getID", new Expression[0]));
    }

    private void checkUnrollIdExpression(Expression idExpression) throws Exception {
        AttributeMapping featureMapping = null;
        Name featurePath = this.mapping.getTargetFeature().getName();
        QName featureName = Types.toQName((Name)featurePath);
        for (AttributeMapping attMapping : this.mapping.getAttributeMappings()) {
            XPath.Step step;
            XPath.StepList targetXPath = attMapping.getTargetXPath();
            if (targetXPath.size() > 1 || !featureName.equals((step = (XPath.Step)targetXPath.get(0)).getName())) continue;
            featureMapping = attMapping;
            break;
        }
        featureMapping.setIdentifierExpression(idExpression);
        this.visitor = new UnmappingFilterVisitor(this.mapping);
        FeatureCollection content = this.mapping.getSource().getFeatures();
        Iterator iterator = content.iterator();
        Feature sourceFeature = (Feature)iterator.next();
        content.close(iterator);
        String fid = sourceFeature.getIdentifier().toString();
        Id fidFilter = ff.id(Collections.singleton(ff.featureId(fid)));
        Filter unrolled = (Filter)fidFilter.accept((FilterVisitor)this.visitor, null);
        Assert.assertNotNull((Object)unrolled);
        Assert.assertTrue((boolean)(unrolled instanceof Id));
        FeatureCollection results = this.mapping.getSource().getFeatures(unrolled);
        Assert.assertEquals((long)1L, (long)this.getCount(results));
        iterator = results.iterator();
        SimpleFeature unmappedFeature = (SimpleFeature)iterator.next();
        results.close(iterator);
        Assert.assertEquals((Object)fid, (Object)unmappedFeature.getID());
    }

    @Test
    public void testPropertyName() throws Exception {
        PropertyName ae = ff.property("/wq_plus/measurement/result");
        List unrolled = (List)ae.accept((ExpressionVisitor)this.visitor, null);
        Assert.assertNotNull((Object)unrolled);
        Assert.assertEquals((long)1L, (long)unrolled.size());
        Expression unmappedExpr = (Expression)unrolled.get(0);
        Assert.assertTrue((boolean)(unmappedExpr instanceof PropertyName));
        PropertyName attExp = (PropertyName)unmappedExpr;
        Assert.assertEquals((Object)"results_value", (Object)attExp.getPropertyName());
        FeatureTypeMapping mapping = this.createSampleDerivedAttributeMappings();
        this.targetDescriptor = mapping.getTargetFeature();
        this.visitor = new UnmappingFilterVisitor(mapping);
        attExp = ff.property("areaOfInfluence");
        List unrolledExpressions = (List)attExp.accept((ExpressionVisitor)this.visitor, null);
        Assert.assertNotNull((Object)unrolledExpressions);
        Assert.assertEquals((long)1L, (long)unrolledExpressions.size());
        unmappedExpr = (Expression)unrolledExpressions.get(0);
        Assert.assertTrue((boolean)(unmappedExpr instanceof Function));
        Function fe = (Function)unmappedExpr;
        Assert.assertEquals((Object)"buffer", (Object)fe.getName());
        Expression arg0 = (Expression)fe.getParameters().get(0);
        Assert.assertTrue((boolean)(arg0 instanceof PropertyName));
        Assert.assertEquals((Object)"location", (Object)((PropertyName)arg0).getPropertyName());
    }

    @Test
    public void testPropertyNameWithXlinkAttribute() throws Exception {
        String XMMLNS = "http://www.opengis.net/xmml";
        NameImpl typeName = new NameImpl("http://www.opengis.net/xmml", "Borehole");
        AppSchemaDataAccess complexDs = (AppSchemaDataAccess)mappingDataStore;
        this.mapping = complexDs.getMappingByElement((Name)typeName);
        NamespaceSupport namespaces = new NamespaceSupport();
        namespaces.declarePrefix("gml", "http://www.opengis.net/gml");
        namespaces.declarePrefix("xmml", "http://www.opengis.net/xmml");
        namespaces.declarePrefix("xlink", "http://www.w3.org/1999/xlink");
        FilterFactoryImplNamespaceAware ff = new FilterFactoryImplNamespaceAware(namespaces);
        String xpathExpression = "sa:shape/geo:LineByVector/geo:origin/@xlink:href";
        PropertyName propNameExpression = ff.property(xpathExpression);
        this.visitor = new UnmappingFilterVisitor(this.mapping);
        List unrolled = (List)propNameExpression.accept((ExpressionVisitor)this.visitor, null);
        Assert.assertNotNull((Object)unrolled);
        Assert.assertEquals((long)1L, (long)unrolled.size());
        Assert.assertTrue((boolean)(unrolled.get(0) instanceof Expression));
    }

    @Test
    public void testBetweenFilter() throws Exception {
        PropertyIsBetween bf = ff.between((Expression)ff.property("measurement/result"), (Expression)ff.literal(1), (Expression)ff.literal(2));
        PropertyIsBetween unrolled = (PropertyIsBetween)bf.accept((FilterVisitor)this.visitor, null);
        Expression att = unrolled.getExpression();
        Assert.assertTrue((boolean)(att instanceof PropertyName));
        String propertyName = ((PropertyName)att).getPropertyName();
        Assert.assertEquals((Object)"results_value", (Object)propertyName);
    }

    @Test
    public void testCompareFilter() throws Exception {
        PropertyIsEqualTo complexFilter = ff.equals((Expression)ff.property("measurement/result"), (Expression)ff.literal(1.1));
        Filter unrolled = (Filter)complexFilter.accept((FilterVisitor)this.visitor, null);
        Assert.assertNotNull((Object)unrolled);
        Assert.assertTrue((boolean)(unrolled instanceof PropertyIsEqualTo));
        Assert.assertNotSame((Object)complexFilter, (Object)unrolled);
        Expression left = ((PropertyIsEqualTo)unrolled).getExpression1();
        Expression right = ((PropertyIsEqualTo)unrolled).getExpression2();
        Assert.assertTrue((boolean)(left instanceof PropertyName));
        Assert.assertTrue((boolean)(right instanceof Literal));
        PropertyName attExp = (PropertyName)left;
        String expectedAtt = "results_value";
        Assert.assertEquals((Object)expectedAtt, (Object)attExp.getPropertyName());
        Assert.assertEquals((Object)new Double(1.1), (Object)((Literal)right).getValue());
    }

    @Test
    public void testCompareFilterMultipleMappingsPerPropertyName() throws Exception {
        String XMMLNS = "http://www.opengis.net/xmml";
        NameImpl typeName = new NameImpl("http://www.opengis.net/xmml", "Borehole");
        AppSchemaDataAccess complexDs = (AppSchemaDataAccess)mappingDataStore;
        this.mapping = complexDs.getMappingByElement((Name)typeName);
        NamespaceSupport namespaces = new NamespaceSupport();
        namespaces.declarePrefix("gml", "http://www.opengis.net/gml");
        namespaces.declarePrefix("xmml", "http://www.opengis.net/xmml");
        FilterFactoryImplNamespaceAware ff = new FilterFactoryImplNamespaceAware(namespaces);
        PropertyIsEqualTo complexFilter = ff.equals((Expression)ff.property("gml:name"), (Expression)ff.literal((Object)"SWADLINCOTE"));
        this.visitor = new UnmappingFilterVisitor(this.mapping);
        Filter unrolled = (Filter)complexFilter.accept((FilterVisitor)this.visitor, null);
        Assert.assertNotNull((Object)unrolled);
        Assert.assertNotSame((Object)complexFilter, (Object)unrolled);
        Assert.assertTrue((String)unrolled.getClass().getName(), (boolean)(unrolled instanceof Or));
        Or oredFilter = (Or)unrolled;
        List children = oredFilter.getChildren();
        Assert.assertEquals((long)4L, (long)children.size());
        Assert.assertTrue((boolean)(children.get(0) instanceof PropertyIsEqualTo));
        Assert.assertTrue((boolean)(children.get(1) instanceof PropertyIsEqualTo));
        Assert.assertTrue((boolean)(children.get(2) instanceof PropertyIsEqualTo));
        Assert.assertTrue((boolean)(children.get(3) instanceof PropertyIsEqualTo));
        PropertyIsEqualTo filter1 = (PropertyIsEqualTo)children.get(0);
        PropertyIsEqualTo filter2 = (PropertyIsEqualTo)children.get(1);
        PropertyIsEqualTo filter3 = (PropertyIsEqualTo)children.get(2);
        PropertyIsEqualTo filter4 = (PropertyIsEqualTo)children.get(3);
        Assert.assertTrue((boolean)(filter1.getExpression1() instanceof Function));
        Assert.assertTrue((boolean)(filter2.getExpression1() instanceof PropertyName));
        Assert.assertTrue((boolean)(filter3.getExpression1() instanceof PropertyName));
        Assert.assertTrue((boolean)(filter4.getExpression1() instanceof PropertyName));
        Assert.assertTrue((boolean)(filter1.getExpression2() instanceof Literal));
        Assert.assertTrue((boolean)(filter2.getExpression2() instanceof Literal));
        Assert.assertTrue((boolean)(filter3.getExpression2() instanceof Literal));
        Assert.assertTrue((boolean)(filter4.getExpression2() instanceof Literal));
        Assert.assertEquals((Object)"BGS_ID", (Object)((PropertyName)filter2.getExpression1()).getPropertyName());
        Assert.assertEquals((Object)"NAME", (Object)((PropertyName)filter3.getExpression1()).getPropertyName());
        Assert.assertEquals((Object)"ORIGINAL_N", (Object)((PropertyName)filter4.getExpression1()).getPropertyName());
    }

    @Test
    public void testLogicFilterAnd() throws Exception {
        PropertyIsEqualTo equals = ff.equals((Expression)ff.property("measurement/result"), (Expression)ff.literal(1.1));
        PropertyIsGreaterThan greater = ff.greater((Expression)ff.property("measurement/determinand_description"), (Expression)ff.literal((Object)"desc1"));
        And logicFilter = ff.and((Filter)equals, (Filter)greater);
        Filter unrolled = (Filter)logicFilter.accept((FilterVisitor)this.visitor, null);
        Assert.assertNotNull((Object)unrolled);
        Assert.assertTrue((boolean)(unrolled instanceof And));
        Assert.assertNotSame((Object)equals, (Object)unrolled);
        And sourceAnd = (And)unrolled;
        Assert.assertEquals((long)2L, (long)sourceAnd.getChildren().size());
        Filter sourceEquals = (Filter)sourceAnd.getChildren().get(0);
        Assert.assertTrue((boolean)(sourceEquals instanceof PropertyIsEqualTo));
        Expression left = ((PropertyIsEqualTo)sourceEquals).getExpression1();
        Expression right = ((PropertyIsEqualTo)sourceEquals).getExpression2();
        Assert.assertTrue((boolean)(left instanceof PropertyName));
        Assert.assertTrue((boolean)(right instanceof Literal));
        Assert.assertEquals((Object)"results_value", (Object)((PropertyName)left).getPropertyName());
        Assert.assertEquals((Object)new Double(1.1), (Object)((Literal)right).getValue());
        Filter sourceGreater = (Filter)sourceAnd.getChildren().get(1);
        Assert.assertTrue((boolean)(sourceGreater instanceof PropertyIsGreaterThan));
        left = ((PropertyIsGreaterThan)sourceGreater).getExpression1();
        right = ((PropertyIsGreaterThan)sourceGreater).getExpression2();
        Assert.assertTrue((boolean)(left instanceof PropertyName));
        Assert.assertTrue((boolean)(right instanceof Literal));
        Assert.assertEquals((Object)"determinand_description", (Object)((PropertyName)left).getPropertyName());
        Assert.assertEquals((Object)"desc1", (Object)((Literal)right).getValue());
    }

    @Test
    public void testFunction() throws Exception {
        Function fe = ff.function("strIndexOf", new Expression[]{ff.property("/measurement/determinand_description"), ff.literal((Object)"determinand_description_1")});
        List unrolledExpressions = (List)fe.accept((ExpressionVisitor)this.visitor, null);
        Expression unmapped = (Expression)unrolledExpressions.get(0);
        Assert.assertTrue((boolean)(unmapped instanceof Function));
        List params = ((Function)unmapped).getParameters();
        Assert.assertEquals((long)2L, (long)params.size());
        Assert.assertTrue((boolean)(params.get(0) instanceof PropertyName));
        Assert.assertEquals((Object)"determinand_description", (Object)((PropertyName)params.get(0)).getPropertyName());
    }

    @Test
    public void testGeometryFilter() throws Exception {
        this.mapping = this.createSampleDerivedAttributeMappings();
        this.visitor = new UnmappingFilterVisitor(this.mapping);
        this.targetDescriptor = this.mapping.getTargetFeature();
        this.targetType = (FeatureType)this.targetDescriptor.getType();
        Literal literalGeom = ff.literal((Object)new GeometryFactory().createPoint(new Coordinate(1.0, 1.0)));
        Intersects gf = ff.intersects((Expression)ff.property("areaOfInfluence"), (Expression)literalGeom);
        Filter unrolled = (Filter)gf.accept((FilterVisitor)this.visitor, null);
        Assert.assertTrue((boolean)(unrolled instanceof Intersects));
        Assert.assertNotSame((Object)gf, (Object)unrolled);
        Intersects newFilter = (Intersects)unrolled;
        Expression left = newFilter.getExpression1();
        Expression right = newFilter.getExpression2();
        Assert.assertSame((Object)right, (Object)literalGeom);
        Assert.assertTrue((boolean)(left instanceof Function));
        Function fe = (Function)left;
        Assert.assertEquals((Object)"buffer", (Object)fe.getName());
        Expression arg0 = (Expression)fe.getParameters().get(0);
        Assert.assertTrue((boolean)(arg0 instanceof PropertyName));
        Assert.assertEquals((Object)"location", (Object)((PropertyName)arg0).getPropertyName());
    }

    @Test
    public void testLikeFilter() throws Exception {
        String wildcard = "%";
        String single = "?";
        String escape = "\\";
        PropertyIsLike like = ff.like((Expression)ff.property("/measurement/determinand_description"), "%n_1_1", "%", "?", "\\");
        PropertyIsLike unmapped = (PropertyIsLike)like.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)like.getLiteral(), (Object)unmapped.getLiteral());
        Assert.assertEquals((Object)like.getWildCard(), (Object)unmapped.getWildCard());
        Assert.assertEquals((Object)like.getSingleChar(), (Object)unmapped.getSingleChar());
        Assert.assertEquals((Object)like.getEscape(), (Object)unmapped.getEscape());
        Expression unmappedExpr = unmapped.getExpression();
        Assert.assertTrue((boolean)(unmappedExpr instanceof PropertyName));
        Assert.assertEquals((Object)"determinand_description", (Object)((PropertyName)unmappedExpr).getPropertyName());
    }

    @Test
    public void testLiteralExpression() throws Exception {
        Literal literal = ff.literal((Object)new Integer(0));
        List unrolledExpressions = (List)literal.accept((ExpressionVisitor)this.visitor, null);
        Assert.assertEquals((long)1L, (long)unrolledExpressions.size());
        Assert.assertSame((Object)literal, unrolledExpressions.get(0));
    }

    @Test
    public void testLogicFilter() throws Exception {
        this.testLogicFilter(And.class);
        this.testLogicFilter(Or.class);
    }

    private void testLogicFilter(Class filterType) throws Exception {
        And complexLogicFilter;
        PropertyIsGreaterThan resultFilter = ff.greater((Expression)ff.property("measurement/result"), (Expression)ff.literal((Object)new Integer(5)));
        PropertyIsBetween determFilter = ff.between((Expression)ff.property("measurement/determinand_description"), (Expression)ff.literal((Object)"determinand_description_1_1"), (Expression)ff.literal((Object)"determinand_description_3_3"));
        if (And.class.equals((Object)filterType)) {
            complexLogicFilter = ff.and((Filter)resultFilter, (Filter)determFilter);
        } else if (Or.class.equals((Object)filterType)) {
            complexLogicFilter = ff.or((Filter)resultFilter, (Filter)determFilter);
        } else {
            throw new IllegalArgumentException();
        }
        Filter unmapped = (Filter)complexLogicFilter.accept((FilterVisitor)this.visitor, null);
        Assert.assertNotNull((Object)unmapped);
        Assert.assertTrue((boolean)(unmapped instanceof BinaryLogicOperator));
        Assert.assertNotSame((Object)complexLogicFilter, (Object)unmapped);
        BinaryLogicOperator logicUnmapped = (BinaryLogicOperator)unmapped;
        List children = logicUnmapped.getChildren();
        Assert.assertEquals((long)2L, (long)children.size());
        PropertyIsGreaterThan unmappedResult = (PropertyIsGreaterThan)children.get(0);
        PropertyIsBetween unmappedDeterm = (PropertyIsBetween)children.get(1);
        Assert.assertEquals((Object)"results_value", (Object)((PropertyName)unmappedResult.getExpression1()).getPropertyName());
        Assert.assertEquals((Object)new Integer(5), (Object)((Literal)unmappedResult.getExpression2()).getValue());
        Assert.assertEquals((Object)"determinand_description", (Object)((PropertyName)unmappedDeterm.getExpression()).getPropertyName());
        Assert.assertEquals((Object)"determinand_description_1_1", (Object)((Literal)unmappedDeterm.getLowerBoundary()).getValue());
        Assert.assertEquals((Object)"determinand_description_3_3", (Object)((Literal)unmappedDeterm.getUpperBoundary()).getValue());
    }

    @Test
    public void testMathExpression() throws Exception {
        Literal literal = ff.literal((Object)new Integer(2));
        Multiply mathExp = ff.multiply((Expression)ff.property("measurement/result"), (Expression)literal);
        List unrolledExpressions = (List)mathExp.accept((ExpressionVisitor)this.visitor, null);
        Assert.assertEquals((long)1L, (long)unrolledExpressions.size());
        Expression unmapped = (Expression)unrolledExpressions.get(0);
        Assert.assertTrue((boolean)(unmapped instanceof Multiply));
        Multiply mathUnmapped = (Multiply)unmapped;
        PropertyName unmappedAttt = (PropertyName)mathUnmapped.getExpression1();
        Assert.assertEquals((Object)"results_value", (Object)unmappedAttt.getPropertyName());
        Assert.assertSame((Object)literal, (Object)mathUnmapped.getExpression2());
    }

    @Test
    public void testNullFilter() throws Exception {
        PropertyIsNull nullFilter = ff.isNull((Expression)ff.property("measurement/result"));
        Filter unrolled = (Filter)nullFilter.accept((FilterVisitor)this.visitor, null);
        Assert.assertTrue((boolean)(unrolled instanceof PropertyIsNull));
        Assert.assertNotSame((Object)nullFilter, (Object)unrolled);
        PropertyIsNull unmapped = (PropertyIsNull)unrolled;
        Expression unmappedAtt = unmapped.getExpression();
        Assert.assertTrue((boolean)(unmappedAtt instanceof PropertyName));
        Assert.assertEquals((Object)"results_value", (Object)((PropertyName)unmappedAtt).getPropertyName());
    }
}

