/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import com.vividsolutions.jts.geom.EmptyGeometry;
import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.geotools.data.DataAccess;
import org.geotools.data.DataSourceException;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.complex.AbstractMappingFeatureIterator;
import org.geotools.data.complex.AppSchemaDataAccess;
import org.geotools.data.complex.AttributeMapping;
import org.geotools.data.complex.ComplexFeatureConstants;
import org.geotools.data.complex.DataAccessRegistry;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.NestedAttributeMapping;
import org.geotools.data.complex.filter.XPath;
import org.geotools.factory.Hints;
import org.geotools.feature.AttributeBuilder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureImpl;
import org.geotools.feature.Types;
import org.geotools.filter.AttributeExpressionImpl;
import org.geotools.filter.FilterFactoryImpl;
import org.opengis.feature.Attribute;
import org.opengis.feature.ComplexAttribute;
import org.opengis.feature.Feature;
import org.opengis.feature.GeometryAttribute;
import org.opengis.feature.Property;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.identity.FeatureId;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataAccessMappingFeatureIterator
extends AbstractMappingFeatureIterator {
    private Iterator<Feature> sourceFeatureIterator;
    protected CoordinateReferenceSystem reprojection;
    protected Feature curSrcFeature;
    protected FeatureSource<FeatureType, Feature> mappedSource;
    protected FeatureCollection<FeatureType, Feature> sourceFeatures;
    private boolean isNextFeatureSet;
    private boolean isFiltered;
    private ArrayList<String> filteredFeatures;

    public DataAccessMappingFeatureIterator(AppSchemaDataAccess store, FeatureTypeMapping mapping, Query query, boolean isFiltered) throws IOException {
        this(store, mapping, query, isFiltered, false);
    }

    public DataAccessMappingFeatureIterator(AppSchemaDataAccess store, FeatureTypeMapping mapping, Query query, boolean isFiltered, boolean isQueryUnrolled) throws IOException {
        super(store, mapping, query, isQueryUnrolled);
        this.isFiltered = isFiltered;
        if (isFiltered) {
            this.filteredFeatures = new ArrayList();
        }
    }

    @Override
    public boolean hasNext() {
        this.setHasNextCalled(true);
        boolean exists = false;
        if (this.featureCounter < this.maxFeatures) {
            if (this.isNextFeatureSet()) {
                this.flagNextFeature(false);
                return this.curSrcFeature != null;
            }
            if (this.getSourceFeatureIterator() != null && this.getSourceFeatureIterator().hasNext()) {
                this.curSrcFeature = this.getSourceFeatureIterator().next();
                exists = true;
            }
            if (exists && this.filteredFeatures != null) {
                while (exists && this.filteredFeatures.contains(this.extractIdForFeature(this.curSrcFeature))) {
                    if (this.getSourceFeatureIterator() != null && this.getSourceFeatureIterator().hasNext()) {
                        this.curSrcFeature = this.getSourceFeatureIterator().next();
                        exists = true;
                        continue;
                    }
                    exists = false;
                }
                if (!exists) {
                    this.curSrcFeature = null;
                }
            }
        }
        if (!exists) {
            LOGGER.finest("no more features, produced " + this.featureCounter);
            this.close();
            this.curSrcFeature = null;
        }
        this.flagNextFeature(false);
        return exists;
    }

    @Override
    protected Iterator<Feature> getSourceFeatureIterator() {
        return this.sourceFeatureIterator;
    }

    @Override
    protected boolean isSourceFeatureIteratorNull() {
        return this.getSourceFeatureIterator() == null;
    }

    @Override
    protected void initialiseSourceFeatures(FeatureTypeMapping mapping, Query query) throws IOException {
        this.mappedSource = mapping.getSource();
        this.reprojection = query.getCoordinateSystemReproject();
        query.setMaxFeatures(Integer.MAX_VALUE);
        this.sourceFeatures = this.mappedSource.getFeatures(query);
        if (this.reprojection != null) {
            this.xpathAttributeBuilder.setCRS(this.reprojection);
            if (this.sourceFeatures.getSchema().getGeometryDescriptor() == null) {
                query.setCoordinateSystemReproject(null);
            }
        }
        try {
            this.sourceFeatureIterator = this.sourceFeatures.iterator();
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    protected boolean unprocessedFeatureExists() {
        boolean exists = this.getSourceFeatureIterator().hasNext();
        if (exists && this.curSrcFeature == null) {
            this.curSrcFeature = this.getSourceFeatureIterator().next();
        }
        return exists;
    }

    @Override
    protected String extractIdForFeature() {
        return this.extractIdForFeature(this.curSrcFeature);
    }

    protected String extractIdForFeature(Feature feature) {
        if (this.mapping.getFeatureIdExpression().equals(Expression.NIL)) {
            if (feature.getIdentifier() == null) {
                return null;
            }
            return feature.getIdentifier().getID();
        }
        return (String)this.mapping.getFeatureIdExpression().evaluate((Object)feature, String.class);
    }

    @Override
    protected String extractIdForAttribute(Expression idExpression, Object sourceInstance) {
        String value = (String)idExpression.evaluate(sourceInstance, String.class);
        return value;
    }

    @Override
    protected boolean isNextSourceFeatureNull() {
        return this.curSrcFeature == null;
    }

    @Override
    protected boolean sourceFeatureIteratorHasNext() {
        return this.getSourceFeatureIterator().hasNext();
    }

    protected Object getValues(boolean isMultiValued, Expression expression, Object sourceFeatureInput) {
        if (isMultiValued && sourceFeatureInput instanceof FeatureImpl && expression instanceof AttributeExpressionImpl) {
            AttributeExpressionImpl attribExpression = (AttributeExpressionImpl)expression;
            String xpath = attribExpression.getPropertyName();
            ComplexAttribute sourceFeature = (ComplexAttribute)sourceFeatureInput;
            XPath.StepList xpathSteps = XPath.steps(sourceFeature.getDescriptor(), xpath, this.namespaces);
            return this.getProperties(sourceFeature, xpathSteps);
        }
        return expression.evaluate(sourceFeatureInput);
    }

    protected void setAttributeValue(Attribute target, Feature source, AttributeMapping attMapping) throws IOException {
        Expression sourceExpression = attMapping.getSourceExpression();
        AttributeType targetNodeType = attMapping.getTargetNodeInstance();
        XPath.StepList xpath = attMapping.getTargetXPath();
        Map clientPropsMappings = attMapping.getClientProperties();
        boolean isNestedFeature = attMapping.isNestedAttribute();
        String id = null;
        if (Expression.NIL != attMapping.getIdentifierExpression()) {
            id = this.extractIdForAttribute(attMapping.getIdentifierExpression(), source);
        }
        if (attMapping.isNestedAttribute()) {
            NestedAttributeMapping nestedMapping = (NestedAttributeMapping)attMapping;
            Object mappingName = nestedMapping.getNestedFeatureType(source);
            if (mappingName != null) {
                if (nestedMapping.isSameSource() && mappingName instanceof Name) {
                    this.setPolymorphicValues((Name)mappingName, target, id, nestedMapping, source, xpath, clientPropsMappings);
                    return;
                }
                if (mappingName instanceof Hints) {
                    this.setPolymorphicReference((Hints)mappingName, clientPropsMappings, target, xpath, targetNodeType);
                    return;
                }
            } else {
                return;
            }
        }
        List<Feature> value = this.getValues(attMapping.isMultiValued(), sourceExpression, source);
        boolean isHRefLink = this.isByReference(clientPropsMappings, isNestedFeature);
        if (isNestedFeature) {
            if (value instanceof Collection) {
                ArrayList<Feature> nestedFeatures = new ArrayList<Feature>(((Collection)value).size());
                for (Object val : (Collection)value) {
                    if (val instanceof Attribute) {
                        if ((val = ((Attribute)val).getValue()) instanceof Collection) {
                            val = ((Collection)val).iterator().next();
                        }
                        while (val instanceof Attribute) {
                            val = ((Attribute)val).getValue();
                        }
                    }
                    if (isHRefLink) {
                        nestedFeatures.addAll(((NestedAttributeMapping)attMapping).getInputFeatures(val, source));
                        continue;
                    }
                    nestedFeatures.addAll(((NestedAttributeMapping)attMapping).getFeatures(val, this.reprojection, source));
                }
                value = nestedFeatures;
            } else {
                value = isHRefLink ? ((NestedAttributeMapping)attMapping).getInputFeatures((Object)value, source) : ((NestedAttributeMapping)attMapping).getFeatures(value, this.reprojection, source);
            }
            if (isHRefLink) {
                this.setXlinkReference(target, clientPropsMappings, value, xpath, targetNodeType);
                return;
            }
        }
        if (isNestedFeature && value == null) {
            return;
        }
        if (value instanceof Collection) {
            Map<Name, Expression> valueProperties = new HashMap();
            for (Object singleVal : (Collection)value) {
                ArrayList valueList = new ArrayList();
                if (singleVal instanceof Attribute && !(valueProperties = this.getClientProperties((Property)((Attribute)singleVal))).isEmpty()) {
                    valueProperties.putAll(clientPropsMappings);
                }
                if (!isNestedFeature) {
                    if (singleVal instanceof Attribute) {
                        if ((singleVal = ((Attribute)singleVal).getValue()) instanceof Collection) {
                            valueList.addAll((Collection)singleVal);
                        } else {
                            valueList.add(singleVal);
                        }
                    }
                } else {
                    valueList.add(singleVal);
                }
                Attribute instance = this.xpathAttributeBuilder.set(target, xpath, valueList, id, targetNodeType, false, sourceExpression);
                this.setClientProperties(instance, source, valueProperties);
            }
        } else {
            if (value instanceof Attribute) {
                Map newClientProps = this.getClientProperties((Property)((Attribute)value));
                if (!newClientProps.isEmpty()) {
                    newClientProps.putAll(clientPropsMappings);
                    clientPropsMappings = newClientProps;
                }
                value = ((Attribute)value).getValue();
            }
            Attribute instance = this.xpathAttributeBuilder.set(target, xpath, value, id, targetNodeType, false, sourceExpression);
            this.setClientProperties(instance, source, clientPropsMappings);
        }
    }

    private void setPolymorphicReference(Hints xlinkHrefHints, Map<Name, Expression> clientPropsMappings, Attribute target, XPath.StepList xpath, AttributeType targetNodeType) {
        Object uri = xlinkHrefHints.get((Object)ComplexFeatureConstants.STRING_KEY);
        if (uri != null) {
            Attribute instance = this.xpathAttributeBuilder.set(target, xpath, null, "", targetNodeType, true, null);
            FilterFactoryImpl ff = new FilterFactoryImpl();
            HashMap<Name, Expression> newClientProps = new HashMap<Name, Expression>();
            newClientProps.putAll(clientPropsMappings);
            newClientProps.put(XLINK_HREF_NAME, (Expression)ff.literal(uri));
            this.setClientProperties(instance, null, newClientProps);
        }
    }

    private void setPolymorphicValues(Name mappingName, Attribute target, String id, NestedAttributeMapping nestedMapping, Feature source, XPath.StepList xpath, Map<Name, Expression> clientPropsMappings) throws IOException {
        DataAccess<FeatureType, Feature> da = DataAccessRegistry.getDataAccess(mappingName);
        if (da instanceof AppSchemaDataAccess) {
            FeatureTypeMapping fTypeMapping = ((AppSchemaDataAccess)da).getMappingByName(mappingName);
            List<AttributeMapping> polymorphicMappings = fTypeMapping.getAttributeMappings();
            AttributeDescriptor attDescriptor = fTypeMapping.getTargetFeature();
            Name polymorphicTypeName = attDescriptor.getName();
            XPath.StepList prefixedXpath = xpath.clone();
            prefixedXpath.add(new XPath.Step(new QName(polymorphicTypeName.getNamespaceURI(), polymorphicTypeName.getLocalPart(), this.namespaces.getPrefix(polymorphicTypeName.getNamespaceURI())), 1));
            Attribute instance = this.xpathAttributeBuilder.set(target, prefixedXpath, null, id, attDescriptor.getType(), false, attDescriptor, null);
            this.setClientProperties(instance, source, clientPropsMappings);
            for (AttributeMapping mapping : polymorphicMappings) {
                if (this.isTopLevelmapping(polymorphicTypeName, mapping.getTargetXPath())) {
                    this.setClientProperties(instance, source, mapping.getClientProperties());
                    continue;
                }
                this.setAttributeValue(instance, source, mapping);
            }
        }
    }

    protected void setXlinkReference(Attribute target, Map<Name, Expression> clientPropsMappings, Object value, XPath.StepList xpath, AttributeType targetNodeType) {
        Property existingAttribute = this.getProperty(target, xpath);
        if (existingAttribute != null) {
            Object existingValue = existingAttribute.getUserData().get(Attributes.class);
            if (existingValue != null) {
                assert (existingValue instanceof HashMap);
                existingValue = ((Map)existingValue).get(XLINK_HREF_NAME);
            }
            if (existingValue != null) {
                Expression linkExpression = clientPropsMappings.get(XLINK_HREF_NAME);
                for (Object singleVal : (Collection)value) {
                    assert (singleVal instanceof Feature);
                    assert (linkExpression != null);
                    Object hrefValue = linkExpression.evaluate(singleVal);
                    if (hrefValue == null || !hrefValue.equals(existingValue)) continue;
                    return;
                }
            }
        }
        for (Object singleVal : (Collection)value) {
            assert (singleVal instanceof Feature);
            Attribute instance = this.xpathAttributeBuilder.set(target, xpath, null, null, targetNodeType, true, null);
            this.setClientProperties(instance, singleVal, clientPropsMappings);
        }
    }

    @Override
    protected void setClientProperties(Attribute target, Object source, Map<Name, Expression> clientProperties) {
        Object geom;
        if (target == null) {
            return;
        }
        HashMap<Name, Expression> targetAttributes = new HashMap<Name, Expression>();
        if (target.getUserData().containsValue(Attributes.class)) {
            targetAttributes.putAll((Map)target.getUserData().get(Attributes.class));
        }
        for (Map.Entry<Name, Expression> entry : clientProperties.entrySet()) {
            Name propName = entry.getKey();
            Expression propExpr = entry.getValue();
            Object propValue = propExpr instanceof Expression ? this.getValue(propExpr, source) : propExpr;
            targetAttributes.put(propName, (Expression)propValue);
        }
        if (targetAttributes.size() > 0) {
            target.getUserData().put(Attributes.class, targetAttributes);
        }
        if (target instanceof GeometryAttribute && (targetAttributes.size() > 0 || target.getIdentifier() != null) && (geom = target.getValue() == null ? new EmptyGeometry() : (Geometry)((Geometry)target.getValue()).clone()) != null) {
            Object userData = geom.getUserData();
            HashMap<Object, Object> newUserData = new HashMap<Object, Object>();
            if (userData != null) {
                if (userData instanceof Map) {
                    newUserData.putAll((Map)userData);
                } else if (userData instanceof CoordinateReferenceSystem) {
                    newUserData.put(CoordinateReferenceSystem.class, userData);
                }
            }
            if (target.getIdentifier() != null) {
                newUserData.put("gml:id", target.getIdentifier().toString());
            }
            if (targetAttributes.size() > 0) {
                newUserData.put(Attributes.class, targetAttributes);
            }
            geom.setUserData(newUserData);
            target.setValue(geom);
        }
    }

    private Map getClientProperties(Property attribute) throws DataSourceException {
        Map props;
        Map userData = attribute.getUserData();
        HashMap clientProperties = new HashMap();
        if (userData != null && userData.containsKey(Attributes.class) && !(props = (Map)userData.get(Attributes.class)).isEmpty()) {
            clientProperties.putAll(props);
        }
        return clientProperties;
    }

    protected void setNextFeature(String fId, ArrayList<Feature> features) throws IOException {
        if (features.isEmpty()) {
            features.add(this.curSrcFeature);
        }
        this.curSrcFeature = null;
        while (this.getSourceFeatureIterator().hasNext()) {
            Feature next = this.getSourceFeatureIterator().next();
            if (this.extractIdForFeature(next).equals(fId)) {
                features.add(next);
                continue;
            }
            this.curSrcFeature = next;
            this.flagNextFeature(true);
            break;
        }
    }

    private void setNextFilteredFeature(String fId, ArrayList<Feature> features) throws IOException {
        FeatureCollection matchingFeatures;
        FeatureId featureId = this.namespaceAwareFilterFactory.featureId(fId);
        Query query = new Query();
        if (this.reprojection != null && this.sourceFeatures.getSchema().getGeometryDescriptor() != null) {
            query.setCoordinateSystemReproject(this.reprojection);
        }
        if (this.mapping.getFeatureIdExpression().equals(Expression.NIL)) {
            HashSet<FeatureId> ids = new HashSet<FeatureId>();
            ids.add(featureId);
            query.setFilter((Filter)this.namespaceAwareFilterFactory.id(ids));
            matchingFeatures = this.mappedSource.getFeatures(query);
        } else {
            query.setFilter((Filter)this.namespaceAwareFilterFactory.equals(this.mapping.getFeatureIdExpression(), (Expression)this.namespaceAwareFilterFactory.literal((Object)fId)));
            matchingFeatures = this.mappedSource.getFeatures(query);
        }
        Iterator iterator = matchingFeatures.iterator();
        while (iterator.hasNext()) {
            features.add((Feature)iterator.next());
        }
        if (features.isEmpty()) {
            features.add(this.curSrcFeature);
        }
        this.filteredFeatures.add(fId);
        matchingFeatures.close(iterator);
        this.curSrcFeature = null;
    }

    @Override
    protected Feature computeNext() throws IOException {
        if (this.curSrcFeature == null) {
            throw new UnsupportedOperationException("No features found in next().This wouldn't have happenned if hasNext() was called beforehand.");
        }
        this.setHasNextCalled(false);
        ArrayList<Feature> sources = new ArrayList<Feature>();
        String id = this.extractIdForFeature(this.curSrcFeature);
        if (this.isFiltered) {
            this.setNextFilteredFeature(id, sources);
        } else {
            this.setNextFeature(id, sources);
        }
        AttributeDescriptor targetNode = this.mapping.getTargetFeature();
        Name targetNodeName = targetNode.getName();
        List<AttributeMapping> mappings = this.mapping.getAttributeMappings();
        AttributeBuilder builder = new AttributeBuilder(this.attf);
        builder.setDescriptor(targetNode);
        Feature target = (Feature)builder.build(id);
        for (AttributeMapping attMapping : mappings) {
            if (this.propertyNames != null && !this.propertyNames.contains(((XPath.Step)attMapping.getTargetXPath().get(0)).getName().getLocalPart())) continue;
            try {
                if (this.isTopLevelmapping(targetNodeName, attMapping.getTargetXPath())) continue;
                if (attMapping.isMultiValued()) {
                    for (Feature source : sources) {
                        this.setAttributeValue((Attribute)target, source, attMapping);
                    }
                    continue;
                }
                this.setAttributeValue((Attribute)target, sources.get(0), attMapping);
            }
            catch (Exception e) {
                throw new RuntimeException("Error applying mapping with targetAttribute " + (Object)((Object)attMapping.getTargetXPath()), e);
            }
        }
        this.cleanEmptyElements(target);
        return target;
    }

    private void cleanEmptyElements(Feature target) throws DataSourceException {
        try {
            ArrayList<Property> values = new ArrayList<Property>();
            for (Property p : target.getValue()) {
                if (!this.hasChild(p) && p.getDescriptor().getMinOccurs() <= 0) continue;
                values.add(p);
            }
            target.setValue(values);
        }
        catch (DataSourceException e) {
            throw new DataSourceException("Unable to clean empty element", (Throwable)e);
        }
    }

    private boolean hasChild(Property p) throws DataSourceException {
        if (p instanceof Feature) {
            return true;
        }
        boolean result = false;
        if (p.getValue() instanceof Collection) {
            Collection c = (Collection)p.getValue();
            if (c.size() == 0 && this.getClientProperties(p).containsKey(XLINK_HREF_NAME)) {
                return true;
            }
            ArrayList values = new ArrayList();
            for (Object o : c) {
                if (!(o instanceof Property)) continue;
                if (this.hasChild((Property)o)) {
                    values.add(o);
                    result = true;
                    continue;
                }
                if (((Property)o).getDescriptor().getMinOccurs() <= 0 || !((Property)o).getDescriptor().isNillable()) continue;
                values.add(o);
            }
            p.setValue(values);
        } else {
            result = true;
        }
        return result;
    }

    private boolean isTopLevelmapping(Name targetNodeName, XPath.StepList targetXPath) {
        XPath.Step rootStep;
        QName stepName;
        return targetXPath.size() == 1 && Types.equals(targetNodeName, stepName = (rootStep = (XPath.Step)targetXPath.get(0)).getName());
    }

    @Override
    protected Feature populateFeatureData(String id) throws IOException {
        throw new UnsupportedOperationException("populateFeatureData should not be called!");
    }

    @Override
    protected void closeSourceFeatures() {
        if (this.sourceFeatures != null && this.getSourceFeatureIterator() != null) {
            this.sourceFeatures.close(this.sourceFeatureIterator);
            this.sourceFeatureIterator = null;
            this.sourceFeatures = null;
            this.filteredFeatures = null;
        }
    }

    @Override
    protected Object getValue(Expression expression, Object sourceFeature) {
        Object value = expression.evaluate(sourceFeature);
        if (value instanceof Attribute) {
            value = ((Attribute)value).getValue();
        }
        return value;
    }

    private Property getProperty(Attribute root, XPath.StepList xpath) {
        Attribute property = root;
        XPath.StepList steps = new XPath.StepList(xpath);
        Iterator stepsIterator = steps.iterator();
        while (stepsIterator.hasNext()) {
            assert (property instanceof ComplexAttribute);
            XPath.Step step = (XPath.Step)stepsIterator.next();
            if ((property = ((ComplexAttribute)property).getProperty(Types.toTypeName(step.getName()))) != null) continue;
            return null;
        }
        return property;
    }

    private Collection<Property> getProperties(ComplexAttribute root, XPath.StepList xpath) {
        XPath.StepList steps = new XPath.StepList(xpath);
        Iterator stepsIterator = steps.iterator();
        Collection properties = null;
        XPath.Step step = null;
        if (stepsIterator.hasNext()) {
            step = (XPath.Step)stepsIterator.next();
            properties = root.getProperties(Types.toTypeName(step.getName()));
        }
        while (stepsIterator.hasNext()) {
            step = (XPath.Step)stepsIterator.next();
            ArrayList nestedProperties = new ArrayList();
            for (Property property : properties) {
                assert (property instanceof ComplexAttribute);
                Collection tempProperties = ((ComplexAttribute)property).getProperties(Types.toTypeName(step.getName()));
                if (tempProperties.isEmpty()) continue;
                nestedProperties.addAll(tempProperties);
            }
            properties.clear();
            if (nestedProperties.isEmpty()) {
                return properties;
            }
            properties.addAll(nestedProperties);
        }
        return properties;
    }

    protected boolean isByReference(Map<Name, Expression> clientPropsMappings, boolean isNested) {
        return isNested ? (clientPropsMappings.isEmpty() ? false : clientPropsMappings.get(XLINK_HREF_NAME) != null) : false;
    }

    public void flagNextFeature(boolean isSet) {
        this.isNextFeatureSet = isSet;
    }

    public boolean isNextFeatureSet() {
        return this.isNextFeatureSet;
    }
}

