/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import org.apache.commons.collections.IteratorUtils;
import org.geotools.data.Query;
import org.geotools.data.complex.AppSchemaDataAccess;
import org.geotools.data.complex.DataAccessMappingFeatureIterator;
import org.geotools.data.complex.FeatureTypeMapping;
import org.opengis.feature.Feature;
import org.opengis.filter.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteringMappingFeatureIterator
extends DataAccessMappingFeatureIterator {
    protected ListIterator<Feature> listFeatureIterator;
    private Filter filter;

    public FilteringMappingFeatureIterator(AppSchemaDataAccess store, FeatureTypeMapping mapping, Query query, Filter filter) throws IOException {
        super(store, mapping, query, false, true);
        this.filter = filter;
    }

    @Override
    protected void initialiseSourceFeatures(FeatureTypeMapping mapping, Query query) throws IOException {
        super.initialiseSourceFeatures(mapping, query);
        this.listFeatureIterator = IteratorUtils.toListIterator(super.getSourceFeatureIterator());
    }

    @Override
    protected void closeSourceFeatures() {
        super.closeSourceFeatures();
        this.listFeatureIterator = null;
    }

    @Override
    protected Iterator<Feature> getSourceFeatureIterator() {
        return this.listFeatureIterator;
    }

    @Override
    public boolean hasNext() {
        while (super.hasNext()) {
            if (!this.filter.evaluate((Object)this.curSrcFeature)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void setNextFeature(String fId, ArrayList<Feature> features) throws IOException {
        int prevCount = 0;
        while (this.listFeatureIterator.hasPrevious()) {
            Feature prev = this.listFeatureIterator.previous();
            ++prevCount;
            if (!this.extractIdForFeature(prev).equals(fId)) break;
            features.add(prev);
        }
        for (int i = 0; i < prevCount; ++i) {
            this.listFeatureIterator.next();
        }
        super.setNextFeature(fId, features);
    }
}

