/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.geotools.feature.NameImpl;
import org.geotools.feature.type.AttributeTypeImpl;
import org.opengis.feature.Attribute;
import org.opengis.feature.ComplexAttribute;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.ComplexType;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.feature.type.PropertyType;
import org.opengis.filter.Filter;
import org.opengis.filter.identity.Identifier;
import org.xml.sax.helpers.NamespaceSupport;

public class Types {
    public static Name[] names(ComplexType type) {
        ArrayList<Name> names = new ArrayList<Name>();
        for (AttributeDescriptor ad : type.getDescriptors()) {
            names.add(ad.getName());
        }
        return names.toArray(new Name[names.size()]);
    }

    public static Name typeName(String name) {
        if (name == null) {
            return null;
        }
        return new NameImpl(name);
    }

    public static Name typeName(String namespace, String name) {
        return new NameImpl(namespace, name);
    }

    public static Name typeName(Name name) {
        return new NameImpl(name.getNamespaceURI(), name.getLocalPart());
    }

    public static Name[] toNames(String[] names) {
        if (names == null) {
            return null;
        }
        Name[] attributeNames = new Name[names.length];
        for (int i = 0; i < names.length; ++i) {
            attributeNames[i] = Types.typeName(names[i]);
        }
        return attributeNames;
    }

    public static Name[] toTypeNames(String[] names) {
        if (names == null) {
            return null;
        }
        Name[] typeNames = new Name[names.length];
        for (int i = 0; i < names.length; ++i) {
            typeNames[i] = Types.typeName(names[i]);
        }
        return typeNames;
    }

    public static String[] fromNames(Name[] attributeNames) {
        if (attributeNames == null) {
            return null;
        }
        String[] names = new String[attributeNames.length];
        for (int i = 0; i < attributeNames.length; ++i) {
            names[i] = attributeNames[i].getLocalPart();
        }
        return names;
    }

    public static String[] fromTypeNames(Name[] typeNames) {
        if (typeNames == null) {
            return null;
        }
        String[] names = new String[typeNames.length];
        for (int i = 0; i < typeNames.length; ++i) {
            names[i] = typeNames[i].getLocalPart();
        }
        return names;
    }

    public static PropertyDescriptor descriptor(ComplexType type, String name) {
        List match = Types.descriptors(type, name);
        if (match.isEmpty()) {
            return null;
        }
        return (PropertyDescriptor)match.get(0);
    }

    public static PropertyDescriptor descriptor(ComplexType type, String name, AttributeType actualType) {
        List match = Types.descriptors(type, name);
        if (match.isEmpty()) {
            Collection properties = type.getDescriptors();
            for (PropertyDescriptor desc : properties) {
                AttributeDescriptor attDesc;
                AttributeType attType;
                if (!(desc instanceof AttributeDescriptor) || !Types.isSuperType((PropertyType)actualType, (PropertyType)(attType = (attDesc = (AttributeDescriptor)desc).getType()))) continue;
                return attDesc;
            }
            return null;
        }
        return (PropertyDescriptor)match.get(0);
    }

    public static PropertyDescriptor descriptor(ComplexType type, Name name, AttributeType actualType) {
        List match = Types.descriptors(type, name);
        if (match.isEmpty()) {
            Collection properties = type.getDescriptors();
            for (PropertyDescriptor desc : properties) {
                AttributeDescriptor attDesc;
                AttributeType attType;
                if (!(desc instanceof AttributeDescriptor) || !Types.isSuperType((PropertyType)actualType, (PropertyType)(attType = (attDesc = (AttributeDescriptor)desc).getType()))) continue;
                return attDesc;
            }
            return null;
        }
        return (PropertyDescriptor)match.get(0);
    }

    public static PropertyDescriptor descriptor(ComplexType type, String name, String namespace) {
        return Types.descriptor(type, (Name)new NameImpl(namespace, name));
    }

    public static PropertyDescriptor descriptor(ComplexType type, Name name) {
        List match = Types.descriptors(type, name);
        if (match.isEmpty()) {
            return null;
        }
        return (PropertyDescriptor)match.get(0);
    }

    public static List descriptors(ComplexType type, String name) {
        AttributeType superType;
        if (name == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<PropertyDescriptor> match = new ArrayList<PropertyDescriptor>();
        for (PropertyDescriptor descriptor : type.getDescriptors()) {
            String localPart = descriptor.getName().getLocalPart();
            if (!name.equals(localPart)) continue;
            match.add(descriptor);
        }
        if (match.size() == 0 && (superType = type.getSuper()) instanceof ComplexType) {
            List superDescriptors = Types.descriptors((ComplexType)superType, name);
            match.addAll(superDescriptors);
        }
        return match;
    }

    public static List descriptors(ComplexType type, Name name) {
        AttributeType superType;
        if (name == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<PropertyDescriptor> match = new ArrayList<PropertyDescriptor>();
        for (PropertyDescriptor descriptor : type.getDescriptors()) {
            Name descriptorName = descriptor.getName();
            if (!name.equals(descriptorName)) continue;
            match.add(descriptor);
        }
        if (match.size() == 0 && (superType = type.getSuper()) instanceof ComplexType) {
            List superDescriptors = Types.descriptors((ComplexType)superType, name);
            match.addAll(superDescriptors);
        }
        return match;
    }

    public static boolean isSuperType(PropertyType type, PropertyType parent) {
        while (type.getSuper() != null) {
            if (!(type = type.getSuper()).equals(parent)) continue;
            return true;
        }
        return false;
    }

    public static Object parse(AttributeType type, Object content) throws IllegalArgumentException {
        AttributeTypeImpl hack;
        Object parsed;
        if (type instanceof AttributeTypeImpl && (parsed = (hack = (AttributeTypeImpl)type).parse(content)) != null) {
            return parsed;
        }
        return content;
    }

    public static void validate(Attribute attribute) throws IllegalAttributeException {
        Types.validate(attribute, attribute.getValue());
    }

    public static void validate(Attribute attribute, Object attributeContent) throws IllegalAttributeException {
        Types.validate(attribute.getType(), attribute, attributeContent, false);
    }

    public static void validate(AttributeType type, Attribute attribute, Object attributeContent) throws IllegalAttributeException {
        Types.validate(type, attribute, attributeContent, false);
    }

    protected static void validate(AttributeType type, Attribute attribute, Object attributeContent, boolean isSuper) throws IllegalAttributeException {
        if (type == null) {
            throw new IllegalAttributeException(attribute.getDescriptor(), (Object)"null type");
        }
        if (attributeContent == null) {
            if (!attribute.isNillable()) {
                throw new IllegalAttributeException(attribute.getDescriptor(), (Object)(type.getName() + " not nillable"));
            }
            return;
        }
        if (type.isIdentified() && attribute.getIdentifier() == null) {
            throw new NullPointerException(type.getName() + " is identified, null id not accepted");
        }
        if (!isSuper) {
            Class<?> clazz = attributeContent.getClass();
            Class binding = type.getBinding();
            if (binding != null && !binding.isAssignableFrom(clazz)) {
                throw new IllegalAttributeException(attribute.getDescriptor(), (Object)(clazz.getName() + " is not an acceptable class for " + type.getName() + " as it is not assignable from " + binding));
            }
        }
        if (type.getRestrictions() != null && type.getRestrictions().size() > 0) {
            final Attribute fatt = attribute;
            Attribute fake = new Attribute(){
                private Map<Object, Object> userData = new HashMap<Object, Object>();

                public AttributeDescriptor getDescriptor() {
                    return fatt.getDescriptor();
                }

                public PropertyDescriptor descriptor() {
                    return fatt.getDescriptor();
                }

                public Name name() {
                    return fatt.getName();
                }

                public AttributeType getType() {
                    return fatt.getType();
                }

                public boolean isNillable() {
                    return fatt.isNillable();
                }

                public Identifier getIdentifier() {
                    return fatt.getIdentifier();
                }

                public Object getValue() {
                    return fatt.getValue();
                }

                public void setValue(Object newValue) throws IllegalArgumentException {
                    throw new UnsupportedOperationException("Modification is not supported");
                }

                public Object operation(Name arg0, List arg1) {
                    throw new UnsupportedOperationException("Operation is not supported");
                }

                public Name getName() {
                    return null;
                }

                public Map<Object, Object> getUserData() {
                    return this.userData;
                }

                public void validate() throws IllegalAttributeException {
                }
            };
            for (Filter f : type.getRestrictions()) {
                if (f.evaluate((Object)fake)) continue;
                throw new IllegalAttributeException(attribute.getDescriptor(), (Object)("Attribute instance (" + fake.getIdentifier().toString() + ")" + "fails to pass filter: " + f));
            }
        }
        if (type.getSuper() != null) {
            Types.validate(type.getSuper(), attribute, attributeContent, true);
        }
    }

    public static void validate(ComplexAttribute attribute) throws IllegalArgumentException {
    }

    public static void validate(ComplexAttribute attribute, Collection content) throws IllegalArgumentException {
    }

    protected static void validate(ComplexType type, ComplexAttribute attribute, Collection content) throws IllegalAttributeException {
        Types.validate((AttributeType)type, (Attribute)attribute, content, false);
        if (content == null) {
            return;
        }
        Collection schema = type.getDescriptors();
        int index = 0;
        for (Attribute att : content) {
            if (att == null) {
                throw new NullPointerException("Attribute at index " + index + " is null. Attributes " + "can't be null. Do you mean Attribute.get() == null?");
            }
            AttributeType attType = att.getType();
            boolean contains = false;
            for (AttributeDescriptor ad : schema) {
                if (!ad.getType().equals(attType)) continue;
                contains = true;
                break;
            }
            if (!contains) {
                throw new IllegalArgumentException("Attribute of type " + attType.getName() + " found at index " + index + " but this type is not allowed by this descriptor");
            }
            ++index;
        }
        if (type.getDescriptors().isEmpty()) {
            if (!content.isEmpty()) {
                throw new IllegalAttributeException(attribute.getDescriptor(), (Object)"Type indicates empty attribute collection, content does not");
            }
            return;
        }
        Types.validateAll(type, attribute, content);
        if (type.getSuper() != null) {
            Types.validate((ComplexType)type.getSuper(), attribute, content);
        }
    }

    private static void validateAll(ComplexType type, ComplexAttribute att, Collection content) throws IllegalAttributeException {
        Types.processAll(type.getDescriptors(), content);
    }

    private static void processAll(Collection all, Collection content) throws IllegalAttributeException {
        ArrayList remaining = new ArrayList(content);
        for (AttributeDescriptor ad : all) {
            int min = ad.getMinOccurs();
            int max = ad.getMaxOccurs();
            int occurences = 0;
            Iterator citr = remaining.iterator();
            while (citr.hasNext()) {
                Attribute a = (Attribute)citr.next();
                if (!a.getName().equals(ad.getName())) continue;
                ++occurences;
                citr.remove();
            }
            if (occurences >= ad.getMinOccurs() && occurences <= ad.getMaxOccurs()) continue;
            throw new IllegalAttributeException(ad, (Object)("Found " + occurences + " of " + ad.getName() + " when type" + "specifies between " + min + " and " + max));
        }
        if (!remaining.isEmpty()) {
            throw new IllegalAttributeException((AttributeDescriptor)remaining.iterator().next(), (Object)("Extra content found beyond the specified in the schema: " + remaining));
        }
    }

    public static QName toQName(Name featurePath) {
        return Types.toQName(featurePath, null);
    }

    public static QName toQName(Name featurePath, NamespaceSupport ns) {
        QName qName;
        if (featurePath == null) {
            return null;
        }
        String namespace = featurePath.getNamespaceURI();
        String localName = featurePath.getLocalPart();
        if (null == namespace) {
            qName = new QName(localName);
        } else {
            String prefix;
            if (ns != null && (prefix = ns.getPrefix(namespace)) != null) {
                QName qName2 = new QName(namespace, localName, prefix);
                return qName2;
            }
            qName = new QName(namespace, localName);
        }
        return qName;
    }

    public static Name toName(QName name) {
        return Types.toTypeName(name);
    }

    public static Name toTypeName(QName name) {
        if ("".equals(name.getNamespaceURI())) {
            return Types.typeName(name.getLocalPart());
        }
        return Types.typeName(name.getNamespaceURI(), name.getLocalPart());
    }

    public static boolean equals(Name name, QName qName) {
        if (name == null && qName != null) {
            return false;
        }
        if (qName == null && name != null) {
            return false;
        }
        if ("".equals(qName.getNamespaceURI())) {
            if (null != name.getNamespaceURI()) {
                return false;
            }
            return name.getLocalPart().equals(qName.getLocalPart());
        }
        if (null == name.getNamespaceURI() && !"".equals(qName.getNamespaceURI())) {
            return false;
        }
        return name.getNamespaceURI().equals(qName.getNamespaceURI()) && name.getLocalPart().equals(qName.getLocalPart());
    }

    public static Name degloseName(String prefixedName, NamespaceSupport namespaces) throws IllegalArgumentException {
        Name name = null;
        if (prefixedName == null) {
            return null;
        }
        int prefixIdx = prefixedName.indexOf(58);
        if (prefixIdx == -1) {
            return Types.typeName(prefixedName);
        }
        String nsPrefix = prefixedName.substring(0, prefixIdx);
        String localName = prefixedName.substring(prefixIdx + 1);
        String nsUri = namespaces.getURI(nsPrefix);
        if (nsUri == null) {
            throw new IllegalArgumentException("No namespace set: The namespace has not been declared in the app-schema mapping file for name: " + nsPrefix + ":" + localName + " [Check the Namespaces section in the config file] ");
        }
        name = Types.typeName(nsUri, localName);
        return name;
    }
}

