/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex.config;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDTypeDefinition;
import org.geotools.data.complex.config.EmfAppSchemaReader;
import org.geotools.data.complex.config.FeatureTypeRegistry;
import org.geotools.feature.Types;
import org.geotools.feature.type.ComplexFeatureTypeImpl;
import org.geotools.gml3.GML;
import org.geotools.xml.SchemaIndex;
import org.geotools.xs.XS;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.ComplexType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;

public class EmfAppSchemaReaderTest
extends TestCase {
    private static final String NS_URI = "http://online.socialchange.net.au";
    private EmfAppSchemaReader schemaLoader;

    protected void setUp() throws Exception {
        super.setUp();
        this.schemaLoader = EmfAppSchemaReader.newInstance();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.schemaLoader = null;
    }

    public void testParseSimpleFeatureType() throws Exception {
        String res = "/test-data/simpleFeature.xsd";
        URL resource = ((Object)((Object)this)).getClass().getResource(res);
        SchemaIndex schemaIndex = this.schemaLoader.parse(resource, null);
        FeatureTypeRegistry parsedTypes = new FeatureTypeRegistry();
        parsedTypes.addSchemas(schemaIndex);
        Name typeName = Types.typeName((String)NS_URI, (String)"simpleFeatureType");
        AttributeType type = parsedTypes.getAttributeType(typeName);
        EmfAppSchemaReaderTest.assertNotNull((Object)type);
        EmfAppSchemaReaderTest.assertTrue((String)type.getClass().getName(), (boolean)(type instanceof ComplexType));
        EmfAppSchemaReaderTest.assertTrue((boolean)(type.getUserData().get(XSDTypeDefinition.class) instanceof XSDComplexTypeDefinition));
        ComplexType ft = (ComplexType)type;
        String local = ft.getName().getLocalPart();
        String uri = ft.getName().getNamespaceURI();
        EmfAppSchemaReaderTest.assertEquals((String)"simpleFeatureType", (String)local);
        EmfAppSchemaReaderTest.assertEquals((String)NS_URI, (String)uri);
        List<Object> attributes = Arrays.asList(((ComplexFeatureTypeImpl)ft).getTypeDescriptors().toArray());
        EmfAppSchemaReaderTest.assertEquals((int)8, (int)attributes.size());
        AttributeDescriptor descriptor = (AttributeDescriptor)attributes.get(5);
        Name name = Types.typeName((String)NS_URI, (String)"the_geom");
        typeName = Types.typeName((String)"http://www.opengis.net/gml", (String)"GeometryPropertyType");
        this.assertSimpleAttribute(descriptor, name, typeName, Geometry.class, 1, 1);
        descriptor = (AttributeDescriptor)attributes.get(6);
        name = Types.typeName((String)NS_URI, (String)"stringAtt");
        typeName = Types.typeName((String)"http://www.w3.org/2001/XMLSchema", (String)XS.STRING.getLocalPart());
        this.assertSimpleAttribute(descriptor, name, typeName, String.class, 1, 1);
        descriptor = (AttributeDescriptor)attributes.get(7);
        name = Types.typeName((String)NS_URI, (String)"intAtt");
        typeName = Types.typeName((String)"http://www.w3.org/2001/XMLSchema", (String)XS.INT.getLocalPart());
        this.assertSimpleAttribute(descriptor, name, typeName, Integer.class, 1, 1);
    }

    private void assertSimpleAttribute(AttributeDescriptor descriptor, Name name, Name typeName, Class binding, int minOccurs, int maxOccurs) {
        EmfAppSchemaReaderTest.assertEquals((Object)name, (Object)descriptor.getName());
        EmfAppSchemaReaderTest.assertEquals((int)minOccurs, (int)descriptor.getMinOccurs());
        EmfAppSchemaReaderTest.assertEquals((int)maxOccurs, (int)descriptor.getMaxOccurs());
        EmfAppSchemaReaderTest.assertTrue((boolean)(descriptor.getUserData().get(XSDElementDeclaration.class) instanceof XSDElementDeclaration));
        AttributeType type = descriptor.getType();
        EmfAppSchemaReaderTest.assertNotNull((Object)type);
        EmfAppSchemaReaderTest.assertFalse((boolean)(type instanceof ComplexType));
        EmfAppSchemaReaderTest.assertEquals((Object)typeName, (Object)type.getName());
        EmfAppSchemaReaderTest.assertEquals((Object)binding, (Object)type.getBinding());
    }

    public void testComplexFeatureType() throws Exception {
        String res = "/test-data/complexFeature.xsd";
        URL resource = ((Object)((Object)this)).getClass().getResource(res);
        SchemaIndex schemaIndex = this.schemaLoader.parse(resource, null);
        FeatureTypeRegistry typeRegistry = new FeatureTypeRegistry();
        typeRegistry.addSchemas(schemaIndex);
        Name typeName = Types.typeName((String)NS_URI, (String)"wq_plus_Type");
        AttributeType type = typeRegistry.getAttributeType(typeName);
        EmfAppSchemaReaderTest.assertTrue((boolean)(type instanceof FeatureType));
        EmfAppSchemaReaderTest.assertFalse((boolean)(type instanceof SimpleFeatureType));
        EmfAppSchemaReaderTest.assertEquals((Object)typeName, (Object)type.getName());
        EmfAppSchemaReaderTest.assertTrue((boolean)(type.getUserData().get(XSDTypeDefinition.class) instanceof XSDComplexTypeDefinition));
        FeatureType wq_plus_Type = (FeatureType)type;
        EmfAppSchemaReaderTest.assertNotNull((Object)wq_plus_Type.getSuper());
        typeName = Types.typeName((String)"http://www.opengis.net/gml", (String)GML.AbstractFeatureType.getLocalPart());
        EmfAppSchemaReaderTest.assertEquals((Object)typeName, (Object)wq_plus_Type.getSuper().getName());
        EmfAppSchemaReaderTest.assertNotNull((Object)wq_plus_Type.getDescriptors());
        EmfAppSchemaReaderTest.assertEquals((int)8, (int)((ComplexFeatureTypeImpl)wq_plus_Type).getTypeDescriptors().size());
        Name name = Types.typeName((String)NS_URI, (String)"wq_plus");
        AttributeDescriptor wqPlusDescriptor = typeRegistry.getDescriptor(name);
        EmfAppSchemaReaderTest.assertNotNull((Object)wqPlusDescriptor);
        EmfAppSchemaReaderTest.assertEquals((Object)name, (Object)wqPlusDescriptor.getName());
        EmfAppSchemaReaderTest.assertSame((Object)wq_plus_Type, (Object)wqPlusDescriptor.getType());
        EmfAppSchemaReaderTest.assertTrue((boolean)(wqPlusDescriptor.getUserData().get(XSDElementDeclaration.class) instanceof XSDElementDeclaration));
        typeName = Types.typeName((String)NS_URI, (String)"measurementType");
        type = typeRegistry.getAttributeType(typeName);
        EmfAppSchemaReaderTest.assertTrue((boolean)(type instanceof ComplexType));
        EmfAppSchemaReaderTest.assertFalse((boolean)(type instanceof FeatureType));
        EmfAppSchemaReaderTest.assertTrue((boolean)(type.getUserData().get(XSDTypeDefinition.class) instanceof XSDComplexTypeDefinition));
        ComplexType measurementType = (ComplexType)type;
        EmfAppSchemaReaderTest.assertEquals((Object)typeName, (Object)measurementType.getName());
        EmfAppSchemaReaderTest.assertTrue((boolean)measurementType.isIdentified());
        EmfAppSchemaReaderTest.assertFalse((boolean)measurementType.isAbstract());
        EmfAppSchemaReaderTest.assertEquals((int)2, (int)measurementType.getDescriptors().size());
        name = Types.typeName((String)NS_URI, (String)"measurement");
        AttributeDescriptor descriptor = (AttributeDescriptor)Types.descriptor((ComplexType)wq_plus_Type, (Name)name);
        EmfAppSchemaReaderTest.assertNotNull((Object)descriptor);
        EmfAppSchemaReaderTest.assertEquals((Object)name, (Object)descriptor.getName());
        EmfAppSchemaReaderTest.assertNotNull((Object)descriptor.getType());
        EmfAppSchemaReaderTest.assertSame((Object)measurementType, (Object)descriptor.getType());
        EmfAppSchemaReaderTest.assertEquals((int)0, (int)descriptor.getMinOccurs());
        EmfAppSchemaReaderTest.assertEquals((int)Integer.MAX_VALUE, (int)descriptor.getMaxOccurs());
        EmfAppSchemaReaderTest.assertTrue((boolean)(descriptor.getUserData().get(XSDElementDeclaration.class) instanceof XSDElementDeclaration));
        name = Types.typeName((String)NS_URI, (String)"result");
        descriptor = (AttributeDescriptor)Types.descriptor((ComplexType)measurementType, (Name)name);
        typeName = Types.typeName((String)"http://www.w3.org/2001/XMLSchema", (String)XS.FLOAT.getLocalPart());
        this.assertSimpleAttribute(descriptor, name, typeName, Float.class, 1, 1);
        name = Types.typeName((String)NS_URI, (String)"determinand_description");
        descriptor = (AttributeDescriptor)Types.descriptor((ComplexType)measurementType, (Name)name);
        typeName = Types.typeName((String)"http://www.w3.org/2001/XMLSchema", (String)XS.STRING.getLocalPart());
        this.assertSimpleAttribute(descriptor, name, typeName, String.class, 1, 1);
        name = Types.typeName((String)NS_URI, (String)"the_geom");
        descriptor = (AttributeDescriptor)Types.descriptor((ComplexType)wq_plus_Type, (Name)name);
        typeName = Types.typeName((String)"http://www.opengis.net/gml", (String)GML.PointPropertyType.getLocalPart());
        this.assertSimpleAttribute(descriptor, name, typeName, Point.class, 1, 1);
        name = Types.typeName((String)NS_URI, (String)"sitename");
        descriptor = (AttributeDescriptor)Types.descriptor((ComplexType)wq_plus_Type, (Name)name);
        typeName = Types.typeName((String)"http://www.w3.org/2001/XMLSchema", (String)XS.STRING.getLocalPart());
        this.assertSimpleAttribute(descriptor, name, typeName, String.class, 1, Integer.MAX_VALUE);
    }

    public void testSimpleAttributeFromComplexDeclaration() throws Exception {
        String res = "/test-data/complexFeature.xsd";
        URL resource = ((Object)((Object)this)).getClass().getResource(res);
        SchemaIndex schemaIndex = this.schemaLoader.parse(resource, null);
        FeatureTypeRegistry registry = new FeatureTypeRegistry();
        registry.addSchemas(schemaIndex);
        Name tcl = Types.typeName((String)NS_URI, (String)"TypedCategoryListType");
        AttributeType typedCategoryListType = registry.getAttributeType(tcl);
        EmfAppSchemaReaderTest.assertNotNull((Object)typedCategoryListType);
        EmfAppSchemaReaderTest.assertTrue((boolean)(typedCategoryListType instanceof ComplexType));
        AttributeType superType = typedCategoryListType.getSuper();
        EmfAppSchemaReaderTest.assertNotNull((Object)superType);
        Name superName = superType.getName();
        EmfAppSchemaReaderTest.assertEquals((String)XS.STRING.getNamespaceURI(), (String)superName.getNamespaceURI());
        EmfAppSchemaReaderTest.assertEquals((String)XS.STRING.getLocalPart(), (String)superName.getLocalPart());
        EmfAppSchemaReaderTest.assertNotNull(typedCategoryListType.getUserData().get(XSDTypeDefinition.class));
    }
}

