/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import org.geotools.data.DataAccess;
import org.geotools.data.DataAccessFinder;
import org.geotools.data.FeatureSource;
import org.geotools.data.complex.DataAccessRegistry;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.Types;
import org.geotools.filter.FilterFactoryImpl;
import org.geotools.filter.FilterFactoryImplNamespaceAware;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.spatial.BBOX;
import org.xml.sax.helpers.NamespaceSupport;

public class BBoxTest {
    private static FilterFactoryImpl ff;
    private static DataAccess<FeatureType, Feature> dataAccess;
    private static FeatureSource<FeatureType, Feature> fSource;

    @BeforeClass
    public static void setUp() throws Exception {
        String GSML_URI = "http://www.cgi-iugs.org/xml/GeoSciML/2";
        NamespaceSupport namespaces = new NamespaceSupport();
        namespaces.declarePrefix("gsml", "http://www.cgi-iugs.org/xml/GeoSciML/2");
        namespaces.declarePrefix("gml", "http://www.opengis.net/gml");
        ff = new FilterFactoryImplNamespaceAware(namespaces);
        Name FEATURE_TYPE = Types.typeName((String)"http://www.cgi-iugs.org/xml/GeoSciML/2", (String)"MappedFeature");
        String schemaBase = "/test-data/";
        HashMap<String, String> dsParams = new HashMap<String, String>();
        dsParams.put("dbtype", "app-schema");
        URL url = BBoxTest.class.getResource("/test-data/MappedFeatureAsOccurrence.xml");
        Assert.assertNotNull((Object)url);
        dsParams.put("url", url.toExternalForm());
        dataAccess = DataAccessFinder.getDataStore(dsParams);
        fSource = dataAccess.getFeatureSource(FEATURE_TYPE);
    }

    @AfterClass
    public static void tearDown() {
        DataAccessRegistry.unregisterAll();
    }

    @Test
    public void testBBoxWithPropertyName() throws Exception {
        BBOX filter = ff.bbox((Expression)ff.property("gsml:shape"), -1.1, 52.5, -1.1, 52.6, null);
        FeatureCollection features = fSource.getFeatures((Filter)filter);
        Assert.assertEquals((long)features.size(), (long)2L);
        Iterator iterator = features.iterator();
        Feature f = (Feature)iterator.next();
        Assert.assertEquals((Object)f.getIdentifier().toString(), (Object)"mf1");
        f = (Feature)iterator.next();
        Assert.assertEquals((Object)f.getIdentifier().toString(), (Object)"mf3");
        filter = ff.bbox((Expression)ff.property("gml:name[1]"), -1.2, 52.5, -1.1, 52.6, null);
        features = fSource.getFeatures((Filter)filter);
        Assert.assertEquals((long)features.size(), (long)0L);
    }

    @Test
    public void testBBoxWithNoPropertyName() throws IOException {
        BBOX filter = ff.bbox((Expression)ff.property(""), -1.1, 52.5, -1.1, 52.6, null);
        FeatureCollection features = fSource.getFeatures((Filter)filter);
        Assert.assertEquals((long)features.size(), (long)2L);
        Iterator iterator = features.iterator();
        Feature f = (Feature)iterator.next();
        Assert.assertEquals((Object)f.getIdentifier().toString(), (Object)"mf1");
        f = (Feature)iterator.next();
        Assert.assertEquals((Object)f.getIdentifier().toString(), (Object)"mf3");
    }
}

