/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.session;

import com.esri.sde.sdk.client.SeConnection;
import com.esri.sde.sdk.client.SeException;
import com.esri.sde.sdk.client.SeVersion;
import java.io.IOException;
import java.util.ArrayList;
import org.geotools.arcsde.ArcSdeException;
import org.geotools.arcsde.session.Command;
import org.geotools.arcsde.session.ISession;

public class Commands {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class GetVersionCommand
    extends Command<SeVersion> {
        private String versionName;

        public GetVersionCommand(String versionName) {
            this.versionName = versionName;
        }

        @Override
        public SeVersion execute(ISession session, SeConnection connection) throws SeException, IOException {
            SeVersion version;
            try {
                version = new SeVersion(connection, this.versionName);
            }
            catch (SeException cause) {
                if (cause.getSeError().getSdeError() == -126) {
                    ArrayList<String> available = new ArrayList<String>();
                    try {
                        SeVersion[] versionList;
                        for (SeVersion v : versionList = connection.getVersionList(null)) {
                            available.add(v.getName());
                        }
                        throw new ArcSdeException("Specified ArcSDE version does not exist: " + this.versionName + ". Available versions are: " + available, cause);
                    }
                    catch (SeException ignorable) {
                        throw new ArcSdeException("Specified ArcSDE version does not exist: " + this.versionName, cause);
                    }
                }
                throw cause;
            }
            version.getInfo();
            return version;
        }
    }
}

