/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.gce;

import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageInputStreamImpl;
import org.geotools.arcsde.gce.TileReader;

final class ArcSDETiledImageInputStream
extends ImageInputStreamImpl
implements ImageInputStream {
    private final TileReader tileReader;
    private final int tileDataLength;
    private final byte[] currTileData;
    private int currTileDataIndex;

    public ArcSDETiledImageInputStream(TileReader tileReader) {
        int bytesPerTile;
        this.tileReader = tileReader;
        this.tileDataLength = bytesPerTile = tileReader.getBytesPerTile();
        this.currTileData = new byte[bytesPerTile];
        this.currTileDataIndex = this.tileDataLength;
    }

    public long length() {
        int bytesPerTile = this.tileReader.getBytesPerTile();
        int tilesWide = this.tileReader.getTilesWide();
        int tilesHigh = this.tileReader.getTilesHigh();
        int numberOfBands = this.tileReader.getNumberOfBands();
        int length = bytesPerTile * tilesWide * tilesHigh * numberOfBands;
        return length;
    }

    public int read() throws IOException {
        byte[] data = this.getTileData();
        if (data == null) {
            return -1;
        }
        byte b = data[this.currTileDataIndex];
        ++this.currTileDataIndex;
        return b;
    }

    public int read(byte[] buff, int off, int len) throws IOException {
        byte[] data = this.getTileData();
        if (data == null) {
            return -1;
        }
        int available = data.length - this.currTileDataIndex;
        int count = Math.min(available, len);
        System.arraycopy(data, this.currTileDataIndex, buff, off, count);
        this.currTileDataIndex += count;
        return count;
    }

    private byte[] getTileData() throws IOException {
        if (this.currTileDataIndex == this.tileDataLength) {
            if (!this.tileReader.hasNext()) {
                return null;
            }
            this.currTileDataIndex = 0;
            this.tileReader.next(this.currTileData);
        }
        return this.currTileData;
    }

    public void close() throws IOException {
        super.close();
    }
}

