/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.builder;

import org.geotools.Builder;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.styling.RemoteOWS;
import org.geotools.styling.StyleFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteOWSBuilder<P>
implements Builder<RemoteOWS> {
    private StyleFactory sf = CommonFactoryFinder.getStyleFactory(null);
    private P parent;
    boolean unset = true;
    private String service;
    private String onlineResource;

    public RemoteOWSBuilder() {
        this(null);
    }

    public RemoteOWSBuilder(P parent) {
        this.parent = parent;
        this.reset();
    }

    public String resource() {
        return this.onlineResource;
    }

    public RemoteOWSBuilder<P> resource(String onlineResource) {
        this.onlineResource = onlineResource;
        this.unset = false;
        return this;
    }

    public String service() {
        return this.service;
    }

    public RemoteOWSBuilder<P> service(String service) {
        this.service = service;
        this.unset = false;
        return this;
    }

    @Override
    public RemoteOWS build() {
        if (this.unset) {
            return null;
        }
        RemoteOWS remote = this.sf.createRemoteOWS(this.service, this.onlineResource);
        return remote;
    }

    public P end() {
        return this.parent;
    }

    @Override
    public RemoteOWSBuilder<P> reset() {
        this.unset = true;
        this.onlineResource = null;
        this.service = null;
        return this;
    }

    @Override
    public RemoteOWSBuilder<P> reset(RemoteOWS remote) {
        if (remote == null) {
            return this.reset();
        }
        this.onlineResource = remote.getOnlineResource();
        this.service = remote.getService();
        this.unset = false;
        return this;
    }

    @Override
    public RemoteOWSBuilder<P> unset() {
        this.unset = true;
        this.onlineResource = null;
        this.service = null;
        return this;
    }
}

