/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.builder;

import java.util.ArrayList;
import java.util.List;
import org.geotools.Builder;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.SubFilterBuilder;
import org.geotools.styling.Rule;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.builder.LineSymbolizerBuilder;
import org.geotools.styling.builder.PointSymbolizerBuilder;
import org.geotools.styling.builder.PolygonSymbolizerBuilder;
import org.opengis.filter.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleBuilder<P>
implements Builder<Rule> {
    StyleFactory sf = CommonFactoryFinder.getStyleFactory(null);
    P parent;
    List<Symbolizer> symbolizers = new ArrayList<Symbolizer>();
    Builder<? extends Symbolizer> symbolizerBuilder;
    String name;
    String ruleAbstract;
    double minScaleDenominator;
    double maxScaleDenominator;
    SubFilterBuilder<RuleBuilder<P>> filter = new SubFilterBuilder<RuleBuilder>(this);
    boolean elseFilter;
    String title;
    private boolean unset = false;

    public RuleBuilder() {
        this(null);
    }

    public RuleBuilder(P parent) {
        this.parent = parent;
        this.reset();
    }

    public RuleBuilder<P> name(String name) {
        this.unset = false;
        this.name = name;
        return this;
    }

    public RuleBuilder<P> title(String title) {
        this.unset = false;
        this.title = title;
        return this;
    }

    public RuleBuilder<P> ruleAbstract(String ruleAbstract) {
        this.unset = false;
        this.ruleAbstract = ruleAbstract;
        return this;
    }

    public RuleBuilder<P> min(double minScaleDenominator) {
        this.unset = false;
        if (minScaleDenominator < 0.0) {
            throw new IllegalArgumentException("Invalid min scale denominator, should be positive or 0");
        }
        this.minScaleDenominator = minScaleDenominator;
        return this;
    }

    public RuleBuilder<P> max(double maxScaleDenominator) {
        this.unset = false;
        if (maxScaleDenominator < 0.0) {
            throw new IllegalArgumentException("Invalid max scale denominator, should be positive or 0");
        }
        this.maxScaleDenominator = maxScaleDenominator;
        return this;
    }

    public RuleBuilder<P> elseFilter() {
        this.unset = false;
        this.elseFilter = true;
        this.filter.unset();
        return this;
    }

    public RuleBuilder<P> filter(Filter filter) {
        this.unset = false;
        this.elseFilter = false;
        this.filter.reset(filter);
        return this;
    }

    public PointSymbolizerBuilder<RuleBuilder<P>> newPoint() {
        this.unset = false;
        if (this.symbolizerBuilder != null) {
            this.symbolizers.add(this.symbolizerBuilder.build());
        }
        this.symbolizerBuilder = new PointSymbolizerBuilder<RuleBuilder>(this);
        return (PointSymbolizerBuilder)this.symbolizerBuilder;
    }

    public LineSymbolizerBuilder<RuleBuilder<P>> newLine() {
        this.unset = false;
        if (this.symbolizerBuilder != null) {
            this.symbolizers.add(this.symbolizerBuilder.build());
        }
        this.symbolizerBuilder = new LineSymbolizerBuilder<RuleBuilder>(this);
        return (LineSymbolizerBuilder)this.symbolizerBuilder;
    }

    public PolygonSymbolizerBuilder<RuleBuilder<P>> newPolygon() {
        this.unset = false;
        if (this.symbolizerBuilder != null) {
            this.symbolizers.add(this.symbolizerBuilder.build());
        }
        this.symbolizerBuilder = new PolygonSymbolizerBuilder<RuleBuilder>(this);
        return (PolygonSymbolizerBuilder)this.symbolizerBuilder;
    }

    @Override
    public Rule build() {
        if (this.unset) {
            return null;
        }
        if (this.symbolizerBuilder == null) {
            this.symbolizerBuilder = new PointSymbolizerBuilder();
        }
        this.symbolizers.add(this.symbolizerBuilder.build());
        Rule rule = this.sf.createRule();
        rule.setName(this.name);
        rule.setTitle(this.title);
        rule.setAbstract(this.ruleAbstract);
        rule.setMinScaleDenominator(this.minScaleDenominator);
        rule.setMaxScaleDenominator(this.maxScaleDenominator);
        rule.setFilter(this.filter.build());
        rule.setElseFilter(this.elseFilter);
        rule.symbolizers().addAll(this.symbolizers);
        this.reset();
        return rule;
    }

    @Override
    public RuleBuilder<P> unset() {
        this.reset();
        this.unset = true;
        return this;
    }

    @Override
    public RuleBuilder<P> reset() {
        this.name = null;
        this.title = null;
        this.ruleAbstract = null;
        this.minScaleDenominator = 0.0;
        this.maxScaleDenominator = Double.POSITIVE_INFINITY;
        this.filter.reset((Filter)Filter.INCLUDE);
        this.elseFilter = false;
        this.symbolizers.clear();
        this.unset = false;
        return this;
    }

    @Override
    public RuleBuilder<P> reset(Rule rule) {
        if (rule == null) {
            return this.unset();
        }
        this.name = rule.getName();
        this.title = rule.getTitle();
        this.ruleAbstract = rule.getAbstract();
        this.minScaleDenominator = rule.getMinScaleDenominator();
        this.maxScaleDenominator = rule.getMaxScaleDenominator();
        this.filter.reset(rule.getFilter());
        this.elseFilter = rule.isElseFilter();
        this.symbolizers.clear();
        this.symbolizers.addAll(rule.symbolizers());
        this.unset = false;
        return this;
    }
}

