/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.caching.grid.spatialindex;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.geotools.caching.EvictableTree;
import org.geotools.caching.EvictionPolicy;
import org.geotools.caching.LRUEvictionPolicy;
import org.geotools.caching.grid.spatialindex.GridData;
import org.geotools.caching.grid.spatialindex.GridNode;
import org.geotools.caching.grid.spatialindex.GridRootNode;
import org.geotools.caching.grid.spatialindex.GridSpatialIndexStatistics;
import org.geotools.caching.grid.spatialindex.NodeCursor;
import org.geotools.caching.grid.spatialindex.store.StorageFactory;
import org.geotools.caching.spatialindex.AbstractSpatialIndex;
import org.geotools.caching.spatialindex.Node;
import org.geotools.caching.spatialindex.NodeIdentifier;
import org.geotools.caching.spatialindex.Region;
import org.geotools.caching.spatialindex.RegionNodeIdentifier;
import org.geotools.caching.spatialindex.Shape;
import org.geotools.caching.spatialindex.SpatialIndex;
import org.geotools.caching.spatialindex.Storage;
import org.geotools.caching.spatialindex.Visitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridSpatialIndex
extends AbstractSpatialIndex
implements EvictableTree {
    public static final String GRID_SIZE_PROPERTY = "Grid.GridSize";
    public static final String GRID_CAPACITY_PROPERTY = "Grid.GridCapacity";
    public static final String ROOT_MBR_MINX_PROPERTY = "Grid.RootMbrMinX";
    public static final String ROOT_MBR_MINY_PROPERTY = "Grid.RootMbrMinY";
    public static final String ROOT_MBR_MAXX_PROPERTY = "Grid.RootMbrMaxX";
    public static final String ROOT_MBR_MAXY_PROPERTY = "Grid.RootMbrMaxY";
    protected int MAX_INSERTION = 4;
    protected int gridsize;
    private int featureCapacity;
    protected Region mbr;
    private EvictionPolicy policy;
    private boolean doRecordAccess = true;

    public GridSpatialIndex(Region mbr, int gridsize, Storage store, int capacity) {
        this.gridsize = gridsize;
        this.mbr = mbr;
        this.store = store;
        this.stats = new GridSpatialIndexStatistics();
        this.policy = new LRUEvictionPolicy(this);
        this.featureCapacity = capacity;
        this.root = null;
        try {
            this.initializeFromStorage(this.store);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (this.root == null) {
            this.dimension = mbr.getDimension();
            this.store.clear();
            this.root = this.findUniqueInstance(new RegionNodeIdentifier(mbr));
            GridRootNode root = new GridRootNode(gridsize, (RegionNodeIdentifier)this.root);
            root.split(this);
            this.writeNode(root);
            this.stats.addToNodesCounter(root.getCapacity() + 1);
        }
    }

    protected GridSpatialIndex() {
    }

    public static SpatialIndex createInstance(Properties pset) {
        Storage storage = StorageFactory.getInstance().createStorage(pset);
        int gridsize = Integer.parseInt(pset.getProperty(GRID_SIZE_PROPERTY));
        int gridcapacity = Integer.parseInt(pset.getProperty(GRID_CAPACITY_PROPERTY));
        double minx = Double.parseDouble(pset.getProperty(ROOT_MBR_MINX_PROPERTY));
        double miny = Double.parseDouble(pset.getProperty(ROOT_MBR_MINY_PROPERTY));
        double maxx = Double.parseDouble(pset.getProperty(ROOT_MBR_MAXX_PROPERTY));
        double maxy = Double.parseDouble(pset.getProperty(ROOT_MBR_MAXY_PROPERTY));
        Region mbr = new Region(new double[]{minx, miny}, new double[]{maxx, maxy});
        GridSpatialIndex instance = new GridSpatialIndex(mbr, gridsize, storage, gridcapacity);
        return instance;
    }

    public GridRootNode getRootNode() {
        return (GridRootNode)this.rootNode;
    }

    public void dispose() {
        this.store.dispose();
    }

    @Override
    protected void visitData(Node n, Visitor v, Shape query, int type) {
        block3: {
            GridNode node;
            block2: {
                node = (GridNode)n;
                if (type != 2) break block2;
                for (GridData d : node.data) {
                    if (!query.intersects(d.getShape())) continue;
                    v.visitData(d);
                }
                break block3;
            }
            if (type != 1) break block3;
            for (GridData d : node.data) {
                if (!query.contains(d.getShape())) continue;
                v.visitData(d);
            }
        }
    }

    @Override
    public void clear() throws IllegalStateException {
        this.store.clear();
        this.root = this.findUniqueInstance(new RegionNodeIdentifier(this.mbr));
        GridRootNode root = new GridRootNode(this.gridsize, (RegionNodeIdentifier)this.root);
        root.split(this);
        this.writeNode(root);
        this.stats.reset();
        this.stats.addToNodesCounter(root.getCapacity() + 1);
        this.flush();
    }

    @Override
    public Properties getIndexProperties() {
        Properties pset = this.store.getPropertySet();
        pset.setProperty("SpatialIndex.Type", GridSpatialIndex.class.getCanonicalName());
        pset.setProperty(GRID_SIZE_PROPERTY, new Integer(this.gridsize).toString());
        pset.setProperty(GRID_CAPACITY_PROPERTY, new Integer(this.featureCapacity).toString());
        pset.setProperty(ROOT_MBR_MINX_PROPERTY, new Double(this.mbr.getLow(0)).toString());
        pset.setProperty(ROOT_MBR_MINY_PROPERTY, new Double(this.mbr.getLow(1)).toString());
        pset.setProperty(ROOT_MBR_MAXX_PROPERTY, new Double(this.mbr.getHigh(0)).toString());
        pset.setProperty(ROOT_MBR_MAXY_PROPERTY, new Double(this.mbr.getHigh(1)).toString());
        return pset;
    }

    private boolean insertDataToNode(GridNode node, Object data, Shape shape) {
        GridData gd = new GridData(shape, data);
        if (node.getIdentifier().isWritable() && node.insertData(gd)) {
            this.writeNode(node);
            return true;
        }
        return false;
    }

    private boolean insertDataToNodeID(NodeIdentifier n, Object data, Shape shape) {
        if (!n.isValid()) {
            return false;
        }
        GridNode node = (GridNode)this.readNode(n);
        return this.insertDataToNode(node, data, shape);
    }

    @Override
    protected void insertData(NodeIdentifier n, Object data, Shape shape) {
        NodeCursor cc = new NodeCursor(this.getRootNode(), shape);
        boolean added = false;
        if (cc.getChildCount() > this.MAX_INSERTION) {
            GridRootNode node = this.getRootNode();
            added = this.insertDataToNode(node, data, shape);
        } else {
            NodeIdentifier next = null;
            while ((next = cc.getNext()) != null) {
                if (!this.insertDataToNodeID(next, data, shape)) continue;
                added = true;
            }
        }
        if (added) {
            this.stats.addToDataCounter(1);
            String x = "abc";
        }
    }

    @Override
    protected void insertDataOutOfBounds(Object data, Shape shape) {
        throw new IllegalArgumentException("Grids cannot expand : Shape out of grid : " + shape);
    }

    @Override
    public boolean isIndexValid() {
        return true;
    }

    public NodeIdentifier findUniqueInstance(NodeIdentifier id) {
        return this.store.findUniqueInstance(id);
    }

    @Override
    public void initializeFromStorage(Storage storage) {
        Collection<FeatureType> types = this.store.getFeatureTypes();
        Iterator<FeatureType> iterator = types.iterator();
        while (iterator.hasNext()) {
            GridData.getFeatureMarshaller().registerType((SimpleFeatureType)iterator.next());
        }
        ReferencedEnvelope bounds = this.store.getBounds();
        if (bounds == null) {
            return;
        }
        this.mbr = new Region(new double[]{bounds.getMinX(), bounds.getMinY()}, new double[]{bounds.getMaxX(), bounds.getMaxY()});
        this.dimension = this.mbr.getDimension();
        NodeIdentifier id = this.findUniqueInstance(new RegionNodeIdentifier(this.mbr));
        this.rootNode = null;
        try {
            this.rootNode = storage.get(id);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (this.rootNode == null) {
            this.root = null;
        } else {
            this.stats.reset();
            this.root = this.rootNode.getIdentifier();
            this.gridsize = ((GridRootNode)this.rootNode).getCapacity();
            this.stats.addToDataCounter(((GridRootNode)this.rootNode).getCapacity() + 1);
            this.stats.addToDataCounter(this.rootNode.getDataCount());
            for (int i = 0; i < this.rootNode.getChildrenCount(); ++i) {
                RegionNodeIdentifier cid = (RegionNodeIdentifier)this.findUniqueInstance(this.rootNode.getChildIdentifier(i));
                ((GridRootNode)this.rootNode).setChildIdentifier(i, cid);
                if (!cid.isValid()) continue;
                Node n = this.readNode(cid);
                this.stats.addToDataCounter(n.getDataCount());
            }
        }
    }

    @Override
    protected void rangeQuery(int type, Shape query, Visitor v) {
        GridRootNode tmpRoot = (GridRootNode)this.rootNode;
        v.visitNode(tmpRoot);
        if (v.isDataVisitor()) {
            this.visitData(tmpRoot, v, query, type);
        }
        List<Integer> childrenindex = tmpRoot.getChildren(query);
        for (Integer childid : childrenindex) {
            NodeIdentifier child = tmpRoot.getChildIdentifier(childid);
            Node childNode = this.readNode(child);
            v.visitNode(childNode);
            if (!v.isDataVisitor()) continue;
            this.visitData(childNode, v, query, type);
        }
    }

    public List<NodeIdentifier>[] findMissingTiles(Region search) {
        ArrayList<NodeIdentifier> missing = new ArrayList<NodeIdentifier>();
        ArrayList<NodeIdentifier> found = new ArrayList<NodeIdentifier>();
        if (!this.root.isValid()) {
            NodeCursor cc = new NodeCursor(this.getRootNode(), search);
            NodeIdentifier next = null;
            while ((next = cc.getNext()) != null) {
                if (!next.isValid()) {
                    missing.add(next);
                    continue;
                }
                found.add(next);
            }
        }
        List[] ret = new List[]{missing, found};
        return ret;
    }

    public int getEvictions() {
        return this.getStatistics().getEvictions();
    }

    public EvictionPolicy getEvictionPolicy() {
        return this.policy;
    }

    @Override
    public void evict(NodeIdentifier node) {
        int ret = 0;
        int evictcnt = 1;
        GridNode nodeToEvict = (GridNode)this.readNode(node);
        ret = nodeToEvict.getDataCount();
        for (int i = 0; i < nodeToEvict.getChildrenCount(); ++i) {
            Node n = this.readNode(nodeToEvict.getChildIdentifier(i));
            ret += n.getDataCount();
            n.clear();
            this.writeNode(n);
            ++evictcnt;
        }
        nodeToEvict.clear();
        this.writeNode(nodeToEvict);
        this.getStatistics().addToDataCounter(-ret);
        this.getStatistics().addToEvictionCounter(evictcnt);
    }

    @Override
    public Node readNode(NodeIdentifier id) {
        if (this.doRecordAccess) {
            this.policy.access(id);
        }
        return super.readNode(id);
    }

    @Override
    public GridSpatialIndexStatistics getStatistics() {
        return (GridSpatialIndexStatistics)super.getStatistics();
    }

    @Override
    public void writeNode(Node node) {
        super.writeNode(node);
        if (this.doRecordAccess) {
            this.policy.access(node.getIdentifier());
        }
    }

    public boolean getDoRecordAccess() {
        return this.doRecordAccess;
    }

    public void setDoRecordAccess(boolean b) {
        this.doRecordAccess = b;
    }

    @Override
    public void insertData(Object data, Shape shape) {
        if (shape.getDimension() != this.dimension) {
            throw new IllegalArgumentException("insertData: Shape has the wrong number of dimensions.");
        }
        if (this.root.getShape().contains(shape)) {
            if (this.featureCapacity != Integer.MAX_VALUE) {
                while (this.getStatistics().getNumberOfData() >= (long)this.featureCapacity) {
                    if (this.getEvictionPolicy().evict()) continue;
                    NodeCursor cc = new NodeCursor(this.getRootNode(), shape);
                    NodeIdentifier next = null;
                    int cnt = 0;
                    while ((next = cc.getNext()) != null) {
                        Node n = this.readNode(next);
                        cnt += n.getDataCount();
                        n.clear();
                        this.writeNode(n);
                        this.getStatistics().addToEvictionCounter(1);
                    }
                    this.getStatistics().addToDataCounter(-cnt);
                    return;
                }
            }
            this.insertData(this.root, data, shape);
        } else {
            this.insertDataOutOfBounds(data, shape);
        }
    }
}

