/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.caching.grid.spatialindex;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.geotools.caching.spatialindex.Data;
import org.geotools.caching.spatialindex.Shape;
import org.geotools.caching.util.SimpleFeatureMarshaller;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridData
implements Data<Object>,
Externalizable {
    private static final long serialVersionUID = 2435341100521921266L;
    private static SimpleFeatureMarshaller marshaller = new SimpleFeatureMarshaller();
    private Shape shape;
    private Object data;
    private volatile int hashCode = 0;

    public GridData() {
    }

    public GridData(Shape shape, Object data) {
        this.shape = shape;
        this.data = data;
        this.hashCode = 0;
    }

    @Override
    public Object getData() {
        return this.data;
    }

    @Override
    public Shape getShape() {
        return this.shape;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int hash = 629 + this.shape.hashCode();
            this.hashCode = hash = 37 * hash + this.data.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o instanceof GridData) {
            return this.shape.equals(((GridData)o).shape) && this.data.equals(((GridData)o).data);
        }
        return false;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.shape = (Shape)in.readObject();
        if (in.readBoolean()) {
            try {
                this.data = GridData.getFeatureMarshaller().unmarshall(in);
            }
            catch (IllegalAttributeException e) {
                throw (IOException)new IOException().initCause(e);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw (IOException)new IOException().initCause(e);
            }
        }
        this.data = in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.shape);
        if (this.data instanceof SimpleFeature) {
            out.writeBoolean(true);
            try {
                GridData.getFeatureMarshaller().marshall((SimpleFeature)this.data, out);
            }
            catch (Exception ex) {
                throw (IOException)new IOException().initCause(ex);
            }
        } else {
            out.writeBoolean(false);
            out.writeObject(this.data);
        }
    }

    public static SimpleFeatureMarshaller getFeatureMarshaller() {
        return marshaller;
    }
}

