/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing.operation;

import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.NullOpImage;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.ViewType;
import org.geotools.coverage.processing.Operation2D;
import org.geotools.factory.Hints;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.resources.Classes;
import org.geotools.resources.coverage.CoverageUtilities;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.image.ColorUtilities;
import org.opengis.coverage.Coverage;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;

abstract class IndexColorOperation
extends Operation2D {
    public IndexColorOperation(DefaultParameterDescriptorGroup descriptor) {
        super((ParameterDescriptorGroup)descriptor);
    }

    public Coverage doOperation(ParameterValueGroup parameters, Hints hints) {
        GridCoverage2D source = (GridCoverage2D)parameters.parameter("Source").getValue();
        GridCoverage2D visual = source.view(ViewType.RENDERED);
        RenderedImage image = visual.getRenderedImage();
        GridSampleDimension[] bands = visual.getSampleDimensions();
        int visibleBand = CoverageUtilities.getVisibleBand(image);
        ColorModel model = image.getColorModel();
        boolean colorChanged = false;
        for (int i = 0; i < bands.length; ++i) {
            ColorModel candidate;
            GridSampleDimension band = bands[i];
            ColorModel colorModel = candidate = i == visibleBand ? image.getColorModel() : band.getColorModel();
            if (!(candidate instanceof IndexColorModel)) {
                throw new IllegalArgumentException(Errors.format((int)45, (Object)Classes.getClass((Object)candidate), IndexColorModel.class));
            }
            IndexColorModel colors = (IndexColorModel)candidate;
            int mapSize = colors.getMapSize();
            int[] ARGB = new int[mapSize];
            colors.getRGBs(ARGB);
            band = this.transformColormap(ARGB, i, band, parameters);
            if (!bands[i].equals(band)) {
                bands[i] = band;
                colorChanged = true;
            } else if (!colorChanged) {
                for (int j = 0; j < mapSize; ++j) {
                    if (ARGB[j] == colors.getRGB(j)) continue;
                    colorChanged = true;
                    break;
                }
            }
            if (!colorChanged || i != visibleBand) continue;
            model = ColorUtilities.getIndexColorModel(ARGB, bands.length, visibleBand);
        }
        if (!colorChanged) {
            return source;
        }
        ImageLayout layout = new ImageLayout().setColorModel(model);
        NullOpImage newImage = new NullOpImage(image, layout, null, 1);
        GridCoverage2D target = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)visual.getName(), (RenderedImage)newImage, visual.getCoordinateReferenceSystem2D(), visual.getGridGeometry().getGridToCRS(), bands, new GridCoverage[]{visual}, null);
        if (source != visual) {
            return target.geophysics(true);
        }
        return target;
    }

    protected abstract GridSampleDimension transformColormap(int[] var1, int var2, GridSampleDimension var3, ParameterValueGroup var4);
}

