/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io.mosaic;

import javax.imageio.ImageWriteParam;
import org.geotools.image.io.mosaic.Tile;
import org.geotools.image.io.mosaic.TileWritingPolicy;
import org.geotools.resources.i18n.Errors;

public class MosaicImageWriteParam
extends ImageWriteParam {
    private int outputIndex = 0;
    private TileWritingPolicy policy = TileWritingPolicy.OVERWRITE;

    public MosaicImageWriteParam() {
    }

    MosaicImageWriteParam(MosaicImageWriteParam copy) {
        this.outputIndex = copy.outputIndex;
        this.policy = copy.policy;
    }

    public int getOutputIndex() {
        return this.outputIndex;
    }

    public void setOutputIndex(int index) {
        if (index < 0 || index > 65535) {
            throw new IllegalArgumentException(Errors.format((int)201, (Object)index, (Object)0, (Object)65535));
        }
        this.outputIndex = index;
    }

    public TileWritingPolicy getTileWritingPolicy() {
        return this.policy;
    }

    public void setTileWritingPolicy(TileWritingPolicy policy) {
        Tile.ensureNonNull("policy", (Object)policy);
        this.policy = policy;
    }
}

